/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MFADevice
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MFADevice> {
    private static final SdkField<String> USER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserName").getter(MFADevice.getter(MFADevice::userName)).setter(MFADevice.setter(Builder::userName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()}).build();
    private static final SdkField<String> SERIAL_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SerialNumber").getter(MFADevice.getter(MFADevice::serialNumber)).setter(MFADevice.setter(Builder::serialNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SerialNumber").build()}).build();
    private static final SdkField<Instant> ENABLE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EnableDate").getter(MFADevice.getter(MFADevice::enableDate)).setter(MFADevice.setter(Builder::enableDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_NAME_FIELD, SERIAL_NUMBER_FIELD, ENABLE_DATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String userName;
    private final String serialNumber;
    private final Instant enableDate;

    private MFADevice(BuilderImpl builder) {
        this.userName = builder.userName;
        this.serialNumber = builder.serialNumber;
        this.enableDate = builder.enableDate;
    }

    public final String userName() {
        return this.userName;
    }

    public final String serialNumber() {
        return this.serialNumber;
    }

    public final Instant enableDate() {
        return this.enableDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serialNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MFADevice)) {
            return false;
        }
        MFADevice other = (MFADevice)obj;
        return Objects.equals(this.userName(), other.userName()) && Objects.equals(this.serialNumber(), other.serialNumber()) && Objects.equals(this.enableDate(), other.enableDate());
    }

    public final String toString() {
        return ToString.builder((String)"MFADevice").add("UserName", (Object)this.userName()).add("SerialNumber", (Object)this.serialNumber()).add("EnableDate", (Object)this.enableDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserName": {
                return Optional.ofNullable(clazz.cast(this.userName()));
            }
            case "SerialNumber": {
                return Optional.ofNullable(clazz.cast(this.serialNumber()));
            }
            case "EnableDate": {
                return Optional.ofNullable(clazz.cast(this.enableDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MFADevice, T> g) {
        return obj -> g.apply((MFADevice)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String userName;
        private String serialNumber;
        private Instant enableDate;

        private BuilderImpl() {
        }

        private BuilderImpl(MFADevice model) {
            this.userName(model.userName);
            this.serialNumber(model.serialNumber);
            this.enableDate(model.enableDate);
        }

        public final String getUserName() {
            return this.userName;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        @Transient
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final String getSerialNumber() {
            return this.serialNumber;
        }

        public final void setSerialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
        }

        @Override
        @Transient
        public final Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            return this;
        }

        public final Instant getEnableDate() {
            return this.enableDate;
        }

        public final void setEnableDate(Instant enableDate) {
            this.enableDate = enableDate;
        }

        @Override
        @Transient
        public final Builder enableDate(Instant enableDate) {
            this.enableDate = enableDate;
            return this;
        }

        public MFADevice build() {
            return new MFADevice(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MFADevice> {
        public Builder userName(String var1);

        public Builder serialNumber(String var1);

        public Builder enableDate(Instant var1);
    }
}

