/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateServerCertificateRequest extends IamRequest implements
        ToCopyableBuilder<UpdateServerCertificateRequest.Builder, UpdateServerCertificateRequest> {
    private static final SdkField<String> SERVER_CERTIFICATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerCertificateName").getter(getter(UpdateServerCertificateRequest::serverCertificateName))
            .setter(setter(Builder::serverCertificateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerCertificateName").build())
            .build();

    private static final SdkField<String> NEW_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NewPath").getter(getter(UpdateServerCertificateRequest::newPath)).setter(setter(Builder::newPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewPath").build()).build();

    private static final SdkField<String> NEW_SERVER_CERTIFICATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NewServerCertificateName").getter(getter(UpdateServerCertificateRequest::newServerCertificateName))
            .setter(setter(Builder::newServerCertificateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewServerCertificateName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_CERTIFICATE_NAME_FIELD,
            NEW_PATH_FIELD, NEW_SERVER_CERTIFICATE_NAME_FIELD));

    private final String serverCertificateName;

    private final String newPath;

    private final String newServerCertificateName;

    private UpdateServerCertificateRequest(BuilderImpl builder) {
        super(builder);
        this.serverCertificateName = builder.serverCertificateName;
        this.newPath = builder.newPath;
        this.newServerCertificateName = builder.newServerCertificateName;
    }

    /**
     * <p>
     * The name of the server certificate that you want to update.
     * </p>
     * <p>
     * This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of
     * characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of
     * the following characters: _+=,.@-
     * </p>
     * 
     * @return The name of the server certificate that you want to update.</p>
     *         <p>
     *         This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string
     *         of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also
     *         include any of the following characters: _+=,.@-
     */
    public final String serverCertificateName() {
        return serverCertificateName;
    }

    /**
     * <p>
     * The new path for the server certificate. Include this only if you are updating the server certificate's path.
     * </p>
     * <p>
     * This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of
     * characters consisting of either a forward slash (/) by itself or a string that must begin and end with forward
     * slashes. In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL
     * character (<code>\u007F</code>), including most punctuation characters, digits, and upper and lowercased letters.
     * </p>
     * 
     * @return The new path for the server certificate. Include this only if you are updating the server certificate's
     *         path.</p>
     *         <p>
     *         This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string
     *         of characters consisting of either a forward slash (/) by itself or a string that must begin and end with
     *         forward slashes. In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through
     *         the DEL character (<code>\u007F</code>), including most punctuation characters, digits, and upper and
     *         lowercased letters.
     */
    public final String newPath() {
        return newPath;
    }

    /**
     * <p>
     * The new name for the server certificate. Include this only if you are updating the server certificate's name. The
     * name of the certificate cannot contain any spaces.
     * </p>
     * <p>
     * This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of
     * characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of
     * the following characters: _+=,.@-
     * </p>
     * 
     * @return The new name for the server certificate. Include this only if you are updating the server certificate's
     *         name. The name of the certificate cannot contain any spaces.</p>
     *         <p>
     *         This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string
     *         of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also
     *         include any of the following characters: _+=,.@-
     */
    public final String newServerCertificateName() {
        return newServerCertificateName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serverCertificateName());
        hashCode = 31 * hashCode + Objects.hashCode(newPath());
        hashCode = 31 * hashCode + Objects.hashCode(newServerCertificateName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateServerCertificateRequest)) {
            return false;
        }
        UpdateServerCertificateRequest other = (UpdateServerCertificateRequest) obj;
        return Objects.equals(serverCertificateName(), other.serverCertificateName())
                && Objects.equals(newPath(), other.newPath())
                && Objects.equals(newServerCertificateName(), other.newServerCertificateName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateServerCertificateRequest").add("ServerCertificateName", serverCertificateName())
                .add("NewPath", newPath()).add("NewServerCertificateName", newServerCertificateName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServerCertificateName":
            return Optional.ofNullable(clazz.cast(serverCertificateName()));
        case "NewPath":
            return Optional.ofNullable(clazz.cast(newPath()));
        case "NewServerCertificateName":
            return Optional.ofNullable(clazz.cast(newServerCertificateName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateServerCertificateRequest, T> g) {
        return obj -> g.apply((UpdateServerCertificateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IamRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateServerCertificateRequest> {
        /**
         * <p>
         * The name of the server certificate that you want to update.
         * </p>
         * <p>
         * This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of
         * characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any
         * of the following characters: _+=,.@-
         * </p>
         * 
         * @param serverCertificateName
         *        The name of the server certificate that you want to update.</p>
         *        <p>
         *        This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a
         *        string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can
         *        also include any of the following characters: _+=,.@-
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverCertificateName(String serverCertificateName);

        /**
         * <p>
         * The new path for the server certificate. Include this only if you are updating the server certificate's path.
         * </p>
         * <p>
         * This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of
         * characters consisting of either a forward slash (/) by itself or a string that must begin and end with
         * forward slashes. In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the
         * DEL character (<code>\u007F</code>), including most punctuation characters, digits, and upper and lowercased
         * letters.
         * </p>
         * 
         * @param newPath
         *        The new path for the server certificate. Include this only if you are updating the server
         *        certificate's path.</p>
         *        <p>
         *        This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a
         *        string of characters consisting of either a forward slash (/) by itself or a string that must begin
         *        and end with forward slashes. In addition, it can contain any ASCII character from the ! (
         *        <code>\u0021</code>) through the DEL character (<code>\u007F</code>), including most punctuation
         *        characters, digits, and upper and lowercased letters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newPath(String newPath);

        /**
         * <p>
         * The new name for the server certificate. Include this only if you are updating the server certificate's name.
         * The name of the certificate cannot contain any spaces.
         * </p>
         * <p>
         * This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of
         * characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any
         * of the following characters: _+=,.@-
         * </p>
         * 
         * @param newServerCertificateName
         *        The new name for the server certificate. Include this only if you are updating the server
         *        certificate's name. The name of the certificate cannot contain any spaces.</p>
         *        <p>
         *        This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a
         *        string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can
         *        also include any of the following characters: _+=,.@-
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newServerCertificateName(String newServerCertificateName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IamRequest.BuilderImpl implements Builder {
        private String serverCertificateName;

        private String newPath;

        private String newServerCertificateName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateServerCertificateRequest model) {
            super(model);
            serverCertificateName(model.serverCertificateName);
            newPath(model.newPath);
            newServerCertificateName(model.newServerCertificateName);
        }

        public final String getServerCertificateName() {
            return serverCertificateName;
        }

        @Override
        public final Builder serverCertificateName(String serverCertificateName) {
            this.serverCertificateName = serverCertificateName;
            return this;
        }

        public final void setServerCertificateName(String serverCertificateName) {
            this.serverCertificateName = serverCertificateName;
        }

        public final String getNewPath() {
            return newPath;
        }

        @Override
        public final Builder newPath(String newPath) {
            this.newPath = newPath;
            return this;
        }

        public final void setNewPath(String newPath) {
            this.newPath = newPath;
        }

        public final String getNewServerCertificateName() {
            return newServerCertificateName;
        }

        @Override
        public final Builder newServerCertificateName(String newServerCertificateName) {
            this.newServerCertificateName = newServerCertificateName;
            return this;
        }

        public final void setNewServerCertificateName(String newServerCertificateName) {
            this.newServerCertificateName = newServerCertificateName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateServerCertificateRequest build() {
            return new UpdateServerCertificateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
