/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSamlProviderRequest extends IamRequest implements
        ToCopyableBuilder<UpdateSamlProviderRequest.Builder, UpdateSamlProviderRequest> {
    private static final SdkField<String> SAML_METADATA_DOCUMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SAMLMetadataDocument").getter(getter(UpdateSamlProviderRequest::samlMetadataDocument))
            .setter(setter(Builder::samlMetadataDocument))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SAMLMetadataDocument").build())
            .build();

    private static final SdkField<String> SAML_PROVIDER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SAMLProviderArn").getter(getter(UpdateSamlProviderRequest::samlProviderArn))
            .setter(setter(Builder::samlProviderArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SAMLProviderArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAML_METADATA_DOCUMENT_FIELD,
            SAML_PROVIDER_ARN_FIELD));

    private final String samlMetadataDocument;

    private final String samlProviderArn;

    private UpdateSamlProviderRequest(BuilderImpl builder) {
        super(builder);
        this.samlMetadataDocument = builder.samlMetadataDocument;
        this.samlProviderArn = builder.samlProviderArn;
    }

    /**
     * <p>
     * An XML document generated by an identity provider (IdP) that supports SAML 2.0. The document includes the
     * issuer's name, expiration information, and keys that can be used to validate the SAML authentication response
     * (assertions) that are received from the IdP. You must generate the metadata document using the identity
     * management software that is used as your organization's IdP.
     * </p>
     * 
     * @return An XML document generated by an identity provider (IdP) that supports SAML 2.0. The document includes the
     *         issuer's name, expiration information, and keys that can be used to validate the SAML authentication
     *         response (assertions) that are received from the IdP. You must generate the metadata document using the
     *         identity management software that is used as your organization's IdP.
     */
    public final String samlMetadataDocument() {
        return samlMetadataDocument;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the SAML provider to update.
     * </p>
     * <p>
     * For more information about ARNs, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     * (ARNs)</a> in the <i>AWS General Reference</i>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the SAML provider to update.</p>
     *         <p>
     *         For more information about ARNs, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     *         (ARNs)</a> in the <i>AWS General Reference</i>.
     */
    public final String samlProviderArn() {
        return samlProviderArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(samlMetadataDocument());
        hashCode = 31 * hashCode + Objects.hashCode(samlProviderArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSamlProviderRequest)) {
            return false;
        }
        UpdateSamlProviderRequest other = (UpdateSamlProviderRequest) obj;
        return Objects.equals(samlMetadataDocument(), other.samlMetadataDocument())
                && Objects.equals(samlProviderArn(), other.samlProviderArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSamlProviderRequest").add("SAMLMetadataDocument", samlMetadataDocument())
                .add("SAMLProviderArn", samlProviderArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SAMLMetadataDocument":
            return Optional.ofNullable(clazz.cast(samlMetadataDocument()));
        case "SAMLProviderArn":
            return Optional.ofNullable(clazz.cast(samlProviderArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSamlProviderRequest, T> g) {
        return obj -> g.apply((UpdateSamlProviderRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IamRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateSamlProviderRequest> {
        /**
         * <p>
         * An XML document generated by an identity provider (IdP) that supports SAML 2.0. The document includes the
         * issuer's name, expiration information, and keys that can be used to validate the SAML authentication response
         * (assertions) that are received from the IdP. You must generate the metadata document using the identity
         * management software that is used as your organization's IdP.
         * </p>
         * 
         * @param samlMetadataDocument
         *        An XML document generated by an identity provider (IdP) that supports SAML 2.0. The document includes
         *        the issuer's name, expiration information, and keys that can be used to validate the SAML
         *        authentication response (assertions) that are received from the IdP. You must generate the metadata
         *        document using the identity management software that is used as your organization's IdP.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder samlMetadataDocument(String samlMetadataDocument);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the SAML provider to update.
         * </p>
         * <p>
         * For more information about ARNs, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
         * (ARNs)</a> in the <i>AWS General Reference</i>.
         * </p>
         * 
         * @param samlProviderArn
         *        The Amazon Resource Name (ARN) of the SAML provider to update.</p>
         *        <p>
         *        For more information about ARNs, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
         *        Names (ARNs)</a> in the <i>AWS General Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder samlProviderArn(String samlProviderArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IamRequest.BuilderImpl implements Builder {
        private String samlMetadataDocument;

        private String samlProviderArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSamlProviderRequest model) {
            super(model);
            samlMetadataDocument(model.samlMetadataDocument);
            samlProviderArn(model.samlProviderArn);
        }

        public final String getSamlMetadataDocument() {
            return samlMetadataDocument;
        }

        @Override
        public final Builder samlMetadataDocument(String samlMetadataDocument) {
            this.samlMetadataDocument = samlMetadataDocument;
            return this;
        }

        public final void setSamlMetadataDocument(String samlMetadataDocument) {
            this.samlMetadataDocument = samlMetadataDocument;
        }

        public final String getSamlProviderArn() {
            return samlProviderArn;
        }

        @Override
        public final Builder samlProviderArn(String samlProviderArn) {
            this.samlProviderArn = samlProviderArn;
            return this;
        }

        public final void setSamlProviderArn(String samlProviderArn) {
            this.samlProviderArn = samlProviderArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSamlProviderRequest build() {
            return new UpdateSamlProviderRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
