/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the row and column of a location of a <code>Statement</code> element in a policy document.
 * </p>
 * <p>
 * This data type is used as a member of the <code> <a>Statement</a> </code> type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Position implements SdkPojo, Serializable, ToCopyableBuilder<Position.Builder, Position> {
    private static final SdkField<Integer> LINE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Line")
            .getter(getter(Position::line)).setter(setter(Builder::line))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Line").build()).build();

    private static final SdkField<Integer> COLUMN_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Column").getter(getter(Position::column)).setter(setter(Builder::column))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Column").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LINE_FIELD, COLUMN_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer line;

    private final Integer column;

    private Position(BuilderImpl builder) {
        this.line = builder.line;
        this.column = builder.column;
    }

    /**
     * <p>
     * The line containing the specified position in the document.
     * </p>
     * 
     * @return The line containing the specified position in the document.
     */
    public final Integer line() {
        return line;
    }

    /**
     * <p>
     * The column in the line containing the specified position in the document.
     * </p>
     * 
     * @return The column in the line containing the specified position in the document.
     */
    public final Integer column() {
        return column;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(line());
        hashCode = 31 * hashCode + Objects.hashCode(column());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Position)) {
            return false;
        }
        Position other = (Position) obj;
        return Objects.equals(line(), other.line()) && Objects.equals(column(), other.column());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Position").add("Line", line()).add("Column", column()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Line":
            return Optional.ofNullable(clazz.cast(line()));
        case "Column":
            return Optional.ofNullable(clazz.cast(column()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Position, T> g) {
        return obj -> g.apply((Position) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Position> {
        /**
         * <p>
         * The line containing the specified position in the document.
         * </p>
         * 
         * @param line
         *        The line containing the specified position in the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder line(Integer line);

        /**
         * <p>
         * The column in the line containing the specified position in the document.
         * </p>
         * 
         * @param column
         *        The column in the line containing the specified position in the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder column(Integer column);
    }

    static final class BuilderImpl implements Builder {
        private Integer line;

        private Integer column;

        private BuilderImpl() {
        }

        private BuilderImpl(Position model) {
            line(model.line);
            column(model.column);
        }

        public final Integer getLine() {
            return line;
        }

        @Override
        public final Builder line(Integer line) {
            this.line = line;
            return this;
        }

        public final void setLine(Integer line) {
            this.line = line;
        }

        public final Integer getColumn() {
            return column;
        }

        @Override
        public final Builder column(Integer column) {
            this.column = column;
            return this;
        }

        public final void setColumn(Integer column) {
            this.column = column;
        }

        @Override
        public Position build() {
            return new Position(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
