/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListVirtualMfaDevicesRequest extends IamRequest implements
        ToCopyableBuilder<ListVirtualMfaDevicesRequest.Builder, ListVirtualMfaDevicesRequest> {
    private static final SdkField<String> ASSIGNMENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssignmentStatus").getter(getter(ListVirtualMfaDevicesRequest::assignmentStatusAsString))
            .setter(setter(Builder::assignmentStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssignmentStatus").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(ListVirtualMfaDevicesRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxItems").getter(getter(ListVirtualMfaDevicesRequest::maxItems)).setter(setter(Builder::maxItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxItems").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSIGNMENT_STATUS_FIELD,
            MARKER_FIELD, MAX_ITEMS_FIELD));

    private final String assignmentStatus;

    private final String marker;

    private final Integer maxItems;

    private ListVirtualMfaDevicesRequest(BuilderImpl builder) {
        super(builder);
        this.assignmentStatus = builder.assignmentStatus;
        this.marker = builder.marker;
        this.maxItems = builder.maxItems;
    }

    /**
     * <p>
     * The status (<code>Unassigned</code> or <code>Assigned</code>) of the devices to list. If you do not specify an
     * <code>AssignmentStatus</code>, the operation defaults to <code>Any</code>, which lists both assigned and
     * unassigned virtual MFA devices.,
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #assignmentStatus}
     * will return {@link AssignmentStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #assignmentStatusAsString}.
     * </p>
     * 
     * @return The status (<code>Unassigned</code> or <code>Assigned</code>) of the devices to list. If you do not
     *         specify an <code>AssignmentStatus</code>, the operation defaults to <code>Any</code>, which lists both
     *         assigned and unassigned virtual MFA devices.,
     * @see AssignmentStatusType
     */
    public final AssignmentStatusType assignmentStatus() {
        return AssignmentStatusType.fromValue(assignmentStatus);
    }

    /**
     * <p>
     * The status (<code>Unassigned</code> or <code>Assigned</code>) of the devices to list. If you do not specify an
     * <code>AssignmentStatus</code>, the operation defaults to <code>Any</code>, which lists both assigned and
     * unassigned virtual MFA devices.,
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #assignmentStatus}
     * will return {@link AssignmentStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #assignmentStatusAsString}.
     * </p>
     * 
     * @return The status (<code>Unassigned</code> or <code>Assigned</code>) of the devices to list. If you do not
     *         specify an <code>AssignmentStatus</code>, the operation defaults to <code>Any</code>, which lists both
     *         assigned and unassigned virtual MFA devices.,
     * @see AssignmentStatusType
     */
    public final String assignmentStatusAsString() {
        return assignmentStatus;
    }

    /**
     * <p>
     * Use this parameter only when paginating results and only after you receive a response indicating that the results
     * are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to
     * indicate where the next call should start.
     * </p>
     * 
     * @return Use this parameter only when paginating results and only after you receive a response indicating that the
     *         results are truncated. Set it to the value of the <code>Marker</code> element in the response that you
     *         received to indicate where the next call should start.
     */
    public final String marker() {
        return marker;
    }

    /**
     * <p>
     * Use this only when paginating results to indicate the maximum number of items you want in the response. If
     * additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element is
     * <code>true</code>.
     * </p>
     * <p>
     * If you do not include this parameter, the number of items defaults to 100. Note that IAM might return fewer
     * results, even when there are more results available. In that case, the <code>IsTruncated</code> response element
     * returns <code>true</code>, and <code>Marker</code> contains a value to include in the subsequent call that tells
     * the service where to continue from.
     * </p>
     * 
     * @return Use this only when paginating results to indicate the maximum number of items you want in the response.
     *         If additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element
     *         is <code>true</code>.</p>
     *         <p>
     *         If you do not include this parameter, the number of items defaults to 100. Note that IAM might return
     *         fewer results, even when there are more results available. In that case, the <code>IsTruncated</code>
     *         response element returns <code>true</code>, and <code>Marker</code> contains a value to include in the
     *         subsequent call that tells the service where to continue from.
     */
    public final Integer maxItems() {
        return maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assignmentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVirtualMfaDevicesRequest)) {
            return false;
        }
        ListVirtualMfaDevicesRequest other = (ListVirtualMfaDevicesRequest) obj;
        return Objects.equals(assignmentStatusAsString(), other.assignmentStatusAsString())
                && Objects.equals(marker(), other.marker()) && Objects.equals(maxItems(), other.maxItems());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListVirtualMfaDevicesRequest").add("AssignmentStatus", assignmentStatusAsString())
                .add("Marker", marker()).add("MaxItems", maxItems()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssignmentStatus":
            return Optional.ofNullable(clazz.cast(assignmentStatusAsString()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "MaxItems":
            return Optional.ofNullable(clazz.cast(maxItems()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListVirtualMfaDevicesRequest, T> g) {
        return obj -> g.apply((ListVirtualMfaDevicesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IamRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListVirtualMfaDevicesRequest> {
        /**
         * <p>
         * The status (<code>Unassigned</code> or <code>Assigned</code>) of the devices to list. If you do not specify
         * an <code>AssignmentStatus</code>, the operation defaults to <code>Any</code>, which lists both assigned and
         * unassigned virtual MFA devices.,
         * </p>
         * 
         * @param assignmentStatus
         *        The status (<code>Unassigned</code> or <code>Assigned</code>) of the devices to list. If you do not
         *        specify an <code>AssignmentStatus</code>, the operation defaults to <code>Any</code>, which lists both
         *        assigned and unassigned virtual MFA devices.,
         * @see AssignmentStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssignmentStatusType
         */
        Builder assignmentStatus(String assignmentStatus);

        /**
         * <p>
         * The status (<code>Unassigned</code> or <code>Assigned</code>) of the devices to list. If you do not specify
         * an <code>AssignmentStatus</code>, the operation defaults to <code>Any</code>, which lists both assigned and
         * unassigned virtual MFA devices.,
         * </p>
         * 
         * @param assignmentStatus
         *        The status (<code>Unassigned</code> or <code>Assigned</code>) of the devices to list. If you do not
         *        specify an <code>AssignmentStatus</code>, the operation defaults to <code>Any</code>, which lists both
         *        assigned and unassigned virtual MFA devices.,
         * @see AssignmentStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssignmentStatusType
         */
        Builder assignmentStatus(AssignmentStatusType assignmentStatus);

        /**
         * <p>
         * Use this parameter only when paginating results and only after you receive a response indicating that the
         * results are truncated. Set it to the value of the <code>Marker</code> element in the response that you
         * received to indicate where the next call should start.
         * </p>
         * 
         * @param marker
         *        Use this parameter only when paginating results and only after you receive a response indicating that
         *        the results are truncated. Set it to the value of the <code>Marker</code> element in the response that
         *        you received to indicate where the next call should start.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * Use this only when paginating results to indicate the maximum number of items you want in the response. If
         * additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element is
         * <code>true</code>.
         * </p>
         * <p>
         * If you do not include this parameter, the number of items defaults to 100. Note that IAM might return fewer
         * results, even when there are more results available. In that case, the <code>IsTruncated</code> response
         * element returns <code>true</code>, and <code>Marker</code> contains a value to include in the subsequent call
         * that tells the service where to continue from.
         * </p>
         * 
         * @param maxItems
         *        Use this only when paginating results to indicate the maximum number of items you want in the
         *        response. If additional items exist beyond the maximum you specify, the <code>IsTruncated</code>
         *        response element is <code>true</code>.</p>
         *        <p>
         *        If you do not include this parameter, the number of items defaults to 100. Note that IAM might return
         *        fewer results, even when there are more results available. In that case, the <code>IsTruncated</code>
         *        response element returns <code>true</code>, and <code>Marker</code> contains a value to include in the
         *        subsequent call that tells the service where to continue from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(Integer maxItems);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IamRequest.BuilderImpl implements Builder {
        private String assignmentStatus;

        private String marker;

        private Integer maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListVirtualMfaDevicesRequest model) {
            super(model);
            assignmentStatus(model.assignmentStatus);
            marker(model.marker);
            maxItems(model.maxItems);
        }

        public final String getAssignmentStatus() {
            return assignmentStatus;
        }

        @Override
        public final Builder assignmentStatus(String assignmentStatus) {
            this.assignmentStatus = assignmentStatus;
            return this;
        }

        @Override
        public final Builder assignmentStatus(AssignmentStatusType assignmentStatus) {
            this.assignmentStatus(assignmentStatus == null ? null : assignmentStatus.toString());
            return this;
        }

        public final void setAssignmentStatus(String assignmentStatus) {
            this.assignmentStatus = assignmentStatus;
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Integer getMaxItems() {
            return maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListVirtualMfaDevicesRequest build() {
            return new ListVirtualMfaDevicesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
