/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListServiceSpecificCredentialsResponse extends IamResponse implements
        ToCopyableBuilder<ListServiceSpecificCredentialsResponse.Builder, ListServiceSpecificCredentialsResponse> {
    private static final SdkField<List<ServiceSpecificCredentialMetadata>> SERVICE_SPECIFIC_CREDENTIALS_FIELD = SdkField
            .<List<ServiceSpecificCredentialMetadata>> builder(MarshallingType.LIST)
            .memberName("ServiceSpecificCredentials")
            .getter(getter(ListServiceSpecificCredentialsResponse::serviceSpecificCredentials))
            .setter(setter(Builder::serviceSpecificCredentials))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceSpecificCredentials").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ServiceSpecificCredentialMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServiceSpecificCredentialMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SERVICE_SPECIFIC_CREDENTIALS_FIELD));

    private final List<ServiceSpecificCredentialMetadata> serviceSpecificCredentials;

    private ListServiceSpecificCredentialsResponse(BuilderImpl builder) {
        super(builder);
        this.serviceSpecificCredentials = builder.serviceSpecificCredentials;
    }

    /**
     * Returns true if the ServiceSpecificCredentials property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public final boolean hasServiceSpecificCredentials() {
        return serviceSpecificCredentials != null && !(serviceSpecificCredentials instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of structures that each contain details about a service-specific credential.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasServiceSpecificCredentials()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of structures that each contain details about a service-specific credential.
     */
    public final List<ServiceSpecificCredentialMetadata> serviceSpecificCredentials() {
        return serviceSpecificCredentials;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasServiceSpecificCredentials() ? serviceSpecificCredentials() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServiceSpecificCredentialsResponse)) {
            return false;
        }
        ListServiceSpecificCredentialsResponse other = (ListServiceSpecificCredentialsResponse) obj;
        return hasServiceSpecificCredentials() == other.hasServiceSpecificCredentials()
                && Objects.equals(serviceSpecificCredentials(), other.serviceSpecificCredentials());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListServiceSpecificCredentialsResponse")
                .add("ServiceSpecificCredentials", hasServiceSpecificCredentials() ? serviceSpecificCredentials() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceSpecificCredentials":
            return Optional.ofNullable(clazz.cast(serviceSpecificCredentials()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListServiceSpecificCredentialsResponse, T> g) {
        return obj -> g.apply((ListServiceSpecificCredentialsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IamResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListServiceSpecificCredentialsResponse> {
        /**
         * <p>
         * A list of structures that each contain details about a service-specific credential.
         * </p>
         * 
         * @param serviceSpecificCredentials
         *        A list of structures that each contain details about a service-specific credential.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceSpecificCredentials(Collection<ServiceSpecificCredentialMetadata> serviceSpecificCredentials);

        /**
         * <p>
         * A list of structures that each contain details about a service-specific credential.
         * </p>
         * 
         * @param serviceSpecificCredentials
         *        A list of structures that each contain details about a service-specific credential.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceSpecificCredentials(ServiceSpecificCredentialMetadata... serviceSpecificCredentials);

        /**
         * <p>
         * A list of structures that each contain details about a service-specific credential.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ServiceSpecificCredentialMetadata>.Builder}
         * avoiding the need to create one manually via {@link List<ServiceSpecificCredentialMetadata>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ServiceSpecificCredentialMetadata>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #serviceSpecificCredentials(List<ServiceSpecificCredentialMetadata>)}.
         * 
         * @param serviceSpecificCredentials
         *        a consumer that will call methods on {@link List<ServiceSpecificCredentialMetadata>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceSpecificCredentials(List<ServiceSpecificCredentialMetadata>)
         */
        Builder serviceSpecificCredentials(Consumer<ServiceSpecificCredentialMetadata.Builder>... serviceSpecificCredentials);
    }

    static final class BuilderImpl extends IamResponse.BuilderImpl implements Builder {
        private List<ServiceSpecificCredentialMetadata> serviceSpecificCredentials = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListServiceSpecificCredentialsResponse model) {
            super(model);
            serviceSpecificCredentials(model.serviceSpecificCredentials);
        }

        public final Collection<ServiceSpecificCredentialMetadata.Builder> getServiceSpecificCredentials() {
            if (serviceSpecificCredentials instanceof SdkAutoConstructList) {
                return null;
            }
            return serviceSpecificCredentials != null ? serviceSpecificCredentials.stream()
                    .map(ServiceSpecificCredentialMetadata::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder serviceSpecificCredentials(Collection<ServiceSpecificCredentialMetadata> serviceSpecificCredentials) {
            this.serviceSpecificCredentials = ServiceSpecificCredentialsListTypeCopier.copy(serviceSpecificCredentials);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceSpecificCredentials(ServiceSpecificCredentialMetadata... serviceSpecificCredentials) {
            serviceSpecificCredentials(Arrays.asList(serviceSpecificCredentials));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceSpecificCredentials(
                Consumer<ServiceSpecificCredentialMetadata.Builder>... serviceSpecificCredentials) {
            serviceSpecificCredentials(Stream.of(serviceSpecificCredentials)
                    .map(c -> ServiceSpecificCredentialMetadata.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setServiceSpecificCredentials(
                Collection<ServiceSpecificCredentialMetadata.BuilderImpl> serviceSpecificCredentials) {
            this.serviceSpecificCredentials = ServiceSpecificCredentialsListTypeCopier
                    .copyFromBuilder(serviceSpecificCredentials);
        }

        @Override
        public ListServiceSpecificCredentialsResponse build() {
            return new ListServiceSpecificCredentialsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
