/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPoliciesGrantingServiceAccessResponse extends IamResponse implements
        ToCopyableBuilder<ListPoliciesGrantingServiceAccessResponse.Builder, ListPoliciesGrantingServiceAccessResponse> {
    private static final SdkField<List<ListPoliciesGrantingServiceAccessEntry>> POLICIES_GRANTING_SERVICE_ACCESS_FIELD = SdkField
            .<List<ListPoliciesGrantingServiceAccessEntry>> builder(MarshallingType.LIST)
            .memberName("PoliciesGrantingServiceAccess")
            .getter(getter(ListPoliciesGrantingServiceAccessResponse::policiesGrantingServiceAccess))
            .setter(setter(Builder::policiesGrantingServiceAccess))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoliciesGrantingServiceAccess")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ListPoliciesGrantingServiceAccessEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(ListPoliciesGrantingServiceAccessEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> IS_TRUNCATED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsTruncated").getter(getter(ListPoliciesGrantingServiceAccessResponse::isTruncated))
            .setter(setter(Builder::isTruncated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsTruncated").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(ListPoliciesGrantingServiceAccessResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            POLICIES_GRANTING_SERVICE_ACCESS_FIELD, IS_TRUNCATED_FIELD, MARKER_FIELD));

    private final List<ListPoliciesGrantingServiceAccessEntry> policiesGrantingServiceAccess;

    private final Boolean isTruncated;

    private final String marker;

    private ListPoliciesGrantingServiceAccessResponse(BuilderImpl builder) {
        super(builder);
        this.policiesGrantingServiceAccess = builder.policiesGrantingServiceAccess;
        this.isTruncated = builder.isTruncated;
        this.marker = builder.marker;
    }

    /**
     * Returns true if the PoliciesGrantingServiceAccess property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public final boolean hasPoliciesGrantingServiceAccess() {
        return policiesGrantingServiceAccess != null && !(policiesGrantingServiceAccess instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A <code>ListPoliciesGrantingServiceAccess</code> object that contains details about the permissions policies
     * attached to the specified identity (user, group, or role).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPoliciesGrantingServiceAccess()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A <code>ListPoliciesGrantingServiceAccess</code> object that contains details about the permissions
     *         policies attached to the specified identity (user, group, or role).
     */
    public final List<ListPoliciesGrantingServiceAccessEntry> policiesGrantingServiceAccess() {
        return policiesGrantingServiceAccess;
    }

    /**
     * <p>
     * A flag that indicates whether there are more items to return. If your results were truncated, you can make a
     * subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. We
     * recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.
     * </p>
     * 
     * @return A flag that indicates whether there are more items to return. If your results were truncated, you can
     *         make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more
     *         items. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive
     *         all your results.
     */
    public final Boolean isTruncated() {
        return isTruncated;
    }

    /**
     * <p>
     * When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the
     * <code>Marker</code> parameter in a subsequent pagination request.
     * </p>
     * 
     * @return When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use
     *         for the <code>Marker</code> parameter in a subsequent pagination request.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPoliciesGrantingServiceAccess() ? policiesGrantingServiceAccess() : null);
        hashCode = 31 * hashCode + Objects.hashCode(isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPoliciesGrantingServiceAccessResponse)) {
            return false;
        }
        ListPoliciesGrantingServiceAccessResponse other = (ListPoliciesGrantingServiceAccessResponse) obj;
        return hasPoliciesGrantingServiceAccess() == other.hasPoliciesGrantingServiceAccess()
                && Objects.equals(policiesGrantingServiceAccess(), other.policiesGrantingServiceAccess())
                && Objects.equals(isTruncated(), other.isTruncated()) && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ListPoliciesGrantingServiceAccessResponse")
                .add("PoliciesGrantingServiceAccess", hasPoliciesGrantingServiceAccess() ? policiesGrantingServiceAccess() : null)
                .add("IsTruncated", isTruncated()).add("Marker", marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PoliciesGrantingServiceAccess":
            return Optional.ofNullable(clazz.cast(policiesGrantingServiceAccess()));
        case "IsTruncated":
            return Optional.ofNullable(clazz.cast(isTruncated()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPoliciesGrantingServiceAccessResponse, T> g) {
        return obj -> g.apply((ListPoliciesGrantingServiceAccessResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IamResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListPoliciesGrantingServiceAccessResponse> {
        /**
         * <p>
         * A <code>ListPoliciesGrantingServiceAccess</code> object that contains details about the permissions policies
         * attached to the specified identity (user, group, or role).
         * </p>
         * 
         * @param policiesGrantingServiceAccess
         *        A <code>ListPoliciesGrantingServiceAccess</code> object that contains details about the permissions
         *        policies attached to the specified identity (user, group, or role).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policiesGrantingServiceAccess(Collection<ListPoliciesGrantingServiceAccessEntry> policiesGrantingServiceAccess);

        /**
         * <p>
         * A <code>ListPoliciesGrantingServiceAccess</code> object that contains details about the permissions policies
         * attached to the specified identity (user, group, or role).
         * </p>
         * 
         * @param policiesGrantingServiceAccess
         *        A <code>ListPoliciesGrantingServiceAccess</code> object that contains details about the permissions
         *        policies attached to the specified identity (user, group, or role).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policiesGrantingServiceAccess(ListPoliciesGrantingServiceAccessEntry... policiesGrantingServiceAccess);

        /**
         * <p>
         * A <code>ListPoliciesGrantingServiceAccess</code> object that contains details about the permissions policies
         * attached to the specified identity (user, group, or role).
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <ListPoliciesGrantingServiceAccessEntry>.Builder} avoiding the need to create one manually via {@link List
         * <ListPoliciesGrantingServiceAccessEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ListPoliciesGrantingServiceAccessEntry>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #policiesGrantingServiceAccess(List<ListPoliciesGrantingServiceAccessEntry>)}.
         * 
         * @param policiesGrantingServiceAccess
         *        a consumer that will call methods on {@link List<ListPoliciesGrantingServiceAccessEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policiesGrantingServiceAccess(List<ListPoliciesGrantingServiceAccessEntry>)
         */
        Builder policiesGrantingServiceAccess(
                Consumer<ListPoliciesGrantingServiceAccessEntry.Builder>... policiesGrantingServiceAccess);

        /**
         * <p>
         * A flag that indicates whether there are more items to return. If your results were truncated, you can make a
         * subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. We
         * recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your
         * results.
         * </p>
         * 
         * @param isTruncated
         *        A flag that indicates whether there are more items to return. If your results were truncated, you can
         *        make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more
         *        items. We recommend that you check <code>IsTruncated</code> after every call to ensure that you
         *        receive all your results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isTruncated(Boolean isTruncated);

        /**
         * <p>
         * When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for
         * the <code>Marker</code> parameter in a subsequent pagination request.
         * </p>
         * 
         * @param marker
         *        When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to
         *        use for the <code>Marker</code> parameter in a subsequent pagination request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);
    }

    static final class BuilderImpl extends IamResponse.BuilderImpl implements Builder {
        private List<ListPoliciesGrantingServiceAccessEntry> policiesGrantingServiceAccess = DefaultSdkAutoConstructList
                .getInstance();

        private Boolean isTruncated;

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPoliciesGrantingServiceAccessResponse model) {
            super(model);
            policiesGrantingServiceAccess(model.policiesGrantingServiceAccess);
            isTruncated(model.isTruncated);
            marker(model.marker);
        }

        public final Collection<ListPoliciesGrantingServiceAccessEntry.Builder> getPoliciesGrantingServiceAccess() {
            if (policiesGrantingServiceAccess instanceof SdkAutoConstructList) {
                return null;
            }
            return policiesGrantingServiceAccess != null ? policiesGrantingServiceAccess.stream()
                    .map(ListPoliciesGrantingServiceAccessEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder policiesGrantingServiceAccess(
                Collection<ListPoliciesGrantingServiceAccessEntry> policiesGrantingServiceAccess) {
            this.policiesGrantingServiceAccess = _listPolicyGrantingServiceAccessResponseListTypeCopier
                    .copy(policiesGrantingServiceAccess);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policiesGrantingServiceAccess(
                ListPoliciesGrantingServiceAccessEntry... policiesGrantingServiceAccess) {
            policiesGrantingServiceAccess(Arrays.asList(policiesGrantingServiceAccess));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policiesGrantingServiceAccess(
                Consumer<ListPoliciesGrantingServiceAccessEntry.Builder>... policiesGrantingServiceAccess) {
            policiesGrantingServiceAccess(Stream.of(policiesGrantingServiceAccess)
                    .map(c -> ListPoliciesGrantingServiceAccessEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPoliciesGrantingServiceAccess(
                Collection<ListPoliciesGrantingServiceAccessEntry.BuilderImpl> policiesGrantingServiceAccess) {
            this.policiesGrantingServiceAccess = _listPolicyGrantingServiceAccessResponseListTypeCopier
                    .copyFromBuilder(policiesGrantingServiceAccess);
        }

        public final Boolean getIsTruncated() {
            return isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public ListPoliciesGrantingServiceAccessResponse build() {
            return new ListPoliciesGrantingServiceAccessResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
