/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a successful <a>ListMFADevices</a> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListMfaDevicesResponse extends IamResponse implements
        ToCopyableBuilder<ListMfaDevicesResponse.Builder, ListMfaDevicesResponse> {
    private static final SdkField<List<MFADevice>> MFA_DEVICES_FIELD = SdkField
            .<List<MFADevice>> builder(MarshallingType.LIST)
            .memberName("MFADevices")
            .getter(getter(ListMfaDevicesResponse::mfaDevices))
            .setter(setter(Builder::mfaDevices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MFADevices").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MFADevice> builder(MarshallingType.SDK_POJO)
                                            .constructor(MFADevice::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> IS_TRUNCATED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsTruncated").getter(getter(ListMfaDevicesResponse::isTruncated)).setter(setter(Builder::isTruncated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsTruncated").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(ListMfaDevicesResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MFA_DEVICES_FIELD,
            IS_TRUNCATED_FIELD, MARKER_FIELD));

    private final List<MFADevice> mfaDevices;

    private final Boolean isTruncated;

    private final String marker;

    private ListMfaDevicesResponse(BuilderImpl builder) {
        super(builder);
        this.mfaDevices = builder.mfaDevices;
        this.isTruncated = builder.isTruncated;
        this.marker = builder.marker;
    }

    /**
     * Returns true if the MFADevices property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasMfaDevices() {
        return mfaDevices != null && !(mfaDevices instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of MFA devices.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMfaDevices()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of MFA devices.
     */
    public final List<MFADevice> mfaDevices() {
        return mfaDevices;
    }

    /**
     * <p>
     * A flag that indicates whether there are more items to return. If your results were truncated, you can make a
     * subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that
     * IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results
     * available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all
     * your results.
     * </p>
     * 
     * @return A flag that indicates whether there are more items to return. If your results were truncated, you can
     *         make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more
     *         items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there
     *         are more results available. We recommend that you check <code>IsTruncated</code> after every call to
     *         ensure that you receive all your results.
     */
    public final Boolean isTruncated() {
        return isTruncated;
    }

    /**
     * <p>
     * When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the
     * <code>Marker</code> parameter in a subsequent pagination request.
     * </p>
     * 
     * @return When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use
     *         for the <code>Marker</code> parameter in a subsequent pagination request.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasMfaDevices() ? mfaDevices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMfaDevicesResponse)) {
            return false;
        }
        ListMfaDevicesResponse other = (ListMfaDevicesResponse) obj;
        return hasMfaDevices() == other.hasMfaDevices() && Objects.equals(mfaDevices(), other.mfaDevices())
                && Objects.equals(isTruncated(), other.isTruncated()) && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListMfaDevicesResponse").add("MFADevices", hasMfaDevices() ? mfaDevices() : null)
                .add("IsTruncated", isTruncated()).add("Marker", marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MFADevices":
            return Optional.ofNullable(clazz.cast(mfaDevices()));
        case "IsTruncated":
            return Optional.ofNullable(clazz.cast(isTruncated()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListMfaDevicesResponse, T> g) {
        return obj -> g.apply((ListMfaDevicesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IamResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListMfaDevicesResponse> {
        /**
         * <p>
         * A list of MFA devices.
         * </p>
         * 
         * @param mfaDevices
         *        A list of MFA devices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mfaDevices(Collection<MFADevice> mfaDevices);

        /**
         * <p>
         * A list of MFA devices.
         * </p>
         * 
         * @param mfaDevices
         *        A list of MFA devices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mfaDevices(MFADevice... mfaDevices);

        /**
         * <p>
         * A list of MFA devices.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MFADevice>.Builder} avoiding the need to
         * create one manually via {@link List<MFADevice>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MFADevice>.Builder#build()} is called immediately and its
         * result is passed to {@link #mfaDevices(List<MFADevice>)}.
         * 
         * @param mfaDevices
         *        a consumer that will call methods on {@link List<MFADevice>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mfaDevices(List<MFADevice>)
         */
        Builder mfaDevices(Consumer<MFADevice.Builder>... mfaDevices);

        /**
         * <p>
         * A flag that indicates whether there are more items to return. If your results were truncated, you can make a
         * subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note
         * that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results
         * available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive
         * all your results.
         * </p>
         * 
         * @param isTruncated
         *        A flag that indicates whether there are more items to return. If your results were truncated, you can
         *        make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more
         *        items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when
         *        there are more results available. We recommend that you check <code>IsTruncated</code> after every
         *        call to ensure that you receive all your results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isTruncated(Boolean isTruncated);

        /**
         * <p>
         * When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for
         * the <code>Marker</code> parameter in a subsequent pagination request.
         * </p>
         * 
         * @param marker
         *        When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to
         *        use for the <code>Marker</code> parameter in a subsequent pagination request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);
    }

    static final class BuilderImpl extends IamResponse.BuilderImpl implements Builder {
        private List<MFADevice> mfaDevices = DefaultSdkAutoConstructList.getInstance();

        private Boolean isTruncated;

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMfaDevicesResponse model) {
            super(model);
            mfaDevices(model.mfaDevices);
            isTruncated(model.isTruncated);
            marker(model.marker);
        }

        public final Collection<MFADevice.Builder> getMfaDevices() {
            if (mfaDevices instanceof SdkAutoConstructList) {
                return null;
            }
            return mfaDevices != null ? mfaDevices.stream().map(MFADevice::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder mfaDevices(Collection<MFADevice> mfaDevices) {
            this.mfaDevices = _mfaDeviceListTypeCopier.copy(mfaDevices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mfaDevices(MFADevice... mfaDevices) {
            mfaDevices(Arrays.asList(mfaDevices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mfaDevices(Consumer<MFADevice.Builder>... mfaDevices) {
            mfaDevices(Stream.of(mfaDevices).map(c -> MFADevice.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMfaDevices(Collection<MFADevice.BuilderImpl> mfaDevices) {
            this.mfaDevices = _mfaDeviceListTypeCopier.copyFromBuilder(mfaDevices);
        }

        public final Boolean getIsTruncated() {
            return isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public ListMfaDevicesResponse build() {
            return new ListMfaDevicesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
