/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iam.model.PolicyVersion;
import software.amazon.awssdk.services.iam.model._policyDocumentVersionListTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ManagedPolicyDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ManagedPolicyDetail> {
    private static final SdkField<String> POLICY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ManagedPolicyDetail.getter(ManagedPolicyDetail::policyName)).setter(ManagedPolicyDetail.setter(Builder::policyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyName").build()}).build();
    private static final SdkField<String> POLICY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ManagedPolicyDetail.getter(ManagedPolicyDetail::policyId)).setter(ManagedPolicyDetail.setter(Builder::policyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyId").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ManagedPolicyDetail.getter(ManagedPolicyDetail::arn)).setter(ManagedPolicyDetail.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ManagedPolicyDetail.getter(ManagedPolicyDetail::path)).setter(ManagedPolicyDetail.setter(Builder::path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Path").build()}).build();
    private static final SdkField<String> DEFAULT_VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ManagedPolicyDetail.getter(ManagedPolicyDetail::defaultVersionId)).setter(ManagedPolicyDetail.setter(Builder::defaultVersionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultVersionId").build()}).build();
    private static final SdkField<Integer> ATTACHMENT_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ManagedPolicyDetail.getter(ManagedPolicyDetail::attachmentCount)).setter(ManagedPolicyDetail.setter(Builder::attachmentCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentCount").build()}).build();
    private static final SdkField<Integer> PERMISSIONS_BOUNDARY_USAGE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ManagedPolicyDetail.getter(ManagedPolicyDetail::permissionsBoundaryUsageCount)).setter(ManagedPolicyDetail.setter(Builder::permissionsBoundaryUsageCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionsBoundaryUsageCount").build()}).build();
    private static final SdkField<Boolean> IS_ATTACHABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ManagedPolicyDetail.getter(ManagedPolicyDetail::isAttachable)).setter(ManagedPolicyDetail.setter(Builder::isAttachable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsAttachable").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ManagedPolicyDetail.getter(ManagedPolicyDetail::description)).setter(ManagedPolicyDetail.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Instant> CREATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ManagedPolicyDetail.getter(ManagedPolicyDetail::createDate)).setter(ManagedPolicyDetail.setter(Builder::createDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate").build()}).build();
    private static final SdkField<Instant> UPDATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ManagedPolicyDetail.getter(ManagedPolicyDetail::updateDate)).setter(ManagedPolicyDetail.setter(Builder::updateDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateDate").build()}).build();
    private static final SdkField<List<PolicyVersion>> POLICY_VERSION_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ManagedPolicyDetail.getter(ManagedPolicyDetail::policyVersionList)).setter(ManagedPolicyDetail.setter(Builder::policyVersionList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyVersionList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PolicyVersion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_NAME_FIELD, POLICY_ID_FIELD, ARN_FIELD, PATH_FIELD, DEFAULT_VERSION_ID_FIELD, ATTACHMENT_COUNT_FIELD, PERMISSIONS_BOUNDARY_USAGE_COUNT_FIELD, IS_ATTACHABLE_FIELD, DESCRIPTION_FIELD, CREATE_DATE_FIELD, UPDATE_DATE_FIELD, POLICY_VERSION_LIST_FIELD));
    private static final long serialVersionUID = 1L;
    private final String policyName;
    private final String policyId;
    private final String arn;
    private final String path;
    private final String defaultVersionId;
    private final Integer attachmentCount;
    private final Integer permissionsBoundaryUsageCount;
    private final Boolean isAttachable;
    private final String description;
    private final Instant createDate;
    private final Instant updateDate;
    private final List<PolicyVersion> policyVersionList;

    private ManagedPolicyDetail(BuilderImpl builder) {
        this.policyName = builder.policyName;
        this.policyId = builder.policyId;
        this.arn = builder.arn;
        this.path = builder.path;
        this.defaultVersionId = builder.defaultVersionId;
        this.attachmentCount = builder.attachmentCount;
        this.permissionsBoundaryUsageCount = builder.permissionsBoundaryUsageCount;
        this.isAttachable = builder.isAttachable;
        this.description = builder.description;
        this.createDate = builder.createDate;
        this.updateDate = builder.updateDate;
        this.policyVersionList = builder.policyVersionList;
    }

    public String policyName() {
        return this.policyName;
    }

    public String policyId() {
        return this.policyId;
    }

    public String arn() {
        return this.arn;
    }

    public String path() {
        return this.path;
    }

    public String defaultVersionId() {
        return this.defaultVersionId;
    }

    public Integer attachmentCount() {
        return this.attachmentCount;
    }

    public Integer permissionsBoundaryUsageCount() {
        return this.permissionsBoundaryUsageCount;
    }

    public Boolean isAttachable() {
        return this.isAttachable;
    }

    public String description() {
        return this.description;
    }

    public Instant createDate() {
        return this.createDate;
    }

    public Instant updateDate() {
        return this.updateDate;
    }

    public boolean hasPolicyVersionList() {
        return this.policyVersionList != null && !(this.policyVersionList instanceof SdkAutoConstructList);
    }

    public List<PolicyVersion> policyVersionList() {
        return this.policyVersionList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachmentCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionsBoundaryUsageCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.isAttachable());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.createDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyVersionList());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedPolicyDetail)) {
            return false;
        }
        ManagedPolicyDetail other = (ManagedPolicyDetail)obj;
        return Objects.equals(this.policyName(), other.policyName()) && Objects.equals(this.policyId(), other.policyId()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.path(), other.path()) && Objects.equals(this.defaultVersionId(), other.defaultVersionId()) && Objects.equals(this.attachmentCount(), other.attachmentCount()) && Objects.equals(this.permissionsBoundaryUsageCount(), other.permissionsBoundaryUsageCount()) && Objects.equals(this.isAttachable(), other.isAttachable()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.createDate(), other.createDate()) && Objects.equals(this.updateDate(), other.updateDate()) && Objects.equals(this.policyVersionList(), other.policyVersionList());
    }

    public String toString() {
        return ToString.builder((String)"ManagedPolicyDetail").add("PolicyName", (Object)this.policyName()).add("PolicyId", (Object)this.policyId()).add("Arn", (Object)this.arn()).add("Path", (Object)this.path()).add("DefaultVersionId", (Object)this.defaultVersionId()).add("AttachmentCount", (Object)this.attachmentCount()).add("PermissionsBoundaryUsageCount", (Object)this.permissionsBoundaryUsageCount()).add("IsAttachable", (Object)this.isAttachable()).add("Description", (Object)this.description()).add("CreateDate", (Object)this.createDate()).add("UpdateDate", (Object)this.updateDate()).add("PolicyVersionList", this.policyVersionList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyName": {
                return Optional.ofNullable(clazz.cast(this.policyName()));
            }
            case "PolicyId": {
                return Optional.ofNullable(clazz.cast(this.policyId()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Path": {
                return Optional.ofNullable(clazz.cast(this.path()));
            }
            case "DefaultVersionId": {
                return Optional.ofNullable(clazz.cast(this.defaultVersionId()));
            }
            case "AttachmentCount": {
                return Optional.ofNullable(clazz.cast(this.attachmentCount()));
            }
            case "PermissionsBoundaryUsageCount": {
                return Optional.ofNullable(clazz.cast(this.permissionsBoundaryUsageCount()));
            }
            case "IsAttachable": {
                return Optional.ofNullable(clazz.cast(this.isAttachable()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "CreateDate": {
                return Optional.ofNullable(clazz.cast(this.createDate()));
            }
            case "UpdateDate": {
                return Optional.ofNullable(clazz.cast(this.updateDate()));
            }
            case "PolicyVersionList": {
                return Optional.ofNullable(clazz.cast(this.policyVersionList()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ManagedPolicyDetail, T> g) {
        return obj -> g.apply((ManagedPolicyDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String policyName;
        private String policyId;
        private String arn;
        private String path;
        private String defaultVersionId;
        private Integer attachmentCount;
        private Integer permissionsBoundaryUsageCount;
        private Boolean isAttachable;
        private String description;
        private Instant createDate;
        private Instant updateDate;
        private List<PolicyVersion> policyVersionList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ManagedPolicyDetail model) {
            this.policyName(model.policyName);
            this.policyId(model.policyId);
            this.arn(model.arn);
            this.path(model.path);
            this.defaultVersionId(model.defaultVersionId);
            this.attachmentCount(model.attachmentCount);
            this.permissionsBoundaryUsageCount(model.permissionsBoundaryUsageCount);
            this.isAttachable(model.isAttachable);
            this.description(model.description);
            this.createDate(model.createDate);
            this.updateDate(model.updateDate);
            this.policyVersionList(model.policyVersionList);
        }

        public final String getPolicyName() {
            return this.policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public final String getPolicyId() {
            return this.policyId;
        }

        @Override
        public final Builder policyId(String policyId) {
            this.policyId = policyId;
            return this;
        }

        public final void setPolicyId(String policyId) {
            this.policyId = policyId;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getPath() {
            return this.path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        public final String getDefaultVersionId() {
            return this.defaultVersionId;
        }

        @Override
        public final Builder defaultVersionId(String defaultVersionId) {
            this.defaultVersionId = defaultVersionId;
            return this;
        }

        public final void setDefaultVersionId(String defaultVersionId) {
            this.defaultVersionId = defaultVersionId;
        }

        public final Integer getAttachmentCount() {
            return this.attachmentCount;
        }

        @Override
        public final Builder attachmentCount(Integer attachmentCount) {
            this.attachmentCount = attachmentCount;
            return this;
        }

        public final void setAttachmentCount(Integer attachmentCount) {
            this.attachmentCount = attachmentCount;
        }

        public final Integer getPermissionsBoundaryUsageCount() {
            return this.permissionsBoundaryUsageCount;
        }

        @Override
        public final Builder permissionsBoundaryUsageCount(Integer permissionsBoundaryUsageCount) {
            this.permissionsBoundaryUsageCount = permissionsBoundaryUsageCount;
            return this;
        }

        public final void setPermissionsBoundaryUsageCount(Integer permissionsBoundaryUsageCount) {
            this.permissionsBoundaryUsageCount = permissionsBoundaryUsageCount;
        }

        public final Boolean getIsAttachable() {
            return this.isAttachable;
        }

        @Override
        public final Builder isAttachable(Boolean isAttachable) {
            this.isAttachable = isAttachable;
            return this;
        }

        public final void setIsAttachable(Boolean isAttachable) {
            this.isAttachable = isAttachable;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Instant getCreateDate() {
            return this.createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        public final Instant getUpdateDate() {
            return this.updateDate;
        }

        @Override
        public final Builder updateDate(Instant updateDate) {
            this.updateDate = updateDate;
            return this;
        }

        public final void setUpdateDate(Instant updateDate) {
            this.updateDate = updateDate;
        }

        public final Collection<PolicyVersion.Builder> getPolicyVersionList() {
            return this.policyVersionList != null ? (Collection)this.policyVersionList.stream().map(PolicyVersion::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder policyVersionList(Collection<PolicyVersion> policyVersionList) {
            this.policyVersionList = _policyDocumentVersionListTypeCopier.copy(policyVersionList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyVersionList(PolicyVersion ... policyVersionList) {
            this.policyVersionList(Arrays.asList(policyVersionList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyVersionList(Consumer<PolicyVersion.Builder> ... policyVersionList) {
            this.policyVersionList(Stream.of(policyVersionList).map(c -> (PolicyVersion)((PolicyVersion.Builder)PolicyVersion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPolicyVersionList(Collection<PolicyVersion.BuilderImpl> policyVersionList) {
            this.policyVersionList = _policyDocumentVersionListTypeCopier.copyFromBuilder(policyVersionList);
        }

        public ManagedPolicyDetail build() {
            return new ManagedPolicyDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ManagedPolicyDetail> {
        public Builder policyName(String var1);

        public Builder policyId(String var1);

        public Builder arn(String var1);

        public Builder path(String var1);

        public Builder defaultVersionId(String var1);

        public Builder attachmentCount(Integer var1);

        public Builder permissionsBoundaryUsageCount(Integer var1);

        public Builder isAttachable(Boolean var1);

        public Builder description(String var1);

        public Builder createDate(Instant var1);

        public Builder updateDate(Instant var1);

        public Builder policyVersionList(Collection<PolicyVersion> var1);

        public Builder policyVersionList(PolicyVersion ... var1);

        public Builder policyVersionList(Consumer<PolicyVersion.Builder> ... var1);
    }
}

