/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.iam.model.AttachedPermissionsBoundary;
import software.amazon.awssdk.services.iam.model.AttachedPolicy;
import software.amazon.awssdk.services.iam.model.InstanceProfile;
import software.amazon.awssdk.services.iam.model.PolicyDetail;
import software.amazon.awssdk.services.iam.model.Tag;
import software.amazon.awssdk.services.iam.model._attachedPoliciesListTypeCopier;
import software.amazon.awssdk.services.iam.model._instanceProfileListTypeCopier;
import software.amazon.awssdk.services.iam.model._policyDetailListTypeCopier;
import software.amazon.awssdk.services.iam.model._tagListTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RoleDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RoleDetail> {
    private static final SdkField<String> PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RoleDetail.getter(RoleDetail::path)).setter(RoleDetail.setter(Builder::path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Path").build()}).build();
    private static final SdkField<String> ROLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RoleDetail.getter(RoleDetail::roleName)).setter(RoleDetail.setter(Builder::roleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleName").build()}).build();
    private static final SdkField<String> ROLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RoleDetail.getter(RoleDetail::roleId)).setter(RoleDetail.setter(Builder::roleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleId").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RoleDetail.getter(RoleDetail::arn)).setter(RoleDetail.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<Instant> CREATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(RoleDetail.getter(RoleDetail::createDate)).setter(RoleDetail.setter(Builder::createDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate").build()}).build();
    private static final SdkField<String> ASSUME_ROLE_POLICY_DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RoleDetail.getter(RoleDetail::assumeRolePolicyDocument)).setter(RoleDetail.setter(Builder::assumeRolePolicyDocument)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssumeRolePolicyDocument").build()}).build();
    private static final SdkField<List<InstanceProfile>> INSTANCE_PROFILE_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(RoleDetail.getter(RoleDetail::instanceProfileList)).setter(RoleDetail.setter(Builder::instanceProfileList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceProfileList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceProfile::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<PolicyDetail>> ROLE_POLICY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(RoleDetail.getter(RoleDetail::rolePolicyList)).setter(RoleDetail.setter(Builder::rolePolicyList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RolePolicyList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PolicyDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AttachedPolicy>> ATTACHED_MANAGED_POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(RoleDetail.getter(RoleDetail::attachedManagedPolicies)).setter(RoleDetail.setter(Builder::attachedManagedPolicies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachedManagedPolicies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttachedPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(RoleDetail.getter(RoleDetail::tags)).setter(RoleDetail.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AttachedPermissionsBoundary> PERMISSIONS_BOUNDARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(RoleDetail.getter(RoleDetail::permissionsBoundary)).setter(RoleDetail.setter(Builder::permissionsBoundary)).constructor(AttachedPermissionsBoundary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionsBoundary").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PATH_FIELD, ROLE_NAME_FIELD, ROLE_ID_FIELD, ARN_FIELD, CREATE_DATE_FIELD, ASSUME_ROLE_POLICY_DOCUMENT_FIELD, INSTANCE_PROFILE_LIST_FIELD, ROLE_POLICY_LIST_FIELD, ATTACHED_MANAGED_POLICIES_FIELD, TAGS_FIELD, PERMISSIONS_BOUNDARY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String path;
    private final String roleName;
    private final String roleId;
    private final String arn;
    private final Instant createDate;
    private final String assumeRolePolicyDocument;
    private final List<InstanceProfile> instanceProfileList;
    private final List<PolicyDetail> rolePolicyList;
    private final List<AttachedPolicy> attachedManagedPolicies;
    private final List<Tag> tags;
    private final AttachedPermissionsBoundary permissionsBoundary;

    private RoleDetail(BuilderImpl builder) {
        this.path = builder.path;
        this.roleName = builder.roleName;
        this.roleId = builder.roleId;
        this.arn = builder.arn;
        this.createDate = builder.createDate;
        this.assumeRolePolicyDocument = builder.assumeRolePolicyDocument;
        this.instanceProfileList = builder.instanceProfileList;
        this.rolePolicyList = builder.rolePolicyList;
        this.attachedManagedPolicies = builder.attachedManagedPolicies;
        this.tags = builder.tags;
        this.permissionsBoundary = builder.permissionsBoundary;
    }

    public String path() {
        return this.path;
    }

    public String roleName() {
        return this.roleName;
    }

    public String roleId() {
        return this.roleId;
    }

    public String arn() {
        return this.arn;
    }

    public Instant createDate() {
        return this.createDate;
    }

    public String assumeRolePolicyDocument() {
        return this.assumeRolePolicyDocument;
    }

    public List<InstanceProfile> instanceProfileList() {
        return this.instanceProfileList;
    }

    public List<PolicyDetail> rolePolicyList() {
        return this.rolePolicyList;
    }

    public List<AttachedPolicy> attachedManagedPolicies() {
        return this.attachedManagedPolicies;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public AttachedPermissionsBoundary permissionsBoundary() {
        return this.permissionsBoundary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.assumeRolePolicyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceProfileList());
        hashCode = 31 * hashCode + Objects.hashCode(this.rolePolicyList());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachedManagedPolicies());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionsBoundary());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoleDetail)) {
            return false;
        }
        RoleDetail other = (RoleDetail)obj;
        return Objects.equals(this.path(), other.path()) && Objects.equals(this.roleName(), other.roleName()) && Objects.equals(this.roleId(), other.roleId()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createDate(), other.createDate()) && Objects.equals(this.assumeRolePolicyDocument(), other.assumeRolePolicyDocument()) && Objects.equals(this.instanceProfileList(), other.instanceProfileList()) && Objects.equals(this.rolePolicyList(), other.rolePolicyList()) && Objects.equals(this.attachedManagedPolicies(), other.attachedManagedPolicies()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.permissionsBoundary(), other.permissionsBoundary());
    }

    public String toString() {
        return ToString.builder((String)"RoleDetail").add("Path", (Object)this.path()).add("RoleName", (Object)this.roleName()).add("RoleId", (Object)this.roleId()).add("Arn", (Object)this.arn()).add("CreateDate", (Object)this.createDate()).add("AssumeRolePolicyDocument", (Object)this.assumeRolePolicyDocument()).add("InstanceProfileList", this.instanceProfileList()).add("RolePolicyList", this.rolePolicyList()).add("AttachedManagedPolicies", this.attachedManagedPolicies()).add("Tags", this.tags()).add("PermissionsBoundary", (Object)this.permissionsBoundary()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Path": {
                return Optional.ofNullable(clazz.cast(this.path()));
            }
            case "RoleName": {
                return Optional.ofNullable(clazz.cast(this.roleName()));
            }
            case "RoleId": {
                return Optional.ofNullable(clazz.cast(this.roleId()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "CreateDate": {
                return Optional.ofNullable(clazz.cast(this.createDate()));
            }
            case "AssumeRolePolicyDocument": {
                return Optional.ofNullable(clazz.cast(this.assumeRolePolicyDocument()));
            }
            case "InstanceProfileList": {
                return Optional.ofNullable(clazz.cast(this.instanceProfileList()));
            }
            case "RolePolicyList": {
                return Optional.ofNullable(clazz.cast(this.rolePolicyList()));
            }
            case "AttachedManagedPolicies": {
                return Optional.ofNullable(clazz.cast(this.attachedManagedPolicies()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "PermissionsBoundary": {
                return Optional.ofNullable(clazz.cast(this.permissionsBoundary()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RoleDetail, T> g) {
        return obj -> g.apply((RoleDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String path;
        private String roleName;
        private String roleId;
        private String arn;
        private Instant createDate;
        private String assumeRolePolicyDocument;
        private List<InstanceProfile> instanceProfileList = DefaultSdkAutoConstructList.getInstance();
        private List<PolicyDetail> rolePolicyList = DefaultSdkAutoConstructList.getInstance();
        private List<AttachedPolicy> attachedManagedPolicies = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private AttachedPermissionsBoundary permissionsBoundary;

        private BuilderImpl() {
        }

        private BuilderImpl(RoleDetail model) {
            this.path(model.path);
            this.roleName(model.roleName);
            this.roleId(model.roleId);
            this.arn(model.arn);
            this.createDate(model.createDate);
            this.assumeRolePolicyDocument(model.assumeRolePolicyDocument);
            this.instanceProfileList(model.instanceProfileList);
            this.rolePolicyList(model.rolePolicyList);
            this.attachedManagedPolicies(model.attachedManagedPolicies);
            this.tags(model.tags);
            this.permissionsBoundary(model.permissionsBoundary);
        }

        public final String getPath() {
            return this.path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        public final String getRoleName() {
            return this.roleName;
        }

        @Override
        public final Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public final void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        public final String getRoleId() {
            return this.roleId;
        }

        @Override
        public final Builder roleId(String roleId) {
            this.roleId = roleId;
            return this;
        }

        public final void setRoleId(String roleId) {
            this.roleId = roleId;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Instant getCreateDate() {
            return this.createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        public final String getAssumeRolePolicyDocument() {
            return this.assumeRolePolicyDocument;
        }

        @Override
        public final Builder assumeRolePolicyDocument(String assumeRolePolicyDocument) {
            this.assumeRolePolicyDocument = assumeRolePolicyDocument;
            return this;
        }

        public final void setAssumeRolePolicyDocument(String assumeRolePolicyDocument) {
            this.assumeRolePolicyDocument = assumeRolePolicyDocument;
        }

        public final Collection<InstanceProfile.Builder> getInstanceProfileList() {
            return this.instanceProfileList != null ? (Collection)this.instanceProfileList.stream().map(InstanceProfile::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instanceProfileList(Collection<InstanceProfile> instanceProfileList) {
            this.instanceProfileList = _instanceProfileListTypeCopier.copy(instanceProfileList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceProfileList(InstanceProfile ... instanceProfileList) {
            this.instanceProfileList(Arrays.asList(instanceProfileList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceProfileList(Consumer<InstanceProfile.Builder> ... instanceProfileList) {
            this.instanceProfileList(Stream.of(instanceProfileList).map(c -> (InstanceProfile)((InstanceProfile.Builder)InstanceProfile.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInstanceProfileList(Collection<InstanceProfile.BuilderImpl> instanceProfileList) {
            this.instanceProfileList = _instanceProfileListTypeCopier.copyFromBuilder(instanceProfileList);
        }

        public final Collection<PolicyDetail.Builder> getRolePolicyList() {
            return this.rolePolicyList != null ? (Collection)this.rolePolicyList.stream().map(PolicyDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder rolePolicyList(Collection<PolicyDetail> rolePolicyList) {
            this.rolePolicyList = _policyDetailListTypeCopier.copy(rolePolicyList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rolePolicyList(PolicyDetail ... rolePolicyList) {
            this.rolePolicyList(Arrays.asList(rolePolicyList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rolePolicyList(Consumer<PolicyDetail.Builder> ... rolePolicyList) {
            this.rolePolicyList(Stream.of(rolePolicyList).map(c -> (PolicyDetail)((PolicyDetail.Builder)PolicyDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRolePolicyList(Collection<PolicyDetail.BuilderImpl> rolePolicyList) {
            this.rolePolicyList = _policyDetailListTypeCopier.copyFromBuilder(rolePolicyList);
        }

        public final Collection<AttachedPolicy.Builder> getAttachedManagedPolicies() {
            return this.attachedManagedPolicies != null ? (Collection)this.attachedManagedPolicies.stream().map(AttachedPolicy::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attachedManagedPolicies(Collection<AttachedPolicy> attachedManagedPolicies) {
            this.attachedManagedPolicies = _attachedPoliciesListTypeCopier.copy(attachedManagedPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachedManagedPolicies(AttachedPolicy ... attachedManagedPolicies) {
            this.attachedManagedPolicies(Arrays.asList(attachedManagedPolicies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachedManagedPolicies(Consumer<AttachedPolicy.Builder> ... attachedManagedPolicies) {
            this.attachedManagedPolicies(Stream.of(attachedManagedPolicies).map(c -> (AttachedPolicy)((AttachedPolicy.Builder)AttachedPolicy.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAttachedManagedPolicies(Collection<AttachedPolicy.BuilderImpl> attachedManagedPolicies) {
            this.attachedManagedPolicies = _attachedPoliciesListTypeCopier.copyFromBuilder(attachedManagedPolicies);
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = _tagListTypeCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = _tagListTypeCopier.copyFromBuilder(tags);
        }

        public final AttachedPermissionsBoundary.Builder getPermissionsBoundary() {
            return this.permissionsBoundary != null ? this.permissionsBoundary.toBuilder() : null;
        }

        @Override
        public final Builder permissionsBoundary(AttachedPermissionsBoundary permissionsBoundary) {
            this.permissionsBoundary = permissionsBoundary;
            return this;
        }

        public final void setPermissionsBoundary(AttachedPermissionsBoundary.BuilderImpl permissionsBoundary) {
            this.permissionsBoundary = permissionsBoundary != null ? permissionsBoundary.build() : null;
        }

        public RoleDetail build() {
            return new RoleDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RoleDetail> {
        public Builder path(String var1);

        public Builder roleName(String var1);

        public Builder roleId(String var1);

        public Builder arn(String var1);

        public Builder createDate(Instant var1);

        public Builder assumeRolePolicyDocument(String var1);

        public Builder instanceProfileList(Collection<InstanceProfile> var1);

        public Builder instanceProfileList(InstanceProfile ... var1);

        public Builder instanceProfileList(Consumer<InstanceProfile.Builder> ... var1);

        public Builder rolePolicyList(Collection<PolicyDetail> var1);

        public Builder rolePolicyList(PolicyDetail ... var1);

        public Builder rolePolicyList(Consumer<PolicyDetail.Builder> ... var1);

        public Builder attachedManagedPolicies(Collection<AttachedPolicy> var1);

        public Builder attachedManagedPolicies(AttachedPolicy ... var1);

        public Builder attachedManagedPolicies(Consumer<AttachedPolicy.Builder> ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder permissionsBoundary(AttachedPermissionsBoundary var1);

        default public Builder permissionsBoundary(Consumer<AttachedPermissionsBoundary.Builder> permissionsBoundary) {
            return this.permissionsBoundary((AttachedPermissionsBoundary)((AttachedPermissionsBoundary.Builder)AttachedPermissionsBoundary.builder().applyMutation(permissionsBoundary)).build());
        }
    }
}

