/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SAMLProviderListEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SAMLProviderListEntry> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SAMLProviderListEntry.getter(SAMLProviderListEntry::arn)).setter(SAMLProviderListEntry.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<Instant> VALID_UNTIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(SAMLProviderListEntry.getter(SAMLProviderListEntry::validUntil)).setter(SAMLProviderListEntry.setter(Builder::validUntil)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidUntil").build()}).build();
    private static final SdkField<Instant> CREATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(SAMLProviderListEntry.getter(SAMLProviderListEntry::createDate)).setter(SAMLProviderListEntry.setter(Builder::createDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, VALID_UNTIL_FIELD, CREATE_DATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final Instant validUntil;
    private final Instant createDate;

    private SAMLProviderListEntry(BuilderImpl builder) {
        this.arn = builder.arn;
        this.validUntil = builder.validUntil;
        this.createDate = builder.createDate;
    }

    public String arn() {
        return this.arn;
    }

    public Instant validUntil() {
        return this.validUntil;
    }

    public Instant createDate() {
        return this.createDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.validUntil());
        hashCode = 31 * hashCode + Objects.hashCode(this.createDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SAMLProviderListEntry)) {
            return false;
        }
        SAMLProviderListEntry other = (SAMLProviderListEntry)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.validUntil(), other.validUntil()) && Objects.equals(this.createDate(), other.createDate());
    }

    public String toString() {
        return ToString.builder((String)"SAMLProviderListEntry").add("Arn", (Object)this.arn()).add("ValidUntil", (Object)this.validUntil()).add("CreateDate", (Object)this.createDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "ValidUntil": {
                return Optional.ofNullable(clazz.cast(this.validUntil()));
            }
            case "CreateDate": {
                return Optional.ofNullable(clazz.cast(this.createDate()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SAMLProviderListEntry, T> g) {
        return obj -> g.apply((SAMLProviderListEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private Instant validUntil;
        private Instant createDate;

        private BuilderImpl() {
        }

        private BuilderImpl(SAMLProviderListEntry model) {
            this.arn(model.arn);
            this.validUntil(model.validUntil);
            this.createDate(model.createDate);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Instant getValidUntil() {
            return this.validUntil;
        }

        @Override
        public final Builder validUntil(Instant validUntil) {
            this.validUntil = validUntil;
            return this;
        }

        public final void setValidUntil(Instant validUntil) {
            this.validUntil = validUntil;
        }

        public final Instant getCreateDate() {
            return this.createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        public SAMLProviderListEntry build() {
            return new SAMLProviderListEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SAMLProviderListEntry> {
        public Builder arn(String var1);

        public Builder validUntil(Instant var1);

        public Builder createDate(Instant var1);
    }
}

