/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http;

import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.junit.WireMockRule;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import javax.net.ssl.SSLHandshakeException;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.junit.MockitoJUnitRunner;
import software.amazon.awssdk.http.ContentStreamProvider;
import software.amazon.awssdk.http.ExecutableHttpRequest;
import software.amazon.awssdk.http.HttpExecuteRequest;
import software.amazon.awssdk.http.HttpExecuteResponse;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.utils.IoUtils;

@RunWith(value=MockitoJUnitRunner.class)
public abstract class SdkHttpClientDefaultTestSuite {
    @Rule
    public WireMockRule mockServer = new WireMockRule((Options)WireMockConfiguration.wireMockConfig().dynamicPort().dynamicHttpsPort());

    @Test
    public void supportsResponseCode200() throws Exception {
        this.testForResponseCode(200);
    }

    @Test
    public void supportsResponseCode200Head() throws Exception {
        this.testForResponseCode(403, SdkHttpMethod.HEAD, false);
    }

    @Test
    public void supportsResponseCode202() throws Exception {
        this.testForResponseCode(202);
    }

    @Test
    public void supportsResponseCode403() throws Exception {
        this.testForResponseCode(403);
    }

    @Test
    public void supportsResponseCode403Head() throws Exception {
        this.testForResponseCode(403, SdkHttpMethod.HEAD, false);
    }

    @Test
    public void supportsResponseCode301() throws Exception {
        this.testForResponseCode(301);
    }

    @Test
    public void supportsResponseCode302() throws Exception {
        this.testForResponseCode(302);
    }

    @Test
    public void supportsResponseCode500() throws Exception {
        this.testForResponseCode(500);
    }

    @Test
    public void validatesHttpsCertificateIssuer() {
        SdkHttpClient client = this.createSdkHttpClient();
        SdkHttpFullRequest request = this.mockSdkRequest("https://localhost:" + this.mockServer.httpsPort(), SdkHttpMethod.POST, true);
        Assertions.assertThatThrownBy(() -> ((ExecutableHttpRequest)client.prepareRequest(HttpExecuteRequest.builder().request((SdkHttpRequest)request).build())).call()).isInstanceOf(SSLHandshakeException.class);
    }

    @Test
    public void supportsRequestBodyOnGetRequest() throws Exception {
        this.testForResponseCode(200, SdkHttpMethod.GET, true);
    }

    @Test
    public void supportsRequestBodyOnPostRequest() throws Exception {
        this.testForResponseCode(200, SdkHttpMethod.POST, true);
    }

    @Test
    public void supportsRequestBodyOnPutRequest() throws Exception {
        this.testForResponseCode(200, SdkHttpMethod.PUT, true);
    }

    @Test
    public void supportsRequestBodyOnDeleteRequest() throws Exception {
        this.testForResponseCode(200, SdkHttpMethod.DELETE, true);
    }

    @Test
    public void supportsRequestBodyOnHeadRequest() throws Exception {
        this.testForResponseCode(200, SdkHttpMethod.HEAD, true);
    }

    @Test
    public void supportsRequestBodyOnPatchRequest() throws Exception {
        this.testForResponseCode(200, SdkHttpMethod.PATCH, true);
    }

    @Test
    public void supportsRequestBodyOnOptionsRequest() throws Exception {
        this.testForResponseCode(200, SdkHttpMethod.OPTIONS, true);
    }

    private void testForResponseCode(int returnCode) throws Exception {
        this.testForResponseCode(returnCode, SdkHttpMethod.POST, true);
    }

    protected void testForResponseCode(int returnCode, SdkHttpMethod method, boolean includeBody) throws Exception {
        this.testForResponseCode(returnCode, method, method, includeBody);
    }

    protected void testForResponseCode(int returnCode, SdkHttpMethod method, SdkHttpMethod expectedMethod, boolean includeBody) throws Exception {
        SdkHttpClient client = this.createSdkHttpClient();
        this.stubForMockRequest(returnCode);
        SdkHttpFullRequest req = this.mockSdkRequest("http://localhost:" + this.mockServer.port(), method, includeBody);
        HttpExecuteResponse rsp = client.prepareRequest(HttpExecuteRequest.builder().request((SdkHttpRequest)req).contentStreamProvider((ContentStreamProvider)req.contentStreamProvider().orElse(null)).build()).call();
        this.validateResponse(rsp, returnCode, expectedMethod, includeBody);
    }

    protected void testForResponseCodeUsingHttps(SdkHttpClient client, int returnCode) throws Exception {
        SdkHttpMethod sdkHttpMethod = SdkHttpMethod.POST;
        this.stubForMockRequest(returnCode);
        SdkHttpFullRequest req = this.mockSdkRequest("https://localhost:" + this.mockServer.httpsPort(), sdkHttpMethod, true);
        HttpExecuteResponse rsp = client.prepareRequest(HttpExecuteRequest.builder().request((SdkHttpRequest)req).contentStreamProvider((ContentStreamProvider)req.contentStreamProvider().orElse(null)).build()).call();
        this.validateResponse(rsp, returnCode, sdkHttpMethod, true);
    }

    private void stubForMockRequest(int returnCode) {
        ResponseDefinitionBuilder responseBuilder = WireMock.aResponse().withStatus(returnCode).withHeader("Some-Header", new String[]{"With Value"}).withBody("hello");
        if (returnCode >= 300 && returnCode <= 399) {
            responseBuilder.withHeader("Location", new String[]{"Some New Location"});
        }
        this.mockServer.stubFor(WireMock.any((UrlPattern)WireMock.urlPathEqualTo((String)"/")).willReturn(responseBuilder));
    }

    private void validateResponse(HttpExecuteResponse response, int returnCode, SdkHttpMethod method, boolean expectBody) throws IOException {
        RequestMethod requestMethod = RequestMethod.fromString((String)method.name());
        RequestPatternBuilder patternBuilder = RequestPatternBuilder.newRequestPattern((RequestMethod)requestMethod, (UrlPattern)WireMock.urlMatching((String)"/")).withHeader("Host", WireMock.containing((String)"localhost")).withHeader("User-Agent", WireMock.equalTo((String)"hello-world!"));
        if (expectBody) {
            patternBuilder.withRequestBody((ContentPattern)WireMock.equalTo((String)"Body"));
        } else {
            patternBuilder.withRequestBody((ContentPattern)WireMock.absent());
        }
        this.mockServer.verify(1, patternBuilder);
        if (method == SdkHttpMethod.HEAD) {
            Assertions.assertThat((Optional)response.responseBody()).isEmpty();
        } else {
            Assertions.assertThat((String)IoUtils.toUtf8String((InputStream)response.responseBody().orElse(null))).isEqualTo("hello");
        }
        Assertions.assertThat((Optional)response.httpResponse().firstMatchingHeader("Some-Header")).contains((Object)"With Value");
        Assertions.assertThat((int)response.httpResponse().statusCode()).isEqualTo(returnCode);
        this.mockServer.resetMappings();
    }

    private SdkHttpFullRequest mockSdkRequest(String uriString, SdkHttpMethod method, boolean includeBody) {
        URI uri = URI.create(uriString);
        SdkHttpFullRequest.Builder requestBuilder = SdkHttpFullRequest.builder().uri(uri).method(method).putHeader("Host", uri.getHost()).putHeader("User-Agent", "hello-world!");
        if (includeBody) {
            byte[] content = "Body".getBytes(StandardCharsets.UTF_8);
            requestBuilder.putHeader("Content-Length", Integer.toString(content.length));
            requestBuilder.contentStreamProvider(() -> new ByteArrayInputStream(content));
        }
        return requestBuilder.build();
    }

    protected abstract SdkHttpClient createSdkHttpClient();
}

