/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.auth.aws.internal.signer;

import java.nio.ByteBuffer;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.checksums.spi.ChecksumAlgorithm;
import software.amazon.awssdk.http.ContentStreamProvider;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.auth.aws.internal.signer.AwsChunkedV4PayloadSigner;
import software.amazon.awssdk.http.auth.aws.internal.signer.Checksummer;
import software.amazon.awssdk.http.auth.aws.internal.signer.CredentialScope;
import software.amazon.awssdk.http.auth.aws.internal.signer.NoOpPayloadChecksumStore;
import software.amazon.awssdk.http.auth.aws.internal.signer.V4PayloadSigner;
import software.amazon.awssdk.http.auth.aws.internal.signer.V4Properties;
import software.amazon.awssdk.http.auth.aws.internal.signer.V4RequestSigner;
import software.amazon.awssdk.http.auth.aws.internal.signer.V4RequestSigningResult;
import software.amazon.awssdk.http.auth.aws.internal.signer.util.ChecksumUtil;
import software.amazon.awssdk.http.auth.aws.internal.signer.util.CredentialUtils;
import software.amazon.awssdk.http.auth.aws.internal.signer.util.OptionalDependencyLoaderUtil;
import software.amazon.awssdk.http.auth.aws.signer.AwsV4FamilyHttpSigner;
import software.amazon.awssdk.http.auth.aws.signer.AwsV4HttpSigner;
import software.amazon.awssdk.http.auth.aws.signer.SignerConstant;
import software.amazon.awssdk.http.auth.spi.signer.AsyncSignRequest;
import software.amazon.awssdk.http.auth.spi.signer.AsyncSignedRequest;
import software.amazon.awssdk.http.auth.spi.signer.BaseSignRequest;
import software.amazon.awssdk.http.auth.spi.signer.PayloadChecksumStore;
import software.amazon.awssdk.http.auth.spi.signer.SdkInternalHttpSignerProperty;
import software.amazon.awssdk.http.auth.spi.signer.SignRequest;
import software.amazon.awssdk.http.auth.spi.signer.SignedRequest;
import software.amazon.awssdk.identity.spi.AwsCredentialsIdentity;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
public final class DefaultAwsV4HttpSigner
implements AwsV4HttpSigner {
    private static final int DEFAULT_CHUNK_SIZE_IN_BYTES = 131072;
    private static final Logger LOG = Logger.loggerFor(DefaultAwsV4HttpSigner.class);

    public SignedRequest sign(SignRequest<? extends AwsCredentialsIdentity> request) {
        Checksummer checksummer = ChecksumUtil.checksummer(request, null, DefaultAwsV4HttpSigner.checksumStore(request));
        V4Properties v4Properties = DefaultAwsV4HttpSigner.v4Properties(request);
        V4RequestSigner v4RequestSigner = DefaultAwsV4HttpSigner.v4RequestSigner(request, v4Properties);
        V4PayloadSigner payloadSigner = DefaultAwsV4HttpSigner.v4PayloadSigner(request, v4Properties);
        return DefaultAwsV4HttpSigner.doSign(request, checksummer, v4RequestSigner, payloadSigner);
    }

    public CompletableFuture<AsyncSignedRequest> signAsync(AsyncSignRequest<? extends AwsCredentialsIdentity> request) {
        Checksummer checksummer = DefaultAwsV4HttpSigner.asyncChecksummer(request, DefaultAwsV4HttpSigner.checksumStore(request));
        V4Properties v4Properties = DefaultAwsV4HttpSigner.v4Properties(request);
        V4RequestSigner v4RequestSigner = DefaultAwsV4HttpSigner.v4RequestSigner(request, v4Properties);
        V4PayloadSigner payloadSigner = DefaultAwsV4HttpSigner.v4PayloadAsyncSigner(request, v4Properties);
        return DefaultAwsV4HttpSigner.doSignAsync(request, checksummer, v4RequestSigner, payloadSigner);
    }

    private static V4Properties v4Properties(BaseSignRequest<?, ? extends AwsCredentialsIdentity> request) {
        Clock signingClock = (Clock)request.requireProperty(SIGNING_CLOCK, (Object)Clock.systemUTC());
        Instant signingInstant = signingClock.instant();
        AwsCredentialsIdentity credentials = CredentialUtils.sanitizeCredentials((AwsCredentialsIdentity)request.identity());
        String regionName = (String)request.requireProperty(REGION_NAME);
        String serviceSigningName = (String)request.requireProperty(SERVICE_SIGNING_NAME);
        CredentialScope credentialScope = new CredentialScope(regionName, serviceSigningName, signingInstant);
        boolean doubleUrlEncode = (Boolean)request.requireProperty(DOUBLE_URL_ENCODE, (Object)true);
        boolean normalizePath = (Boolean)request.requireProperty(NORMALIZE_PATH, (Object)true);
        return V4Properties.builder().credentials(credentials).credentialScope(credentialScope).signingClock(signingClock).doubleUrlEncode(doubleUrlEncode).normalizePath(normalizePath).build();
    }

    private static V4RequestSigner v4RequestSigner(BaseSignRequest<?, ? extends AwsCredentialsIdentity> request, V4Properties v4Properties) {
        Function<V4Properties, V4RequestSigner> requestSigner;
        AwsV4FamilyHttpSigner.AuthLocation authLocation = (AwsV4FamilyHttpSigner.AuthLocation)((Object)request.requireProperty(AUTH_LOCATION, (Object)AwsV4FamilyHttpSigner.AuthLocation.HEADER));
        Duration expirationDuration = (Duration)request.property(EXPIRATION_DURATION);
        boolean isAnonymous = CredentialUtils.isAnonymous((AwsCredentialsIdentity)request.identity());
        if (isAnonymous) {
            return V4RequestSigner.anonymous(v4Properties);
        }
        switch (authLocation) {
            case HEADER: {
                if (expirationDuration != null) {
                    throw new UnsupportedOperationException(String.format("%s is not supported for %s.", new Object[]{EXPIRATION_DURATION, AwsV4FamilyHttpSigner.AuthLocation.HEADER}));
                }
                requestSigner = V4RequestSigner::header;
                break;
            }
            case QUERY_STRING: {
                requestSigner = expirationDuration == null ? V4RequestSigner::query : properties -> V4RequestSigner.presigned(properties, DefaultAwsV4HttpSigner.validateExpirationDuration(expirationDuration));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported authLocation " + (Object)((Object)authLocation));
            }
        }
        return requestSigner.apply(v4Properties);
    }

    private static Checksummer asyncChecksummer(BaseSignRequest<?, ? extends AwsCredentialsIdentity> request, PayloadChecksumStore checksumStore) {
        boolean shouldTreatAsUnsigned = DefaultAwsV4HttpSigner.asyncShouldTreatAsUnsigned(request);
        Boolean overridePayloadSigning = shouldTreatAsUnsigned ? Boolean.valueOf(false) : null;
        return ChecksumUtil.checksummer(request, overridePayloadSigning, checksumStore);
    }

    private static boolean asyncShouldTreatAsUnsigned(BaseSignRequest<?, ? extends AwsCredentialsIdentity> request) {
        boolean isHttp = !"https".equals(request.request().protocol());
        boolean isPayloadSigning = ChecksumUtil.isPayloadSigning(request);
        boolean isChunkEncoding = (Boolean)request.requireProperty(CHUNK_ENCODING_ENABLED, (Object)false);
        return isHttp && isPayloadSigning && isChunkEncoding;
    }

    private static V4PayloadSigner v4PayloadSigner(BaseSignRequest<?, ? extends AwsCredentialsIdentity> request, V4Properties properties) {
        boolean isFlexible;
        boolean isPayloadSigning = ChecksumUtil.isPayloadSigning(request);
        boolean isEventStreaming = ChecksumUtil.isEventStreaming(request.request());
        boolean isChunkEncoding = (Boolean)request.requireProperty(CHUNK_ENCODING_ENABLED, (Object)false);
        boolean isTrailing = request.request().firstMatchingHeader("x-amz-trailer").isPresent();
        boolean bl = isFlexible = request.hasProperty(CHECKSUM_ALGORITHM) && !ChecksumUtil.hasChecksumHeader(request);
        if (isEventStreaming) {
            if (isPayloadSigning) {
                return OptionalDependencyLoaderUtil.getEventStreamV4PayloadSigner(properties.getCredentials(), properties.getCredentialScope(), properties.getSigningClock());
            }
            throw new UnsupportedOperationException("Unsigned payload is not supported with event-streaming.");
        }
        if (ChecksumUtil.useChunkEncoding(isPayloadSigning, isChunkEncoding, isTrailing || isFlexible)) {
            return AwsChunkedV4PayloadSigner.builder().credentialScope(properties.getCredentialScope()).chunkSize(131072).checksumStore(DefaultAwsV4HttpSigner.checksumStore(request)).checksumAlgorithm((ChecksumAlgorithm)request.property(CHECKSUM_ALGORITHM)).build();
        }
        return V4PayloadSigner.create();
    }

    private static V4PayloadSigner v4PayloadAsyncSigner(AsyncSignRequest<? extends AwsCredentialsIdentity> request, V4Properties properties) {
        boolean isFlexible;
        boolean isPayloadSigning = ChecksumUtil.isPayloadSigning(request);
        boolean isEventStreaming = ChecksumUtil.isEventStreaming(request.request());
        boolean isChunkEncoding = (Boolean)request.requireProperty(CHUNK_ENCODING_ENABLED, (Object)false);
        boolean isTrailing = request.request().firstMatchingHeader("x-amz-trailer").isPresent();
        boolean bl = isFlexible = request.hasProperty(CHECKSUM_ALGORITHM) && !ChecksumUtil.hasChecksumHeader(request);
        if (isEventStreaming) {
            if (isPayloadSigning) {
                return OptionalDependencyLoaderUtil.getEventStreamV4PayloadSigner(properties.getCredentials(), properties.getCredentialScope(), properties.getSigningClock());
            }
            throw new UnsupportedOperationException("Unsigned payload is not supported with event-streaming.");
        }
        boolean nonEvenstreamingPayloadSigning = isPayloadSigning;
        if (DefaultAwsV4HttpSigner.asyncShouldTreatAsUnsigned(request)) {
            nonEvenstreamingPayloadSigning = false;
        }
        if (ChecksumUtil.useChunkEncoding(nonEvenstreamingPayloadSigning, isChunkEncoding, isTrailing || isFlexible)) {
            return AwsChunkedV4PayloadSigner.builder().credentialScope(properties.getCredentialScope()).chunkSize(131072).checksumStore(DefaultAwsV4HttpSigner.checksumStore(request)).checksumAlgorithm((ChecksumAlgorithm)request.property(CHECKSUM_ALGORITHM)).build();
        }
        return V4PayloadSigner.create();
    }

    private static SignedRequest doSign(SignRequest<? extends AwsCredentialsIdentity> request, Checksummer checksummer, V4RequestSigner requestSigner, V4PayloadSigner payloadSigner) {
        SdkHttpRequest.Builder requestBuilder = (SdkHttpRequest.Builder)request.request().toBuilder();
        ContentStreamProvider requestPayload = request.payload().orElse(null);
        checksummer.checksum(requestPayload, requestBuilder);
        payloadSigner.beforeSigning(requestBuilder, requestPayload);
        V4RequestSigningResult requestSigningResult = requestSigner.sign(requestBuilder);
        ContentStreamProvider signedPayload = null;
        if (requestPayload != null) {
            signedPayload = payloadSigner.sign(requestPayload, requestSigningResult);
        }
        return (SignedRequest)((SignedRequest.Builder)((SignedRequest.Builder)SignedRequest.builder().request((SdkHttpRequest)requestSigningResult.getSignedRequest().build())).payload((Object)signedPayload)).build();
    }

    private static CompletableFuture<AsyncSignedRequest> doSignAsync(AsyncSignRequest<? extends AwsCredentialsIdentity> request, Checksummer checksummer, V4RequestSigner requestSigner, V4PayloadSigner payloadSigner) {
        SdkHttpRequest.Builder requestBuilder = (SdkHttpRequest.Builder)request.request().toBuilder();
        Publisher requestPayload = request.payload().orElse(null);
        return ((CompletableFuture)checksummer.checksum((Publisher<ByteBuffer>)requestPayload, requestBuilder).thenCompose(checksummedPayload -> payloadSigner.beforeSigningAsync(requestBuilder, (Publisher<ByteBuffer>)checksummedPayload))).thenApply(p -> {
            SdkHttpRequest.Builder requestToSign = (SdkHttpRequest.Builder)p.left();
            Publisher payloadToSign = ((Optional)p.right()).orElse(null);
            V4RequestSigningResult requestSigningResult = requestSigner.sign(requestToSign);
            Publisher<ByteBuffer> signedPayload = null;
            if (payloadToSign != null) {
                signedPayload = payloadSigner.signAsync((Publisher<ByteBuffer>)payloadToSign, requestSigningResult);
            }
            return (AsyncSignedRequest)((AsyncSignedRequest.Builder)((AsyncSignedRequest.Builder)AsyncSignedRequest.builder().request((SdkHttpRequest)requestSigningResult.getSignedRequest().build())).payload(signedPayload)).build();
        });
    }

    private static Duration validateExpirationDuration(Duration expirationDuration) {
        if (!DefaultAwsV4HttpSigner.isBetweenInclusive(Duration.ofSeconds(1L), expirationDuration, SignerConstant.PRESIGN_URL_MAX_EXPIRATION_DURATION)) {
            throw new IllegalArgumentException("Requests that are pre-signed by SigV4 algorithm are valid for at least 1 second and at most 7 days. The expiration duration set on the current request [" + expirationDuration + "] does not meet these bounds.");
        }
        return expirationDuration;
    }

    private static boolean isBetweenInclusive(Duration start, Duration x, Duration end) {
        return start.compareTo(x) <= 0 && x.compareTo(end) <= 0;
    }

    private static PayloadChecksumStore checksumStore(BaseSignRequest<?, ?> request) {
        PayloadChecksumStore cache = (PayloadChecksumStore)request.property(SdkInternalHttpSignerProperty.CHECKSUM_STORE);
        if (cache == null) {
            return NoOpPayloadChecksumStore.create();
        }
        return cache;
    }
}

