/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.honeycode.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.honeycode.model.HoneycodeResponse;
import software.amazon.awssdk.services.honeycode.model.ResourceIdsCopier;
import software.amazon.awssdk.services.honeycode.model.RowIdListCopier;
import software.amazon.awssdk.services.honeycode.model.TableRow;
import software.amazon.awssdk.services.honeycode.model.TableRowsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTableRowsResponse
extends HoneycodeResponse
implements ToCopyableBuilder<Builder, ListTableRowsResponse> {
    private static final SdkField<List<String>> COLUMN_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("columnIds").getter(ListTableRowsResponse.getter(ListTableRowsResponse::columnIds)).setter(ListTableRowsResponse.setter(Builder::columnIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("columnIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<TableRow>> ROWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("rows").getter(ListTableRowsResponse.getter(ListTableRowsResponse::rows)).setter(ListTableRowsResponse.setter(Builder::rows)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rows").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TableRow::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ROW_IDS_NOT_FOUND_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("rowIdsNotFound").getter(ListTableRowsResponse.getter(ListTableRowsResponse::rowIdsNotFound)).setter(ListTableRowsResponse.setter(Builder::rowIdsNotFound)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rowIdsNotFound").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListTableRowsResponse.getter(ListTableRowsResponse::nextToken)).setter(ListTableRowsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<Long> WORKBOOK_CURSOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("workbookCursor").getter(ListTableRowsResponse.getter(ListTableRowsResponse::workbookCursor)).setter(ListTableRowsResponse.setter(Builder::workbookCursor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workbookCursor").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_IDS_FIELD, ROWS_FIELD, ROW_IDS_NOT_FOUND_FIELD, NEXT_TOKEN_FIELD, WORKBOOK_CURSOR_FIELD));
    private final List<String> columnIds;
    private final List<TableRow> rows;
    private final List<String> rowIdsNotFound;
    private final String nextToken;
    private final Long workbookCursor;

    private ListTableRowsResponse(BuilderImpl builder) {
        super(builder);
        this.columnIds = builder.columnIds;
        this.rows = builder.rows;
        this.rowIdsNotFound = builder.rowIdsNotFound;
        this.nextToken = builder.nextToken;
        this.workbookCursor = builder.workbookCursor;
    }

    public final boolean hasColumnIds() {
        return this.columnIds != null && !(this.columnIds instanceof SdkAutoConstructList);
    }

    public final List<String> columnIds() {
        return this.columnIds;
    }

    public final boolean hasRows() {
        return this.rows != null && !(this.rows instanceof SdkAutoConstructList);
    }

    public final List<TableRow> rows() {
        return this.rows;
    }

    public final boolean hasRowIdsNotFound() {
        return this.rowIdsNotFound != null && !(this.rowIdsNotFound instanceof SdkAutoConstructList);
    }

    public final List<String> rowIdsNotFound() {
        return this.rowIdsNotFound;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Long workbookCursor() {
        return this.workbookCursor;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasColumnIds() ? this.columnIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRows() ? this.rows() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRowIdsNotFound() ? this.rowIdsNotFound() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.workbookCursor());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTableRowsResponse)) {
            return false;
        }
        ListTableRowsResponse other = (ListTableRowsResponse)((Object)obj);
        return this.hasColumnIds() == other.hasColumnIds() && Objects.equals(this.columnIds(), other.columnIds()) && this.hasRows() == other.hasRows() && Objects.equals(this.rows(), other.rows()) && this.hasRowIdsNotFound() == other.hasRowIdsNotFound() && Objects.equals(this.rowIdsNotFound(), other.rowIdsNotFound()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.workbookCursor(), other.workbookCursor());
    }

    public final String toString() {
        return ToString.builder((String)"ListTableRowsResponse").add("ColumnIds", this.hasColumnIds() ? this.columnIds() : null).add("Rows", this.hasRows() ? this.rows() : null).add("RowIdsNotFound", this.hasRowIdsNotFound() ? this.rowIdsNotFound() : null).add("NextToken", (Object)this.nextToken()).add("WorkbookCursor", (Object)this.workbookCursor()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "columnIds": {
                return Optional.ofNullable(clazz.cast(this.columnIds()));
            }
            case "rows": {
                return Optional.ofNullable(clazz.cast(this.rows()));
            }
            case "rowIdsNotFound": {
                return Optional.ofNullable(clazz.cast(this.rowIdsNotFound()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "workbookCursor": {
                return Optional.ofNullable(clazz.cast(this.workbookCursor()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTableRowsResponse, T> g) {
        return obj -> g.apply((ListTableRowsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends HoneycodeResponse.BuilderImpl
    implements Builder {
        private List<String> columnIds = DefaultSdkAutoConstructList.getInstance();
        private List<TableRow> rows = DefaultSdkAutoConstructList.getInstance();
        private List<String> rowIdsNotFound = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Long workbookCursor;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTableRowsResponse model) {
            super(model);
            this.columnIds(model.columnIds);
            this.rows(model.rows);
            this.rowIdsNotFound(model.rowIdsNotFound);
            this.nextToken(model.nextToken);
            this.workbookCursor(model.workbookCursor);
        }

        public final Collection<String> getColumnIds() {
            if (this.columnIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.columnIds;
        }

        @Override
        public final Builder columnIds(Collection<String> columnIds) {
            this.columnIds = ResourceIdsCopier.copy(columnIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnIds(String ... columnIds) {
            this.columnIds(Arrays.asList(columnIds));
            return this;
        }

        public final void setColumnIds(Collection<String> columnIds) {
            this.columnIds = ResourceIdsCopier.copy(columnIds);
        }

        public final Collection<TableRow.Builder> getRows() {
            if (this.rows instanceof SdkAutoConstructList) {
                return null;
            }
            return this.rows != null ? (Collection)this.rows.stream().map(TableRow::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder rows(Collection<TableRow> rows) {
            this.rows = TableRowsCopier.copy(rows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rows(TableRow ... rows) {
            this.rows(Arrays.asList(rows));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rows(Consumer<TableRow.Builder> ... rows) {
            this.rows(Stream.of(rows).map(c -> (TableRow)((TableRow.Builder)TableRow.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRows(Collection<TableRow.BuilderImpl> rows) {
            this.rows = TableRowsCopier.copyFromBuilder(rows);
        }

        public final Collection<String> getRowIdsNotFound() {
            if (this.rowIdsNotFound instanceof SdkAutoConstructList) {
                return null;
            }
            return this.rowIdsNotFound;
        }

        @Override
        public final Builder rowIdsNotFound(Collection<String> rowIdsNotFound) {
            this.rowIdsNotFound = RowIdListCopier.copy(rowIdsNotFound);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rowIdsNotFound(String ... rowIdsNotFound) {
            this.rowIdsNotFound(Arrays.asList(rowIdsNotFound));
            return this;
        }

        public final void setRowIdsNotFound(Collection<String> rowIdsNotFound) {
            this.rowIdsNotFound = RowIdListCopier.copy(rowIdsNotFound);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Long getWorkbookCursor() {
            return this.workbookCursor;
        }

        @Override
        public final Builder workbookCursor(Long workbookCursor) {
            this.workbookCursor = workbookCursor;
            return this;
        }

        public final void setWorkbookCursor(Long workbookCursor) {
            this.workbookCursor = workbookCursor;
        }

        @Override
        public ListTableRowsResponse build() {
            return new ListTableRowsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends HoneycodeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTableRowsResponse> {
        public Builder columnIds(Collection<String> var1);

        public Builder columnIds(String ... var1);

        public Builder rows(Collection<TableRow> var1);

        public Builder rows(TableRow ... var1);

        public Builder rows(Consumer<TableRow.Builder> ... var1);

        public Builder rowIdsNotFound(Collection<String> var1);

        public Builder rowIdsNotFound(String ... var1);

        public Builder nextToken(String var1);

        public Builder workbookCursor(Long var1);
    }
}

