/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.honeycode.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.honeycode.model.HoneycodeRequest;
import software.amazon.awssdk.services.honeycode.model.VariableValue;
import software.amazon.awssdk.services.honeycode.model.VariableValueMapCopier;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InvokeScreenAutomationRequest
extends HoneycodeRequest
implements ToCopyableBuilder<Builder, InvokeScreenAutomationRequest> {
    private static final SdkField<String> WORKBOOK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workbookId").getter(InvokeScreenAutomationRequest.getter(InvokeScreenAutomationRequest::workbookId)).setter(InvokeScreenAutomationRequest.setter(Builder::workbookId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("workbookId").build()}).build();
    private static final SdkField<String> APP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appId").getter(InvokeScreenAutomationRequest.getter(InvokeScreenAutomationRequest::appId)).setter(InvokeScreenAutomationRequest.setter(Builder::appId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("appId").build()}).build();
    private static final SdkField<String> SCREEN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("screenId").getter(InvokeScreenAutomationRequest.getter(InvokeScreenAutomationRequest::screenId)).setter(InvokeScreenAutomationRequest.setter(Builder::screenId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("screenId").build()}).build();
    private static final SdkField<String> SCREEN_AUTOMATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("screenAutomationId").getter(InvokeScreenAutomationRequest.getter(InvokeScreenAutomationRequest::screenAutomationId)).setter(InvokeScreenAutomationRequest.setter(Builder::screenAutomationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("automationId").build()}).build();
    private static final SdkField<Map<String, VariableValue>> VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("variables").getter(InvokeScreenAutomationRequest.getter(InvokeScreenAutomationRequest::variables)).setter(InvokeScreenAutomationRequest.setter(Builder::variables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variables").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VariableValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> ROW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("rowId").getter(InvokeScreenAutomationRequest.getter(InvokeScreenAutomationRequest::rowId)).setter(InvokeScreenAutomationRequest.setter(Builder::rowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rowId").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientRequestToken").getter(InvokeScreenAutomationRequest.getter(InvokeScreenAutomationRequest::clientRequestToken)).setter(InvokeScreenAutomationRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKBOOK_ID_FIELD, APP_ID_FIELD, SCREEN_ID_FIELD, SCREEN_AUTOMATION_ID_FIELD, VARIABLES_FIELD, ROW_ID_FIELD, CLIENT_REQUEST_TOKEN_FIELD));
    private final String workbookId;
    private final String appId;
    private final String screenId;
    private final String screenAutomationId;
    private final Map<String, VariableValue> variables;
    private final String rowId;
    private final String clientRequestToken;

    private InvokeScreenAutomationRequest(BuilderImpl builder) {
        super(builder);
        this.workbookId = builder.workbookId;
        this.appId = builder.appId;
        this.screenId = builder.screenId;
        this.screenAutomationId = builder.screenAutomationId;
        this.variables = builder.variables;
        this.rowId = builder.rowId;
        this.clientRequestToken = builder.clientRequestToken;
    }

    public final String workbookId() {
        return this.workbookId;
    }

    public final String appId() {
        return this.appId;
    }

    public final String screenId() {
        return this.screenId;
    }

    public final String screenAutomationId() {
        return this.screenAutomationId;
    }

    public final boolean hasVariables() {
        return this.variables != null && !(this.variables instanceof SdkAutoConstructMap);
    }

    public final Map<String, VariableValue> variables() {
        return this.variables;
    }

    public final String rowId() {
        return this.rowId;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workbookId());
        hashCode = 31 * hashCode + Objects.hashCode(this.appId());
        hashCode = 31 * hashCode + Objects.hashCode(this.screenId());
        hashCode = 31 * hashCode + Objects.hashCode(this.screenAutomationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVariables() ? this.variables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.rowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvokeScreenAutomationRequest)) {
            return false;
        }
        InvokeScreenAutomationRequest other = (InvokeScreenAutomationRequest)((Object)obj);
        return Objects.equals(this.workbookId(), other.workbookId()) && Objects.equals(this.appId(), other.appId()) && Objects.equals(this.screenId(), other.screenId()) && Objects.equals(this.screenAutomationId(), other.screenAutomationId()) && this.hasVariables() == other.hasVariables() && Objects.equals(this.variables(), other.variables()) && Objects.equals(this.rowId(), other.rowId()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken());
    }

    public final String toString() {
        return ToString.builder((String)"InvokeScreenAutomationRequest").add("WorkbookId", (Object)this.workbookId()).add("AppId", (Object)this.appId()).add("ScreenId", (Object)this.screenId()).add("ScreenAutomationId", (Object)this.screenAutomationId()).add("Variables", (Object)(this.variables() == null ? null : "*** Sensitive Data Redacted ***")).add("RowId", (Object)this.rowId()).add("ClientRequestToken", (Object)this.clientRequestToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "workbookId": {
                return Optional.ofNullable(clazz.cast(this.workbookId()));
            }
            case "appId": {
                return Optional.ofNullable(clazz.cast(this.appId()));
            }
            case "screenId": {
                return Optional.ofNullable(clazz.cast(this.screenId()));
            }
            case "screenAutomationId": {
                return Optional.ofNullable(clazz.cast(this.screenAutomationId()));
            }
            case "variables": {
                return Optional.ofNullable(clazz.cast(this.variables()));
            }
            case "rowId": {
                return Optional.ofNullable(clazz.cast(this.rowId()));
            }
            case "clientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InvokeScreenAutomationRequest, T> g) {
        return obj -> g.apply((InvokeScreenAutomationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends HoneycodeRequest.BuilderImpl
    implements Builder {
        private String workbookId;
        private String appId;
        private String screenId;
        private String screenAutomationId;
        private Map<String, VariableValue> variables = DefaultSdkAutoConstructMap.getInstance();
        private String rowId;
        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(InvokeScreenAutomationRequest model) {
            super(model);
            this.workbookId(model.workbookId);
            this.appId(model.appId);
            this.screenId(model.screenId);
            this.screenAutomationId(model.screenAutomationId);
            this.variables(model.variables);
            this.rowId(model.rowId);
            this.clientRequestToken(model.clientRequestToken);
        }

        public final String getWorkbookId() {
            return this.workbookId;
        }

        @Override
        public final Builder workbookId(String workbookId) {
            this.workbookId = workbookId;
            return this;
        }

        public final void setWorkbookId(String workbookId) {
            this.workbookId = workbookId;
        }

        public final String getAppId() {
            return this.appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        public final String getScreenId() {
            return this.screenId;
        }

        @Override
        public final Builder screenId(String screenId) {
            this.screenId = screenId;
            return this;
        }

        public final void setScreenId(String screenId) {
            this.screenId = screenId;
        }

        public final String getScreenAutomationId() {
            return this.screenAutomationId;
        }

        @Override
        public final Builder screenAutomationId(String screenAutomationId) {
            this.screenAutomationId = screenAutomationId;
            return this;
        }

        public final void setScreenAutomationId(String screenAutomationId) {
            this.screenAutomationId = screenAutomationId;
        }

        public final Map<String, VariableValue.Builder> getVariables() {
            if (this.variables instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.variables != null ? CollectionUtils.mapValues(this.variables, VariableValue::toBuilder) : null;
        }

        @Override
        public final Builder variables(Map<String, VariableValue> variables) {
            this.variables = VariableValueMapCopier.copy(variables);
            return this;
        }

        public final void setVariables(Map<String, VariableValue.BuilderImpl> variables) {
            this.variables = VariableValueMapCopier.copyFromBuilder(variables);
        }

        public final String getRowId() {
            return this.rowId;
        }

        @Override
        public final Builder rowId(String rowId) {
            this.rowId = rowId;
            return this;
        }

        public final void setRowId(String rowId) {
            this.rowId = rowId;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public InvokeScreenAutomationRequest build() {
            return new InvokeScreenAutomationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends HoneycodeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, InvokeScreenAutomationRequest> {
        public Builder workbookId(String var1);

        public Builder appId(String var1);

        public Builder screenId(String var1);

        public Builder screenAutomationId(String var1);

        public Builder variables(Map<String, VariableValue> var1);

        public Builder rowId(String var1);

        public Builder clientRequestToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

