/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.honeycode.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.honeycode.model.HoneycodeRequest;
import software.amazon.awssdk.services.honeycode.model.UpsertRowData;
import software.amazon.awssdk.services.honeycode.model.UpsertRowDataListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchUpsertTableRowsRequest
extends HoneycodeRequest
implements ToCopyableBuilder<Builder, BatchUpsertTableRowsRequest> {
    private static final SdkField<String> WORKBOOK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workbookId").getter(BatchUpsertTableRowsRequest.getter(BatchUpsertTableRowsRequest::workbookId)).setter(BatchUpsertTableRowsRequest.setter(Builder::workbookId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("workbookId").build()}).build();
    private static final SdkField<String> TABLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tableId").getter(BatchUpsertTableRowsRequest.getter(BatchUpsertTableRowsRequest::tableId)).setter(BatchUpsertTableRowsRequest.setter(Builder::tableId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("tableId").build()}).build();
    private static final SdkField<List<UpsertRowData>> ROWS_TO_UPSERT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("rowsToUpsert").getter(BatchUpsertTableRowsRequest.getter(BatchUpsertTableRowsRequest::rowsToUpsert)).setter(BatchUpsertTableRowsRequest.setter(Builder::rowsToUpsert)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rowsToUpsert").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UpsertRowData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientRequestToken").getter(BatchUpsertTableRowsRequest.getter(BatchUpsertTableRowsRequest::clientRequestToken)).setter(BatchUpsertTableRowsRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKBOOK_ID_FIELD, TABLE_ID_FIELD, ROWS_TO_UPSERT_FIELD, CLIENT_REQUEST_TOKEN_FIELD));
    private final String workbookId;
    private final String tableId;
    private final List<UpsertRowData> rowsToUpsert;
    private final String clientRequestToken;

    private BatchUpsertTableRowsRequest(BuilderImpl builder) {
        super(builder);
        this.workbookId = builder.workbookId;
        this.tableId = builder.tableId;
        this.rowsToUpsert = builder.rowsToUpsert;
        this.clientRequestToken = builder.clientRequestToken;
    }

    public final String workbookId() {
        return this.workbookId;
    }

    public final String tableId() {
        return this.tableId;
    }

    public final boolean hasRowsToUpsert() {
        return this.rowsToUpsert != null && !(this.rowsToUpsert instanceof SdkAutoConstructList);
    }

    public final List<UpsertRowData> rowsToUpsert() {
        return this.rowsToUpsert;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workbookId());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRowsToUpsert() ? this.rowsToUpsert() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpsertTableRowsRequest)) {
            return false;
        }
        BatchUpsertTableRowsRequest other = (BatchUpsertTableRowsRequest)((Object)obj);
        return Objects.equals(this.workbookId(), other.workbookId()) && Objects.equals(this.tableId(), other.tableId()) && this.hasRowsToUpsert() == other.hasRowsToUpsert() && Objects.equals(this.rowsToUpsert(), other.rowsToUpsert()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken());
    }

    public final String toString() {
        return ToString.builder((String)"BatchUpsertTableRowsRequest").add("WorkbookId", (Object)this.workbookId()).add("TableId", (Object)this.tableId()).add("RowsToUpsert", this.hasRowsToUpsert() ? this.rowsToUpsert() : null).add("ClientRequestToken", (Object)this.clientRequestToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "workbookId": {
                return Optional.ofNullable(clazz.cast(this.workbookId()));
            }
            case "tableId": {
                return Optional.ofNullable(clazz.cast(this.tableId()));
            }
            case "rowsToUpsert": {
                return Optional.ofNullable(clazz.cast(this.rowsToUpsert()));
            }
            case "clientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchUpsertTableRowsRequest, T> g) {
        return obj -> g.apply((BatchUpsertTableRowsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends HoneycodeRequest.BuilderImpl
    implements Builder {
        private String workbookId;
        private String tableId;
        private List<UpsertRowData> rowsToUpsert = DefaultSdkAutoConstructList.getInstance();
        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpsertTableRowsRequest model) {
            super(model);
            this.workbookId(model.workbookId);
            this.tableId(model.tableId);
            this.rowsToUpsert(model.rowsToUpsert);
            this.clientRequestToken(model.clientRequestToken);
        }

        public final String getWorkbookId() {
            return this.workbookId;
        }

        @Override
        public final Builder workbookId(String workbookId) {
            this.workbookId = workbookId;
            return this;
        }

        public final void setWorkbookId(String workbookId) {
            this.workbookId = workbookId;
        }

        public final String getTableId() {
            return this.tableId;
        }

        @Override
        public final Builder tableId(String tableId) {
            this.tableId = tableId;
            return this;
        }

        public final void setTableId(String tableId) {
            this.tableId = tableId;
        }

        public final Collection<UpsertRowData.Builder> getRowsToUpsert() {
            if (this.rowsToUpsert instanceof SdkAutoConstructList) {
                return null;
            }
            return this.rowsToUpsert != null ? (Collection)this.rowsToUpsert.stream().map(UpsertRowData::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder rowsToUpsert(Collection<UpsertRowData> rowsToUpsert) {
            this.rowsToUpsert = UpsertRowDataListCopier.copy(rowsToUpsert);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rowsToUpsert(UpsertRowData ... rowsToUpsert) {
            this.rowsToUpsert(Arrays.asList(rowsToUpsert));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rowsToUpsert(Consumer<UpsertRowData.Builder> ... rowsToUpsert) {
            this.rowsToUpsert(Stream.of(rowsToUpsert).map(c -> (UpsertRowData)((UpsertRowData.Builder)UpsertRowData.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRowsToUpsert(Collection<UpsertRowData.BuilderImpl> rowsToUpsert) {
            this.rowsToUpsert = UpsertRowDataListCopier.copyFromBuilder(rowsToUpsert);
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchUpsertTableRowsRequest build() {
            return new BatchUpsertTableRowsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends HoneycodeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchUpsertTableRowsRequest> {
        public Builder workbookId(String var1);

        public Builder tableId(String var1);

        public Builder rowsToUpsert(Collection<UpsertRowData> var1);

        public Builder rowsToUpsert(UpsertRowData ... var1);

        public Builder rowsToUpsert(Consumer<UpsertRowData.Builder> ... var1);

        public Builder clientRequestToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

