/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum LoggerLevel {
    DEBUG("DEBUG"),
    INFO("INFO"),
    WARN("WARN"),
    ERROR("ERROR"),
    FATAL("FATAL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private LoggerLevel(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LoggerLevel fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(LoggerLevel.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LoggerLevel> knownValues() {
        return Stream.of(LoggerLevel.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

