/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.greengrass.model.GreengrassRequest;
import software.amazon.awssdk.services.greengrass.model.Subscription;
import software.amazon.awssdk.services.greengrass.model.___listOfSubscriptionCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateSubscriptionDefinitionVersionRequest
extends GreengrassRequest
implements ToCopyableBuilder<Builder, CreateSubscriptionDefinitionVersionRequest> {
    private static final SdkField<String> AMZN_CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateSubscriptionDefinitionVersionRequest.getter(CreateSubscriptionDefinitionVersionRequest::amznClientToken)).setter(CreateSubscriptionDefinitionVersionRequest.setter(Builder::amznClientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-Client-Token").build()}).build();
    private static final SdkField<String> SUBSCRIPTION_DEFINITION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateSubscriptionDefinitionVersionRequest.getter(CreateSubscriptionDefinitionVersionRequest::subscriptionDefinitionId)).setter(CreateSubscriptionDefinitionVersionRequest.setter(Builder::subscriptionDefinitionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("SubscriptionDefinitionId").build()}).build();
    private static final SdkField<List<Subscription>> SUBSCRIPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateSubscriptionDefinitionVersionRequest.getter(CreateSubscriptionDefinitionVersionRequest::subscriptions)).setter(CreateSubscriptionDefinitionVersionRequest.setter(Builder::subscriptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subscriptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Subscription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMZN_CLIENT_TOKEN_FIELD, SUBSCRIPTION_DEFINITION_ID_FIELD, SUBSCRIPTIONS_FIELD));
    private final String amznClientToken;
    private final String subscriptionDefinitionId;
    private final List<Subscription> subscriptions;

    private CreateSubscriptionDefinitionVersionRequest(BuilderImpl builder) {
        super(builder);
        this.amznClientToken = builder.amznClientToken;
        this.subscriptionDefinitionId = builder.subscriptionDefinitionId;
        this.subscriptions = builder.subscriptions;
    }

    public String amznClientToken() {
        return this.amznClientToken;
    }

    public String subscriptionDefinitionId() {
        return this.subscriptionDefinitionId;
    }

    public List<Subscription> subscriptions() {
        return this.subscriptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.amznClientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriptionDefinitionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriptions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSubscriptionDefinitionVersionRequest)) {
            return false;
        }
        CreateSubscriptionDefinitionVersionRequest other = (CreateSubscriptionDefinitionVersionRequest)((Object)obj);
        return Objects.equals(this.amznClientToken(), other.amznClientToken()) && Objects.equals(this.subscriptionDefinitionId(), other.subscriptionDefinitionId()) && Objects.equals(this.subscriptions(), other.subscriptions());
    }

    public String toString() {
        return ToString.builder((String)"CreateSubscriptionDefinitionVersionRequest").add("AmznClientToken", (Object)this.amznClientToken()).add("SubscriptionDefinitionId", (Object)this.subscriptionDefinitionId()).add("Subscriptions", this.subscriptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AmznClientToken": {
                return Optional.ofNullable(clazz.cast(this.amznClientToken()));
            }
            case "SubscriptionDefinitionId": {
                return Optional.ofNullable(clazz.cast(this.subscriptionDefinitionId()));
            }
            case "Subscriptions": {
                return Optional.ofNullable(clazz.cast(this.subscriptions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSubscriptionDefinitionVersionRequest, T> g) {
        return obj -> g.apply((CreateSubscriptionDefinitionVersionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GreengrassRequest.BuilderImpl
    implements Builder {
        private String amznClientToken;
        private String subscriptionDefinitionId;
        private List<Subscription> subscriptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSubscriptionDefinitionVersionRequest model) {
            super(model);
            this.amznClientToken(model.amznClientToken);
            this.subscriptionDefinitionId(model.subscriptionDefinitionId);
            this.subscriptions(model.subscriptions);
        }

        public final String getAmznClientToken() {
            return this.amznClientToken;
        }

        @Override
        public final Builder amznClientToken(String amznClientToken) {
            this.amznClientToken = amznClientToken;
            return this;
        }

        public final void setAmznClientToken(String amznClientToken) {
            this.amznClientToken = amznClientToken;
        }

        public final String getSubscriptionDefinitionId() {
            return this.subscriptionDefinitionId;
        }

        @Override
        public final Builder subscriptionDefinitionId(String subscriptionDefinitionId) {
            this.subscriptionDefinitionId = subscriptionDefinitionId;
            return this;
        }

        public final void setSubscriptionDefinitionId(String subscriptionDefinitionId) {
            this.subscriptionDefinitionId = subscriptionDefinitionId;
        }

        public final Collection<Subscription.Builder> getSubscriptions() {
            return this.subscriptions != null ? (Collection)this.subscriptions.stream().map(Subscription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder subscriptions(Collection<Subscription> subscriptions) {
            this.subscriptions = ___listOfSubscriptionCopier.copy(subscriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscriptions(Subscription ... subscriptions) {
            this.subscriptions(Arrays.asList(subscriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscriptions(Consumer<Subscription.Builder> ... subscriptions) {
            this.subscriptions(Stream.of(subscriptions).map(c -> (Subscription)((Subscription.Builder)Subscription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSubscriptions(Collection<Subscription.BuilderImpl> subscriptions) {
            this.subscriptions = ___listOfSubscriptionCopier.copyFromBuilder(subscriptions);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSubscriptionDefinitionVersionRequest build() {
            return new CreateSubscriptionDefinitionVersionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GreengrassRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateSubscriptionDefinitionVersionRequest> {
        public Builder amznClientToken(String var1);

        public Builder subscriptionDefinitionId(String var1);

        public Builder subscriptions(Collection<Subscription> var1);

        public Builder subscriptions(Subscription ... var1);

        public Builder subscriptions(Consumer<Subscription.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

