/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.greengrass.model.GreengrassResponse;
import software.amazon.awssdk.services.greengrass.model.___mapOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDeviceDefinitionResponse
extends GreengrassResponse
implements ToCopyableBuilder<Builder, GetDeviceDefinitionResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetDeviceDefinitionResponse.getter(GetDeviceDefinitionResponse::arn)).setter(GetDeviceDefinitionResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> CREATION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetDeviceDefinitionResponse.getter(GetDeviceDefinitionResponse::creationTimestamp)).setter(GetDeviceDefinitionResponse.setter(Builder::creationTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimestamp").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetDeviceDefinitionResponse.getter(GetDeviceDefinitionResponse::id)).setter(GetDeviceDefinitionResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> LAST_UPDATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetDeviceDefinitionResponse.getter(GetDeviceDefinitionResponse::lastUpdatedTimestamp)).setter(GetDeviceDefinitionResponse.setter(Builder::lastUpdatedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTimestamp").build()}).build();
    private static final SdkField<String> LATEST_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetDeviceDefinitionResponse.getter(GetDeviceDefinitionResponse::latestVersion)).setter(GetDeviceDefinitionResponse.setter(Builder::latestVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestVersion").build()}).build();
    private static final SdkField<String> LATEST_VERSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetDeviceDefinitionResponse.getter(GetDeviceDefinitionResponse::latestVersionArn)).setter(GetDeviceDefinitionResponse.setter(Builder::latestVersionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestVersionArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetDeviceDefinitionResponse.getter(GetDeviceDefinitionResponse::name)).setter(GetDeviceDefinitionResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(GetDeviceDefinitionResponse.getter(GetDeviceDefinitionResponse::tags)).setter(GetDeviceDefinitionResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATION_TIMESTAMP_FIELD, ID_FIELD, LAST_UPDATED_TIMESTAMP_FIELD, LATEST_VERSION_FIELD, LATEST_VERSION_ARN_FIELD, NAME_FIELD, TAGS_FIELD));
    private final String arn;
    private final String creationTimestamp;
    private final String id;
    private final String lastUpdatedTimestamp;
    private final String latestVersion;
    private final String latestVersionArn;
    private final String name;
    private final Map<String, String> tags;

    private GetDeviceDefinitionResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.creationTimestamp = builder.creationTimestamp;
        this.id = builder.id;
        this.lastUpdatedTimestamp = builder.lastUpdatedTimestamp;
        this.latestVersion = builder.latestVersion;
        this.latestVersionArn = builder.latestVersionArn;
        this.name = builder.name;
        this.tags = builder.tags;
    }

    public String arn() {
        return this.arn;
    }

    public String creationTimestamp() {
        return this.creationTimestamp;
    }

    public String id() {
        return this.id;
    }

    public String lastUpdatedTimestamp() {
        return this.lastUpdatedTimestamp;
    }

    public String latestVersion() {
        return this.latestVersion;
    }

    public String latestVersionArn() {
        return this.latestVersionArn;
    }

    public String name() {
        return this.name;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDeviceDefinitionResponse)) {
            return false;
        }
        GetDeviceDefinitionResponse other = (GetDeviceDefinitionResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.creationTimestamp(), other.creationTimestamp()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.lastUpdatedTimestamp(), other.lastUpdatedTimestamp()) && Objects.equals(this.latestVersion(), other.latestVersion()) && Objects.equals(this.latestVersionArn(), other.latestVersionArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"GetDeviceDefinitionResponse").add("Arn", (Object)this.arn()).add("CreationTimestamp", (Object)this.creationTimestamp()).add("Id", (Object)this.id()).add("LastUpdatedTimestamp", (Object)this.lastUpdatedTimestamp()).add("LatestVersion", (Object)this.latestVersion()).add("LatestVersionArn", (Object)this.latestVersionArn()).add("Name", (Object)this.name()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "CreationTimestamp": {
                return Optional.ofNullable(clazz.cast(this.creationTimestamp()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "LastUpdatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTimestamp()));
            }
            case "LatestVersion": {
                return Optional.ofNullable(clazz.cast(this.latestVersion()));
            }
            case "LatestVersionArn": {
                return Optional.ofNullable(clazz.cast(this.latestVersionArn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDeviceDefinitionResponse, T> g) {
        return obj -> g.apply((GetDeviceDefinitionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GreengrassResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String creationTimestamp;
        private String id;
        private String lastUpdatedTimestamp;
        private String latestVersion;
        private String latestVersionArn;
        private String name;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDeviceDefinitionResponse model) {
            super(model);
            this.arn(model.arn);
            this.creationTimestamp(model.creationTimestamp);
            this.id(model.id);
            this.lastUpdatedTimestamp(model.lastUpdatedTimestamp);
            this.latestVersion(model.latestVersion);
            this.latestVersionArn(model.latestVersionArn);
            this.name(model.name);
            this.tags(model.tags);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getCreationTimestamp() {
            return this.creationTimestamp;
        }

        @Override
        public final Builder creationTimestamp(String creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public final void setCreationTimestamp(String creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getLastUpdatedTimestamp() {
            return this.lastUpdatedTimestamp;
        }

        @Override
        public final Builder lastUpdatedTimestamp(String lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
            return this;
        }

        public final void setLastUpdatedTimestamp(String lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
        }

        public final String getLatestVersion() {
            return this.latestVersion;
        }

        @Override
        public final Builder latestVersion(String latestVersion) {
            this.latestVersion = latestVersion;
            return this;
        }

        public final void setLatestVersion(String latestVersion) {
            this.latestVersion = latestVersion;
        }

        public final String getLatestVersionArn() {
            return this.latestVersionArn;
        }

        @Override
        public final Builder latestVersionArn(String latestVersionArn) {
            this.latestVersionArn = latestVersionArn;
            return this;
        }

        public final void setLatestVersionArn(String latestVersionArn) {
            this.latestVersionArn = latestVersionArn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
        }

        @Override
        public GetDeviceDefinitionResponse build() {
            return new GetDeviceDefinitionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GreengrassResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDeviceDefinitionResponse> {
        public Builder arn(String var1);

        public Builder creationTimestamp(String var1);

        public Builder id(String var1);

        public Builder lastUpdatedTimestamp(String var1);

        public Builder latestVersion(String var1);

        public Builder latestVersionArn(String var1);

        public Builder name(String var1);

        public Builder tags(Map<String, String> var1);
    }
}

