/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.ConnectionPasswordEncryption;
import software.amazon.awssdk.services.glue.model.EncryptionAtRest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataCatalogEncryptionSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataCatalogEncryptionSettings> {
    private static final SdkField<EncryptionAtRest> ENCRYPTION_AT_REST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DataCatalogEncryptionSettings.getter(DataCatalogEncryptionSettings::encryptionAtRest)).setter(DataCatalogEncryptionSettings.setter(Builder::encryptionAtRest)).constructor(EncryptionAtRest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionAtRest").build()}).build();
    private static final SdkField<ConnectionPasswordEncryption> CONNECTION_PASSWORD_ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DataCatalogEncryptionSettings.getter(DataCatalogEncryptionSettings::connectionPasswordEncryption)).setter(DataCatalogEncryptionSettings.setter(Builder::connectionPasswordEncryption)).constructor(ConnectionPasswordEncryption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionPasswordEncryption").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCRYPTION_AT_REST_FIELD, CONNECTION_PASSWORD_ENCRYPTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final EncryptionAtRest encryptionAtRest;
    private final ConnectionPasswordEncryption connectionPasswordEncryption;

    private DataCatalogEncryptionSettings(BuilderImpl builder) {
        this.encryptionAtRest = builder.encryptionAtRest;
        this.connectionPasswordEncryption = builder.connectionPasswordEncryption;
    }

    public EncryptionAtRest encryptionAtRest() {
        return this.encryptionAtRest;
    }

    public ConnectionPasswordEncryption connectionPasswordEncryption() {
        return this.connectionPasswordEncryption;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionAtRest());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionPasswordEncryption());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataCatalogEncryptionSettings)) {
            return false;
        }
        DataCatalogEncryptionSettings other = (DataCatalogEncryptionSettings)obj;
        return Objects.equals(this.encryptionAtRest(), other.encryptionAtRest()) && Objects.equals(this.connectionPasswordEncryption(), other.connectionPasswordEncryption());
    }

    public String toString() {
        return ToString.builder((String)"DataCatalogEncryptionSettings").add("EncryptionAtRest", (Object)this.encryptionAtRest()).add("ConnectionPasswordEncryption", (Object)this.connectionPasswordEncryption()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EncryptionAtRest": {
                return Optional.ofNullable(clazz.cast(this.encryptionAtRest()));
            }
            case "ConnectionPasswordEncryption": {
                return Optional.ofNullable(clazz.cast(this.connectionPasswordEncryption()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataCatalogEncryptionSettings, T> g) {
        return obj -> g.apply((DataCatalogEncryptionSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private EncryptionAtRest encryptionAtRest;
        private ConnectionPasswordEncryption connectionPasswordEncryption;

        private BuilderImpl() {
        }

        private BuilderImpl(DataCatalogEncryptionSettings model) {
            this.encryptionAtRest(model.encryptionAtRest);
            this.connectionPasswordEncryption(model.connectionPasswordEncryption);
        }

        public final EncryptionAtRest.Builder getEncryptionAtRest() {
            return this.encryptionAtRest != null ? this.encryptionAtRest.toBuilder() : null;
        }

        @Override
        public final Builder encryptionAtRest(EncryptionAtRest encryptionAtRest) {
            this.encryptionAtRest = encryptionAtRest;
            return this;
        }

        public final void setEncryptionAtRest(EncryptionAtRest.BuilderImpl encryptionAtRest) {
            this.encryptionAtRest = encryptionAtRest != null ? encryptionAtRest.build() : null;
        }

        public final ConnectionPasswordEncryption.Builder getConnectionPasswordEncryption() {
            return this.connectionPasswordEncryption != null ? this.connectionPasswordEncryption.toBuilder() : null;
        }

        @Override
        public final Builder connectionPasswordEncryption(ConnectionPasswordEncryption connectionPasswordEncryption) {
            this.connectionPasswordEncryption = connectionPasswordEncryption;
            return this;
        }

        public final void setConnectionPasswordEncryption(ConnectionPasswordEncryption.BuilderImpl connectionPasswordEncryption) {
            this.connectionPasswordEncryption = connectionPasswordEncryption != null ? connectionPasswordEncryption.build() : null;
        }

        public DataCatalogEncryptionSettings build() {
            return new DataCatalogEncryptionSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataCatalogEncryptionSettings> {
        public Builder encryptionAtRest(EncryptionAtRest var1);

        default public Builder encryptionAtRest(Consumer<EncryptionAtRest.Builder> encryptionAtRest) {
            return this.encryptionAtRest((EncryptionAtRest)((EncryptionAtRest.Builder)EncryptionAtRest.builder().applyMutation(encryptionAtRest)).build());
        }

        public Builder connectionPasswordEncryption(ConnectionPasswordEncryption var1);

        default public Builder connectionPasswordEncryption(Consumer<ConnectionPasswordEncryption.Builder> connectionPasswordEncryption) {
            return this.connectionPasswordEncryption((ConnectionPasswordEncryption)((ConnectionPasswordEncryption.Builder)ConnectionPasswordEncryption.builder().applyMutation(connectionPasswordEncryption)).build());
        }
    }
}

