/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.CatalogEntriesCopier;
import software.amazon.awssdk.services.glue.model.CatalogEntry;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.services.glue.model.Location;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetMappingRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, GetMappingRequest> {
    private static final SdkField<CatalogEntry> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(GetMappingRequest.getter(GetMappingRequest::source)).setter(GetMappingRequest.setter(Builder::source)).constructor(CatalogEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()}).build();
    private static final SdkField<List<CatalogEntry>> SINKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetMappingRequest.getter(GetMappingRequest::sinks)).setter(GetMappingRequest.setter(Builder::sinks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sinks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CatalogEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Location> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(GetMappingRequest.getter(GetMappingRequest::location)).setter(GetMappingRequest.setter(Builder::location)).constructor(Location::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FIELD, SINKS_FIELD, LOCATION_FIELD));
    private final CatalogEntry source;
    private final List<CatalogEntry> sinks;
    private final Location location;

    private GetMappingRequest(BuilderImpl builder) {
        super(builder);
        this.source = builder.source;
        this.sinks = builder.sinks;
        this.location = builder.location;
    }

    public CatalogEntry source() {
        return this.source;
    }

    public List<CatalogEntry> sinks() {
        return this.sinks;
    }

    public Location location() {
        return this.location;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.sinks());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMappingRequest)) {
            return false;
        }
        GetMappingRequest other = (GetMappingRequest)((Object)obj);
        return Objects.equals(this.source(), other.source()) && Objects.equals(this.sinks(), other.sinks()) && Objects.equals(this.location(), other.location());
    }

    public String toString() {
        return ToString.builder((String)"GetMappingRequest").add("Source", (Object)this.source()).add("Sinks", this.sinks()).add("Location", (Object)this.location()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "Sinks": {
                return Optional.ofNullable(clazz.cast(this.sinks()));
            }
            case "Location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMappingRequest, T> g) {
        return obj -> g.apply((GetMappingRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private CatalogEntry source;
        private List<CatalogEntry> sinks = DefaultSdkAutoConstructList.getInstance();
        private Location location;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMappingRequest model) {
            super(model);
            this.source(model.source);
            this.sinks(model.sinks);
            this.location(model.location);
        }

        public final CatalogEntry.Builder getSource() {
            return this.source != null ? this.source.toBuilder() : null;
        }

        @Override
        public final Builder source(CatalogEntry source) {
            this.source = source;
            return this;
        }

        public final void setSource(CatalogEntry.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        public final Collection<CatalogEntry.Builder> getSinks() {
            return this.sinks != null ? (Collection)this.sinks.stream().map(CatalogEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder sinks(Collection<CatalogEntry> sinks) {
            this.sinks = CatalogEntriesCopier.copy(sinks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sinks(CatalogEntry ... sinks) {
            this.sinks(Arrays.asList(sinks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sinks(Consumer<CatalogEntry.Builder> ... sinks) {
            this.sinks(Stream.of(sinks).map(c -> (CatalogEntry)((CatalogEntry.Builder)CatalogEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSinks(Collection<CatalogEntry.BuilderImpl> sinks) {
            this.sinks = CatalogEntriesCopier.copyFromBuilder(sinks);
        }

        public final Location.Builder getLocation() {
            return this.location != null ? this.location.toBuilder() : null;
        }

        @Override
        public final Builder location(Location location) {
            this.location = location;
            return this;
        }

        public final void setLocation(Location.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetMappingRequest build() {
            return new GetMappingRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetMappingRequest> {
        public Builder source(CatalogEntry var1);

        default public Builder source(Consumer<CatalogEntry.Builder> source) {
            return this.source((CatalogEntry)((CatalogEntry.Builder)CatalogEntry.builder().applyMutation(source)).build());
        }

        public Builder sinks(Collection<CatalogEntry> var1);

        public Builder sinks(CatalogEntry ... var1);

        public Builder sinks(Consumer<CatalogEntry.Builder> ... var1);

        public Builder location(Location var1);

        default public Builder location(Consumer<Location.Builder> location) {
            return this.location((Location)((Location.Builder)Location.builder().applyMutation(location)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

