/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum WorkerType {
    STANDARD("Standard"),
    G_1_X("G.1X"),
    G_2_X("G.2X"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private WorkerType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static WorkerType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(WorkerType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<WorkerType> knownValues() {
        return Stream.of(WorkerType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

