/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.model.GetJobBookmarksRequest;
import software.amazon.awssdk.services.glue.model.GetJobBookmarksResponse;
import software.amazon.awssdk.services.glue.model.JobBookmarkEntry;

public class GetJobBookmarksIterable
implements SdkIterable<GetJobBookmarksResponse> {
    private final GlueClient client;
    private final GetJobBookmarksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetJobBookmarksIterable(GlueClient client, GetJobBookmarksRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetJobBookmarksResponseFetcher();
    }

    public Iterator<GetJobBookmarksResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<JobBookmarkEntry> jobBookmarkEntries() {
        Function<GetJobBookmarksResponse, Iterator> getIterator = response -> {
            if (response != null && response.jobBookmarkEntries() != null) {
                return response.jobBookmarkEntries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetJobBookmarksResponseFetcher
    implements SyncPageFetcher<GetJobBookmarksResponse> {
        private GetJobBookmarksResponseFetcher() {
        }

        public boolean hasNextPage(GetJobBookmarksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetJobBookmarksResponse nextPage(GetJobBookmarksResponse previousPage) {
            if (previousPage == null) {
                return GetJobBookmarksIterable.this.client.getJobBookmarks(GetJobBookmarksIterable.this.firstRequest);
            }
            return GetJobBookmarksIterable.this.client.getJobBookmarks((GetJobBookmarksRequest)((Object)GetJobBookmarksIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

