/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.services.glue.model.Job;
import software.amazon.awssdk.services.glue.model.JobListCopier;
import software.amazon.awssdk.services.glue.model.JobNameListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetJobsResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, BatchGetJobsResponse> {
    private static final SdkField<List<Job>> JOBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(BatchGetJobsResponse.getter(BatchGetJobsResponse::jobs)).setter(BatchGetJobsResponse.setter(Builder::jobs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Jobs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Job::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> JOBS_NOT_FOUND_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(BatchGetJobsResponse.getter(BatchGetJobsResponse::jobsNotFound)).setter(BatchGetJobsResponse.setter(Builder::jobsNotFound)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobsNotFound").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOBS_FIELD, JOBS_NOT_FOUND_FIELD));
    private final List<Job> jobs;
    private final List<String> jobsNotFound;

    private BatchGetJobsResponse(BuilderImpl builder) {
        super(builder);
        this.jobs = builder.jobs;
        this.jobsNotFound = builder.jobsNotFound;
    }

    public List<Job> jobs() {
        return this.jobs;
    }

    public List<String> jobsNotFound() {
        return this.jobsNotFound;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobs());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobsNotFound());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetJobsResponse)) {
            return false;
        }
        BatchGetJobsResponse other = (BatchGetJobsResponse)((Object)obj);
        return Objects.equals(this.jobs(), other.jobs()) && Objects.equals(this.jobsNotFound(), other.jobsNotFound());
    }

    public String toString() {
        return ToString.builder((String)"BatchGetJobsResponse").add("Jobs", this.jobs()).add("JobsNotFound", this.jobsNotFound()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Jobs": {
                return Optional.ofNullable(clazz.cast(this.jobs()));
            }
            case "JobsNotFound": {
                return Optional.ofNullable(clazz.cast(this.jobsNotFound()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetJobsResponse, T> g) {
        return obj -> g.apply((BatchGetJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private List<Job> jobs = DefaultSdkAutoConstructList.getInstance();
        private List<String> jobsNotFound = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetJobsResponse model) {
            super(model);
            this.jobs(model.jobs);
            this.jobsNotFound(model.jobsNotFound);
        }

        public final Collection<Job.Builder> getJobs() {
            return this.jobs != null ? (Collection)this.jobs.stream().map(Job::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder jobs(Collection<Job> jobs) {
            this.jobs = JobListCopier.copy(jobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobs(Job ... jobs) {
            this.jobs(Arrays.asList(jobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobs(Consumer<Job.Builder> ... jobs) {
            this.jobs(Stream.of(jobs).map(c -> (Job)((Job.Builder)Job.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setJobs(Collection<Job.BuilderImpl> jobs) {
            this.jobs = JobListCopier.copyFromBuilder(jobs);
        }

        public final Collection<String> getJobsNotFound() {
            return this.jobsNotFound;
        }

        @Override
        public final Builder jobsNotFound(Collection<String> jobsNotFound) {
            this.jobsNotFound = JobNameListCopier.copy(jobsNotFound);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobsNotFound(String ... jobsNotFound) {
            this.jobsNotFound(Arrays.asList(jobsNotFound));
            return this;
        }

        public final void setJobsNotFound(Collection<String> jobsNotFound) {
            this.jobsNotFound = JobNameListCopier.copy(jobsNotFound);
        }

        @Override
        public BatchGetJobsResponse build() {
            return new BatchGetJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetJobsResponse> {
        public Builder jobs(Collection<Job> var1);

        public Builder jobs(Job ... var1);

        public Builder jobs(Consumer<Job.Builder> ... var1);

        public Builder jobsNotFound(Collection<String> var1);

        public Builder jobsNotFound(String ... var1);
    }
}

