/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueAsyncClient;
import software.amazon.awssdk.services.glue.internal.UserAgentUtils;
import software.amazon.awssdk.services.glue.model.GetResourcePoliciesRequest;
import software.amazon.awssdk.services.glue.model.GetResourcePoliciesResponse;
import software.amazon.awssdk.services.glue.model.GluePolicy;

public class GetResourcePoliciesPublisher
implements SdkPublisher<GetResourcePoliciesResponse> {
    private final GlueAsyncClient client;
    private final GetResourcePoliciesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetResourcePoliciesPublisher(GlueAsyncClient client, GetResourcePoliciesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetResourcePoliciesPublisher(GlueAsyncClient client, GetResourcePoliciesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetResourcePoliciesResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetResourcePoliciesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<GluePolicy> getResourcePoliciesResponseList() {
        return this.flatMapIterable(response -> response.getResourcePoliciesResponseList());
    }

    private class GetResourcePoliciesResponseFetcher
    implements AsyncPageFetcher<GetResourcePoliciesResponse> {
        private GetResourcePoliciesResponseFetcher() {
        }

        public boolean hasNextPage(GetResourcePoliciesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetResourcePoliciesResponse> nextPage(GetResourcePoliciesResponse previousPage) {
            if (previousPage == null) {
                return GetResourcePoliciesPublisher.this.client.getResourcePolicies(GetResourcePoliciesPublisher.this.firstRequest);
            }
            return GetResourcePoliciesPublisher.this.client.getResourcePolicies((GetResourcePoliciesRequest)((Object)GetResourcePoliciesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

