/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.ErrorDetail;
import software.amazon.awssdk.services.glue.model.ResourceState;
import software.amazon.awssdk.services.glue.model.ViewDialect;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ViewValidation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ViewValidation> {
    private static final SdkField<String> DIALECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Dialect").getter(ViewValidation.getter(ViewValidation::dialectAsString)).setter(ViewValidation.setter(Builder::dialect)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dialect").build()}).build();
    private static final SdkField<String> DIALECT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DialectVersion").getter(ViewValidation.getter(ViewValidation::dialectVersion)).setter(ViewValidation.setter(Builder::dialectVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DialectVersion").build()}).build();
    private static final SdkField<String> VIEW_VALIDATION_TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ViewValidationText").getter(ViewValidation.getter(ViewValidation::viewValidationText)).setter(ViewValidation.setter(Builder::viewValidationText)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViewValidationText").build()}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdateTime").getter(ViewValidation.getter(ViewValidation::updateTime)).setter(ViewValidation.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateTime").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(ViewValidation.getter(ViewValidation::stateAsString)).setter(ViewValidation.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<ErrorDetail> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Error").getter(ViewValidation.getter(ViewValidation::error)).setter(ViewValidation.setter(Builder::error)).constructor(ErrorDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIALECT_FIELD, DIALECT_VERSION_FIELD, VIEW_VALIDATION_TEXT_FIELD, UPDATE_TIME_FIELD, STATE_FIELD, ERROR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ViewValidation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String dialect;
    private final String dialectVersion;
    private final String viewValidationText;
    private final Instant updateTime;
    private final String state;
    private final ErrorDetail error;

    private ViewValidation(BuilderImpl builder) {
        this.dialect = builder.dialect;
        this.dialectVersion = builder.dialectVersion;
        this.viewValidationText = builder.viewValidationText;
        this.updateTime = builder.updateTime;
        this.state = builder.state;
        this.error = builder.error;
    }

    public final ViewDialect dialect() {
        return ViewDialect.fromValue(this.dialect);
    }

    public final String dialectAsString() {
        return this.dialect;
    }

    public final String dialectVersion() {
        return this.dialectVersion;
    }

    public final String viewValidationText() {
        return this.viewValidationText;
    }

    public final Instant updateTime() {
        return this.updateTime;
    }

    public final ResourceState state() {
        return ResourceState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final ErrorDetail error() {
        return this.error;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dialectAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dialectVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.viewValidationText());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ViewValidation)) {
            return false;
        }
        ViewValidation other = (ViewValidation)obj;
        return Objects.equals(this.dialectAsString(), other.dialectAsString()) && Objects.equals(this.dialectVersion(), other.dialectVersion()) && Objects.equals(this.viewValidationText(), other.viewValidationText()) && Objects.equals(this.updateTime(), other.updateTime()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.error(), other.error());
    }

    public final String toString() {
        return ToString.builder((String)"ViewValidation").add("Dialect", (Object)this.dialectAsString()).add("DialectVersion", (Object)this.dialectVersion()).add("ViewValidationText", (Object)this.viewValidationText()).add("UpdateTime", (Object)this.updateTime()).add("State", (Object)this.stateAsString()).add("Error", (Object)this.error()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Dialect": {
                return Optional.ofNullable(clazz.cast(this.dialectAsString()));
            }
            case "DialectVersion": {
                return Optional.ofNullable(clazz.cast(this.dialectVersion()));
            }
            case "ViewValidationText": {
                return Optional.ofNullable(clazz.cast(this.viewValidationText()));
            }
            case "UpdateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "Error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Dialect", DIALECT_FIELD);
        map.put("DialectVersion", DIALECT_VERSION_FIELD);
        map.put("ViewValidationText", VIEW_VALIDATION_TEXT_FIELD);
        map.put("UpdateTime", UPDATE_TIME_FIELD);
        map.put("State", STATE_FIELD);
        map.put("Error", ERROR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ViewValidation, T> g) {
        return obj -> g.apply((ViewValidation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dialect;
        private String dialectVersion;
        private String viewValidationText;
        private Instant updateTime;
        private String state;
        private ErrorDetail error;

        private BuilderImpl() {
        }

        private BuilderImpl(ViewValidation model) {
            this.dialect(model.dialect);
            this.dialectVersion(model.dialectVersion);
            this.viewValidationText(model.viewValidationText);
            this.updateTime(model.updateTime);
            this.state(model.state);
            this.error(model.error);
        }

        public final String getDialect() {
            return this.dialect;
        }

        public final void setDialect(String dialect) {
            this.dialect = dialect;
        }

        @Override
        public final Builder dialect(String dialect) {
            this.dialect = dialect;
            return this;
        }

        @Override
        public final Builder dialect(ViewDialect dialect) {
            this.dialect(dialect == null ? null : dialect.toString());
            return this;
        }

        public final String getDialectVersion() {
            return this.dialectVersion;
        }

        public final void setDialectVersion(String dialectVersion) {
            this.dialectVersion = dialectVersion;
        }

        @Override
        public final Builder dialectVersion(String dialectVersion) {
            this.dialectVersion = dialectVersion;
            return this;
        }

        public final String getViewValidationText() {
            return this.viewValidationText;
        }

        public final void setViewValidationText(String viewValidationText) {
            this.viewValidationText = viewValidationText;
        }

        @Override
        public final Builder viewValidationText(String viewValidationText) {
            this.viewValidationText = viewValidationText;
            return this;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ResourceState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final ErrorDetail.Builder getError() {
            return this.error != null ? this.error.toBuilder() : null;
        }

        public final void setError(ErrorDetail.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(ErrorDetail error) {
            this.error = error;
            return this;
        }

        public ViewValidation build() {
            return new ViewValidation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ViewValidation> {
        public Builder dialect(String var1);

        public Builder dialect(ViewDialect var1);

        public Builder dialectVersion(String var1);

        public Builder viewValidationText(String var1);

        public Builder updateTime(Instant var1);

        public Builder state(String var1);

        public Builder state(ResourceState var1);

        public Builder error(ErrorDetail var1);

        default public Builder error(Consumer<ErrorDetail.Builder> error) {
            return this.error((ErrorDetail)((ErrorDetail.Builder)ErrorDetail.builder().applyMutation(error)).build());
        }
    }
}

