/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.LastRefreshType;
import software.amazon.awssdk.services.glue.model.ViewRepresentation;
import software.amazon.awssdk.services.glue.model.ViewRepresentationListCopier;
import software.amazon.awssdk.services.glue.model.ViewSubObjectVersionIdsListCopier;
import software.amazon.awssdk.services.glue.model.ViewSubObjectsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ViewDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ViewDefinition> {
    private static final SdkField<Boolean> IS_PROTECTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsProtected").getter(ViewDefinition.getter(ViewDefinition::isProtected)).setter(ViewDefinition.setter(Builder::isProtected)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsProtected").build()}).build();
    private static final SdkField<String> DEFINER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Definer").getter(ViewDefinition.getter(ViewDefinition::definer)).setter(ViewDefinition.setter(Builder::definer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Definer").build()}).build();
    private static final SdkField<Long> VIEW_VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ViewVersionId").getter(ViewDefinition.getter(ViewDefinition::viewVersionId)).setter(ViewDefinition.setter(Builder::viewVersionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViewVersionId").build()}).build();
    private static final SdkField<String> VIEW_VERSION_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ViewVersionToken").getter(ViewDefinition.getter(ViewDefinition::viewVersionToken)).setter(ViewDefinition.setter(Builder::viewVersionToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViewVersionToken").build()}).build();
    private static final SdkField<Long> REFRESH_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("RefreshSeconds").getter(ViewDefinition.getter(ViewDefinition::refreshSeconds)).setter(ViewDefinition.setter(Builder::refreshSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefreshSeconds").build()}).build();
    private static final SdkField<String> LAST_REFRESH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastRefreshType").getter(ViewDefinition.getter(ViewDefinition::lastRefreshTypeAsString)).setter(ViewDefinition.setter(Builder::lastRefreshType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastRefreshType").build()}).build();
    private static final SdkField<List<String>> SUB_OBJECTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubObjects").getter(ViewDefinition.getter(ViewDefinition::subObjects)).setter(ViewDefinition.setter(Builder::subObjects)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubObjects").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Long>> SUB_OBJECT_VERSION_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubObjectVersionIds").getter(ViewDefinition.getter(ViewDefinition::subObjectVersionIds)).setter(ViewDefinition.setter(Builder::subObjectVersionIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubObjectVersionIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LONG).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ViewRepresentation>> REPRESENTATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Representations").getter(ViewDefinition.getter(ViewDefinition::representations)).setter(ViewDefinition.setter(Builder::representations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Representations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ViewRepresentation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IS_PROTECTED_FIELD, DEFINER_FIELD, VIEW_VERSION_ID_FIELD, VIEW_VERSION_TOKEN_FIELD, REFRESH_SECONDS_FIELD, LAST_REFRESH_TYPE_FIELD, SUB_OBJECTS_FIELD, SUB_OBJECT_VERSION_IDS_FIELD, REPRESENTATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ViewDefinition.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean isProtected;
    private final String definer;
    private final Long viewVersionId;
    private final String viewVersionToken;
    private final Long refreshSeconds;
    private final String lastRefreshType;
    private final List<String> subObjects;
    private final List<Long> subObjectVersionIds;
    private final List<ViewRepresentation> representations;

    private ViewDefinition(BuilderImpl builder) {
        this.isProtected = builder.isProtected;
        this.definer = builder.definer;
        this.viewVersionId = builder.viewVersionId;
        this.viewVersionToken = builder.viewVersionToken;
        this.refreshSeconds = builder.refreshSeconds;
        this.lastRefreshType = builder.lastRefreshType;
        this.subObjects = builder.subObjects;
        this.subObjectVersionIds = builder.subObjectVersionIds;
        this.representations = builder.representations;
    }

    public final Boolean isProtected() {
        return this.isProtected;
    }

    public final String definer() {
        return this.definer;
    }

    public final Long viewVersionId() {
        return this.viewVersionId;
    }

    public final String viewVersionToken() {
        return this.viewVersionToken;
    }

    public final Long refreshSeconds() {
        return this.refreshSeconds;
    }

    public final LastRefreshType lastRefreshType() {
        return LastRefreshType.fromValue(this.lastRefreshType);
    }

    public final String lastRefreshTypeAsString() {
        return this.lastRefreshType;
    }

    public final boolean hasSubObjects() {
        return this.subObjects != null && !(this.subObjects instanceof SdkAutoConstructList);
    }

    public final List<String> subObjects() {
        return this.subObjects;
    }

    public final boolean hasSubObjectVersionIds() {
        return this.subObjectVersionIds != null && !(this.subObjectVersionIds instanceof SdkAutoConstructList);
    }

    public final List<Long> subObjectVersionIds() {
        return this.subObjectVersionIds;
    }

    public final boolean hasRepresentations() {
        return this.representations != null && !(this.representations instanceof SdkAutoConstructList);
    }

    public final List<ViewRepresentation> representations() {
        return this.representations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.isProtected());
        hashCode = 31 * hashCode + Objects.hashCode(this.definer());
        hashCode = 31 * hashCode + Objects.hashCode(this.viewVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.viewVersionToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.refreshSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastRefreshTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubObjects() ? this.subObjects() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubObjectVersionIds() ? this.subObjectVersionIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRepresentations() ? this.representations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ViewDefinition)) {
            return false;
        }
        ViewDefinition other = (ViewDefinition)obj;
        return Objects.equals(this.isProtected(), other.isProtected()) && Objects.equals(this.definer(), other.definer()) && Objects.equals(this.viewVersionId(), other.viewVersionId()) && Objects.equals(this.viewVersionToken(), other.viewVersionToken()) && Objects.equals(this.refreshSeconds(), other.refreshSeconds()) && Objects.equals(this.lastRefreshTypeAsString(), other.lastRefreshTypeAsString()) && this.hasSubObjects() == other.hasSubObjects() && Objects.equals(this.subObjects(), other.subObjects()) && this.hasSubObjectVersionIds() == other.hasSubObjectVersionIds() && Objects.equals(this.subObjectVersionIds(), other.subObjectVersionIds()) && this.hasRepresentations() == other.hasRepresentations() && Objects.equals(this.representations(), other.representations());
    }

    public final String toString() {
        return ToString.builder((String)"ViewDefinition").add("IsProtected", (Object)this.isProtected()).add("Definer", (Object)this.definer()).add("ViewVersionId", (Object)this.viewVersionId()).add("ViewVersionToken", (Object)this.viewVersionToken()).add("RefreshSeconds", (Object)this.refreshSeconds()).add("LastRefreshType", (Object)this.lastRefreshTypeAsString()).add("SubObjects", this.hasSubObjects() ? this.subObjects() : null).add("SubObjectVersionIds", this.hasSubObjectVersionIds() ? this.subObjectVersionIds() : null).add("Representations", this.hasRepresentations() ? this.representations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IsProtected": {
                return Optional.ofNullable(clazz.cast(this.isProtected()));
            }
            case "Definer": {
                return Optional.ofNullable(clazz.cast(this.definer()));
            }
            case "ViewVersionId": {
                return Optional.ofNullable(clazz.cast(this.viewVersionId()));
            }
            case "ViewVersionToken": {
                return Optional.ofNullable(clazz.cast(this.viewVersionToken()));
            }
            case "RefreshSeconds": {
                return Optional.ofNullable(clazz.cast(this.refreshSeconds()));
            }
            case "LastRefreshType": {
                return Optional.ofNullable(clazz.cast(this.lastRefreshTypeAsString()));
            }
            case "SubObjects": {
                return Optional.ofNullable(clazz.cast(this.subObjects()));
            }
            case "SubObjectVersionIds": {
                return Optional.ofNullable(clazz.cast(this.subObjectVersionIds()));
            }
            case "Representations": {
                return Optional.ofNullable(clazz.cast(this.representations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("IsProtected", IS_PROTECTED_FIELD);
        map.put("Definer", DEFINER_FIELD);
        map.put("ViewVersionId", VIEW_VERSION_ID_FIELD);
        map.put("ViewVersionToken", VIEW_VERSION_TOKEN_FIELD);
        map.put("RefreshSeconds", REFRESH_SECONDS_FIELD);
        map.put("LastRefreshType", LAST_REFRESH_TYPE_FIELD);
        map.put("SubObjects", SUB_OBJECTS_FIELD);
        map.put("SubObjectVersionIds", SUB_OBJECT_VERSION_IDS_FIELD);
        map.put("Representations", REPRESENTATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ViewDefinition, T> g) {
        return obj -> g.apply((ViewDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean isProtected;
        private String definer;
        private Long viewVersionId;
        private String viewVersionToken;
        private Long refreshSeconds;
        private String lastRefreshType;
        private List<String> subObjects = DefaultSdkAutoConstructList.getInstance();
        private List<Long> subObjectVersionIds = DefaultSdkAutoConstructList.getInstance();
        private List<ViewRepresentation> representations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ViewDefinition model) {
            this.isProtected(model.isProtected);
            this.definer(model.definer);
            this.viewVersionId(model.viewVersionId);
            this.viewVersionToken(model.viewVersionToken);
            this.refreshSeconds(model.refreshSeconds);
            this.lastRefreshType(model.lastRefreshType);
            this.subObjects(model.subObjects);
            this.subObjectVersionIds(model.subObjectVersionIds);
            this.representations(model.representations);
        }

        public final Boolean getIsProtected() {
            return this.isProtected;
        }

        public final void setIsProtected(Boolean isProtected) {
            this.isProtected = isProtected;
        }

        @Override
        public final Builder isProtected(Boolean isProtected) {
            this.isProtected = isProtected;
            return this;
        }

        public final String getDefiner() {
            return this.definer;
        }

        public final void setDefiner(String definer) {
            this.definer = definer;
        }

        @Override
        public final Builder definer(String definer) {
            this.definer = definer;
            return this;
        }

        public final Long getViewVersionId() {
            return this.viewVersionId;
        }

        public final void setViewVersionId(Long viewVersionId) {
            this.viewVersionId = viewVersionId;
        }

        @Override
        public final Builder viewVersionId(Long viewVersionId) {
            this.viewVersionId = viewVersionId;
            return this;
        }

        public final String getViewVersionToken() {
            return this.viewVersionToken;
        }

        public final void setViewVersionToken(String viewVersionToken) {
            this.viewVersionToken = viewVersionToken;
        }

        @Override
        public final Builder viewVersionToken(String viewVersionToken) {
            this.viewVersionToken = viewVersionToken;
            return this;
        }

        public final Long getRefreshSeconds() {
            return this.refreshSeconds;
        }

        public final void setRefreshSeconds(Long refreshSeconds) {
            this.refreshSeconds = refreshSeconds;
        }

        @Override
        public final Builder refreshSeconds(Long refreshSeconds) {
            this.refreshSeconds = refreshSeconds;
            return this;
        }

        public final String getLastRefreshType() {
            return this.lastRefreshType;
        }

        public final void setLastRefreshType(String lastRefreshType) {
            this.lastRefreshType = lastRefreshType;
        }

        @Override
        public final Builder lastRefreshType(String lastRefreshType) {
            this.lastRefreshType = lastRefreshType;
            return this;
        }

        @Override
        public final Builder lastRefreshType(LastRefreshType lastRefreshType) {
            this.lastRefreshType(lastRefreshType == null ? null : lastRefreshType.toString());
            return this;
        }

        public final Collection<String> getSubObjects() {
            if (this.subObjects instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subObjects;
        }

        public final void setSubObjects(Collection<String> subObjects) {
            this.subObjects = ViewSubObjectsListCopier.copy(subObjects);
        }

        @Override
        public final Builder subObjects(Collection<String> subObjects) {
            this.subObjects = ViewSubObjectsListCopier.copy(subObjects);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subObjects(String ... subObjects) {
            this.subObjects(Arrays.asList(subObjects));
            return this;
        }

        public final Collection<Long> getSubObjectVersionIds() {
            if (this.subObjectVersionIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subObjectVersionIds;
        }

        public final void setSubObjectVersionIds(Collection<Long> subObjectVersionIds) {
            this.subObjectVersionIds = ViewSubObjectVersionIdsListCopier.copy(subObjectVersionIds);
        }

        @Override
        public final Builder subObjectVersionIds(Collection<Long> subObjectVersionIds) {
            this.subObjectVersionIds = ViewSubObjectVersionIdsListCopier.copy(subObjectVersionIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subObjectVersionIds(Long ... subObjectVersionIds) {
            this.subObjectVersionIds(Arrays.asList(subObjectVersionIds));
            return this;
        }

        public final List<ViewRepresentation.Builder> getRepresentations() {
            List<ViewRepresentation.Builder> result = ViewRepresentationListCopier.copyToBuilder(this.representations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRepresentations(Collection<ViewRepresentation.BuilderImpl> representations) {
            this.representations = ViewRepresentationListCopier.copyFromBuilder(representations);
        }

        @Override
        public final Builder representations(Collection<ViewRepresentation> representations) {
            this.representations = ViewRepresentationListCopier.copy(representations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder representations(ViewRepresentation ... representations) {
            this.representations(Arrays.asList(representations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder representations(Consumer<ViewRepresentation.Builder> ... representations) {
            this.representations(Stream.of(representations).map(c -> (ViewRepresentation)((ViewRepresentation.Builder)ViewRepresentation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ViewDefinition build() {
            return new ViewDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ViewDefinition> {
        public Builder isProtected(Boolean var1);

        public Builder definer(String var1);

        public Builder viewVersionId(Long var1);

        public Builder viewVersionToken(String var1);

        public Builder refreshSeconds(Long var1);

        public Builder lastRefreshType(String var1);

        public Builder lastRefreshType(LastRefreshType var1);

        public Builder subObjects(Collection<String> var1);

        public Builder subObjects(String ... var1);

        public Builder subObjectVersionIds(Collection<Long> var1);

        public Builder subObjectVersionIds(Long ... var1);

        public Builder representations(Collection<ViewRepresentation> var1);

        public Builder representations(ViewRepresentation ... var1);

        public Builder representations(Consumer<ViewRepresentation.Builder> ... var1);
    }
}

