/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.IcebergTableUpdate;
import software.amazon.awssdk.services.glue.model.IcebergTableUpdateListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateIcebergTableInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UpdateIcebergTableInput> {
    private static final SdkField<List<IcebergTableUpdate>> UPDATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Updates").getter(UpdateIcebergTableInput.getter(UpdateIcebergTableInput::updates)).setter(UpdateIcebergTableInput.setter(Builder::updates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Updates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IcebergTableUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UPDATES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateIcebergTableInput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<IcebergTableUpdate> updates;

    private UpdateIcebergTableInput(BuilderImpl builder) {
        this.updates = builder.updates;
    }

    public final boolean hasUpdates() {
        return this.updates != null && !(this.updates instanceof SdkAutoConstructList);
    }

    public final List<IcebergTableUpdate> updates() {
        return this.updates;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUpdates() ? this.updates() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateIcebergTableInput)) {
            return false;
        }
        UpdateIcebergTableInput other = (UpdateIcebergTableInput)obj;
        return this.hasUpdates() == other.hasUpdates() && Objects.equals(this.updates(), other.updates());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateIcebergTableInput").add("Updates", this.hasUpdates() ? this.updates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Updates": {
                return Optional.ofNullable(clazz.cast(this.updates()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<IcebergTableUpdate>>> map = new HashMap<String, SdkField<List<IcebergTableUpdate>>>();
        map.put("Updates", UPDATES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateIcebergTableInput, T> g) {
        return obj -> g.apply((UpdateIcebergTableInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<IcebergTableUpdate> updates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateIcebergTableInput model) {
            this.updates(model.updates);
        }

        public final List<IcebergTableUpdate.Builder> getUpdates() {
            List<IcebergTableUpdate.Builder> result = IcebergTableUpdateListCopier.copyToBuilder(this.updates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUpdates(Collection<IcebergTableUpdate.BuilderImpl> updates) {
            this.updates = IcebergTableUpdateListCopier.copyFromBuilder(updates);
        }

        @Override
        public final Builder updates(Collection<IcebergTableUpdate> updates) {
            this.updates = IcebergTableUpdateListCopier.copy(updates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updates(IcebergTableUpdate ... updates) {
            this.updates(Arrays.asList(updates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updates(Consumer<IcebergTableUpdate.Builder> ... updates) {
            this.updates(Stream.of(updates).map(c -> (IcebergTableUpdate)((IcebergTableUpdate.Builder)IcebergTableUpdate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public UpdateIcebergTableInput build() {
            return new UpdateIcebergTableInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UpdateIcebergTableInput> {
        public Builder updates(Collection<IcebergTableUpdate> var1);

        public Builder updates(IcebergTableUpdate ... var1);

        public Builder updates(Consumer<IcebergTableUpdate.Builder> ... var1);
    }
}

