/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.IcebergNullOrder;
import software.amazon.awssdk.services.glue.model.IcebergSortDirection;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IcebergSortField
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IcebergSortField> {
    private static final SdkField<Integer> SOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SourceId").getter(IcebergSortField.getter(IcebergSortField::sourceId)).setter(IcebergSortField.setter(Builder::sourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceId").build()}).build();
    private static final SdkField<String> TRANSFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Transform").getter(IcebergSortField.getter(IcebergSortField::transform)).setter(IcebergSortField.setter(Builder::transform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Transform").build()}).build();
    private static final SdkField<String> DIRECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Direction").getter(IcebergSortField.getter(IcebergSortField::directionAsString)).setter(IcebergSortField.setter(Builder::direction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Direction").build()}).build();
    private static final SdkField<String> NULL_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NullOrder").getter(IcebergSortField.getter(IcebergSortField::nullOrderAsString)).setter(IcebergSortField.setter(Builder::nullOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NullOrder").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_ID_FIELD, TRANSFORM_FIELD, DIRECTION_FIELD, NULL_ORDER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IcebergSortField.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer sourceId;
    private final String transform;
    private final String direction;
    private final String nullOrder;

    private IcebergSortField(BuilderImpl builder) {
        this.sourceId = builder.sourceId;
        this.transform = builder.transform;
        this.direction = builder.direction;
        this.nullOrder = builder.nullOrder;
    }

    public final Integer sourceId() {
        return this.sourceId;
    }

    public final String transform() {
        return this.transform;
    }

    public final IcebergSortDirection direction() {
        return IcebergSortDirection.fromValue(this.direction);
    }

    public final String directionAsString() {
        return this.direction;
    }

    public final IcebergNullOrder nullOrder() {
        return IcebergNullOrder.fromValue(this.nullOrder);
    }

    public final String nullOrderAsString() {
        return this.nullOrder;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.transform());
        hashCode = 31 * hashCode + Objects.hashCode(this.directionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nullOrderAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IcebergSortField)) {
            return false;
        }
        IcebergSortField other = (IcebergSortField)obj;
        return Objects.equals(this.sourceId(), other.sourceId()) && Objects.equals(this.transform(), other.transform()) && Objects.equals(this.directionAsString(), other.directionAsString()) && Objects.equals(this.nullOrderAsString(), other.nullOrderAsString());
    }

    public final String toString() {
        return ToString.builder((String)"IcebergSortField").add("SourceId", (Object)this.sourceId()).add("Transform", (Object)this.transform()).add("Direction", (Object)this.directionAsString()).add("NullOrder", (Object)this.nullOrderAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceId": {
                return Optional.ofNullable(clazz.cast(this.sourceId()));
            }
            case "Transform": {
                return Optional.ofNullable(clazz.cast(this.transform()));
            }
            case "Direction": {
                return Optional.ofNullable(clazz.cast(this.directionAsString()));
            }
            case "NullOrder": {
                return Optional.ofNullable(clazz.cast(this.nullOrderAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SourceId", SOURCE_ID_FIELD);
        map.put("Transform", TRANSFORM_FIELD);
        map.put("Direction", DIRECTION_FIELD);
        map.put("NullOrder", NULL_ORDER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IcebergSortField, T> g) {
        return obj -> g.apply((IcebergSortField)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer sourceId;
        private String transform;
        private String direction;
        private String nullOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(IcebergSortField model) {
            this.sourceId(model.sourceId);
            this.transform(model.transform);
            this.direction(model.direction);
            this.nullOrder(model.nullOrder);
        }

        public final Integer getSourceId() {
            return this.sourceId;
        }

        public final void setSourceId(Integer sourceId) {
            this.sourceId = sourceId;
        }

        @Override
        public final Builder sourceId(Integer sourceId) {
            this.sourceId = sourceId;
            return this;
        }

        public final String getTransform() {
            return this.transform;
        }

        public final void setTransform(String transform) {
            this.transform = transform;
        }

        @Override
        public final Builder transform(String transform) {
            this.transform = transform;
            return this;
        }

        public final String getDirection() {
            return this.direction;
        }

        public final void setDirection(String direction) {
            this.direction = direction;
        }

        @Override
        public final Builder direction(String direction) {
            this.direction = direction;
            return this;
        }

        @Override
        public final Builder direction(IcebergSortDirection direction) {
            this.direction(direction == null ? null : direction.toString());
            return this;
        }

        public final String getNullOrder() {
            return this.nullOrder;
        }

        public final void setNullOrder(String nullOrder) {
            this.nullOrder = nullOrder;
        }

        @Override
        public final Builder nullOrder(String nullOrder) {
            this.nullOrder = nullOrder;
            return this;
        }

        @Override
        public final Builder nullOrder(IcebergNullOrder nullOrder) {
            this.nullOrder(nullOrder == null ? null : nullOrder.toString());
            return this;
        }

        public IcebergSortField build() {
            return new IcebergSortField(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IcebergSortField> {
        public Builder sourceId(Integer var1);

        public Builder transform(String var1);

        public Builder direction(String var1);

        public Builder direction(IcebergSortDirection var1);

        public Builder nullOrder(String var1);

        public Builder nullOrder(IcebergNullOrder var1);
    }
}

