/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.KafkaStreamingSourceOptions;
import software.amazon.awssdk.services.glue.model.StreamingDataPreviewOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DirectKafkaSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DirectKafkaSource> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DirectKafkaSource.getter(DirectKafkaSource::name)).setter(DirectKafkaSource.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<KafkaStreamingSourceOptions> STREAMING_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StreamingOptions").getter(DirectKafkaSource.getter(DirectKafkaSource::streamingOptions)).setter(DirectKafkaSource.setter(Builder::streamingOptions)).constructor(KafkaStreamingSourceOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamingOptions").build()}).build();
    private static final SdkField<Integer> WINDOW_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("WindowSize").getter(DirectKafkaSource.getter(DirectKafkaSource::windowSize)).setter(DirectKafkaSource.setter(Builder::windowSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowSize").build()}).build();
    private static final SdkField<Boolean> DETECT_SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DetectSchema").getter(DirectKafkaSource.getter(DirectKafkaSource::detectSchema)).setter(DirectKafkaSource.setter(Builder::detectSchema)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetectSchema").build()}).build();
    private static final SdkField<StreamingDataPreviewOptions> DATA_PREVIEW_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataPreviewOptions").getter(DirectKafkaSource.getter(DirectKafkaSource::dataPreviewOptions)).setter(DirectKafkaSource.setter(Builder::dataPreviewOptions)).constructor(StreamingDataPreviewOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataPreviewOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, STREAMING_OPTIONS_FIELD, WINDOW_SIZE_FIELD, DETECT_SCHEMA_FIELD, DATA_PREVIEW_OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DirectKafkaSource.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final KafkaStreamingSourceOptions streamingOptions;
    private final Integer windowSize;
    private final Boolean detectSchema;
    private final StreamingDataPreviewOptions dataPreviewOptions;

    private DirectKafkaSource(BuilderImpl builder) {
        this.name = builder.name;
        this.streamingOptions = builder.streamingOptions;
        this.windowSize = builder.windowSize;
        this.detectSchema = builder.detectSchema;
        this.dataPreviewOptions = builder.dataPreviewOptions;
    }

    public final String name() {
        return this.name;
    }

    public final KafkaStreamingSourceOptions streamingOptions() {
        return this.streamingOptions;
    }

    public final Integer windowSize() {
        return this.windowSize;
    }

    public final Boolean detectSchema() {
        return this.detectSchema;
    }

    public final StreamingDataPreviewOptions dataPreviewOptions() {
        return this.dataPreviewOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamingOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.windowSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.detectSchema());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataPreviewOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DirectKafkaSource)) {
            return false;
        }
        DirectKafkaSource other = (DirectKafkaSource)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.streamingOptions(), other.streamingOptions()) && Objects.equals(this.windowSize(), other.windowSize()) && Objects.equals(this.detectSchema(), other.detectSchema()) && Objects.equals(this.dataPreviewOptions(), other.dataPreviewOptions());
    }

    public final String toString() {
        return ToString.builder((String)"DirectKafkaSource").add("Name", (Object)this.name()).add("StreamingOptions", (Object)this.streamingOptions()).add("WindowSize", (Object)this.windowSize()).add("DetectSchema", (Object)this.detectSchema()).add("DataPreviewOptions", (Object)this.dataPreviewOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "StreamingOptions": {
                return Optional.ofNullable(clazz.cast(this.streamingOptions()));
            }
            case "WindowSize": {
                return Optional.ofNullable(clazz.cast(this.windowSize()));
            }
            case "DetectSchema": {
                return Optional.ofNullable(clazz.cast(this.detectSchema()));
            }
            case "DataPreviewOptions": {
                return Optional.ofNullable(clazz.cast(this.dataPreviewOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("StreamingOptions", STREAMING_OPTIONS_FIELD);
        map.put("WindowSize", WINDOW_SIZE_FIELD);
        map.put("DetectSchema", DETECT_SCHEMA_FIELD);
        map.put("DataPreviewOptions", DATA_PREVIEW_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DirectKafkaSource, T> g) {
        return obj -> g.apply((DirectKafkaSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private KafkaStreamingSourceOptions streamingOptions;
        private Integer windowSize;
        private Boolean detectSchema;
        private StreamingDataPreviewOptions dataPreviewOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(DirectKafkaSource model) {
            this.name(model.name);
            this.streamingOptions(model.streamingOptions);
            this.windowSize(model.windowSize);
            this.detectSchema(model.detectSchema);
            this.dataPreviewOptions(model.dataPreviewOptions);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final KafkaStreamingSourceOptions.Builder getStreamingOptions() {
            return this.streamingOptions != null ? this.streamingOptions.toBuilder() : null;
        }

        public final void setStreamingOptions(KafkaStreamingSourceOptions.BuilderImpl streamingOptions) {
            this.streamingOptions = streamingOptions != null ? streamingOptions.build() : null;
        }

        @Override
        public final Builder streamingOptions(KafkaStreamingSourceOptions streamingOptions) {
            this.streamingOptions = streamingOptions;
            return this;
        }

        public final Integer getWindowSize() {
            return this.windowSize;
        }

        public final void setWindowSize(Integer windowSize) {
            this.windowSize = windowSize;
        }

        @Override
        public final Builder windowSize(Integer windowSize) {
            this.windowSize = windowSize;
            return this;
        }

        public final Boolean getDetectSchema() {
            return this.detectSchema;
        }

        public final void setDetectSchema(Boolean detectSchema) {
            this.detectSchema = detectSchema;
        }

        @Override
        public final Builder detectSchema(Boolean detectSchema) {
            this.detectSchema = detectSchema;
            return this;
        }

        public final StreamingDataPreviewOptions.Builder getDataPreviewOptions() {
            return this.dataPreviewOptions != null ? this.dataPreviewOptions.toBuilder() : null;
        }

        public final void setDataPreviewOptions(StreamingDataPreviewOptions.BuilderImpl dataPreviewOptions) {
            this.dataPreviewOptions = dataPreviewOptions != null ? dataPreviewOptions.build() : null;
        }

        @Override
        public final Builder dataPreviewOptions(StreamingDataPreviewOptions dataPreviewOptions) {
            this.dataPreviewOptions = dataPreviewOptions;
            return this;
        }

        public DirectKafkaSource build() {
            return new DirectKafkaSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DirectKafkaSource> {
        public Builder name(String var1);

        public Builder streamingOptions(KafkaStreamingSourceOptions var1);

        default public Builder streamingOptions(Consumer<KafkaStreamingSourceOptions.Builder> streamingOptions) {
            return this.streamingOptions((KafkaStreamingSourceOptions)((KafkaStreamingSourceOptions.Builder)KafkaStreamingSourceOptions.builder().applyMutation(streamingOptions)).build());
        }

        public Builder windowSize(Integer var1);

        public Builder detectSchema(Boolean var1);

        public Builder dataPreviewOptions(StreamingDataPreviewOptions var1);

        default public Builder dataPreviewOptions(Consumer<StreamingDataPreviewOptions.Builder> dataPreviewOptions) {
            return this.dataPreviewOptions((StreamingDataPreviewOptions)((StreamingDataPreviewOptions.Builder)StreamingDataPreviewOptions.builder().applyMutation(dataPreviewOptions)).build());
        }
    }
}

