/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.services.glue.model.IntegrationTagsListCopier;
import software.amazon.awssdk.services.glue.model.SourceProcessingProperties;
import software.amazon.awssdk.services.glue.model.Tag;
import software.amazon.awssdk.services.glue.model.TargetProcessingProperties;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateIntegrationResourcePropertyRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, CreateIntegrationResourcePropertyRequest> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(CreateIntegrationResourcePropertyRequest.getter(CreateIntegrationResourcePropertyRequest::resourceArn)).setter(CreateIntegrationResourcePropertyRequest.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final SdkField<SourceProcessingProperties> SOURCE_PROCESSING_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceProcessingProperties").getter(CreateIntegrationResourcePropertyRequest.getter(CreateIntegrationResourcePropertyRequest::sourceProcessingProperties)).setter(CreateIntegrationResourcePropertyRequest.setter(Builder::sourceProcessingProperties)).constructor(SourceProcessingProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceProcessingProperties").build()}).build();
    private static final SdkField<TargetProcessingProperties> TARGET_PROCESSING_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TargetProcessingProperties").getter(CreateIntegrationResourcePropertyRequest.getter(CreateIntegrationResourcePropertyRequest::targetProcessingProperties)).setter(CreateIntegrationResourcePropertyRequest.setter(Builder::targetProcessingProperties)).constructor(TargetProcessingProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetProcessingProperties").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateIntegrationResourcePropertyRequest.getter(CreateIntegrationResourcePropertyRequest::tags)).setter(CreateIntegrationResourcePropertyRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD, SOURCE_PROCESSING_PROPERTIES_FIELD, TARGET_PROCESSING_PROPERTIES_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateIntegrationResourcePropertyRequest.memberNameToFieldInitializer();
    private final String resourceArn;
    private final SourceProcessingProperties sourceProcessingProperties;
    private final TargetProcessingProperties targetProcessingProperties;
    private final List<Tag> tags;

    private CreateIntegrationResourcePropertyRequest(BuilderImpl builder) {
        super(builder);
        this.resourceArn = builder.resourceArn;
        this.sourceProcessingProperties = builder.sourceProcessingProperties;
        this.targetProcessingProperties = builder.targetProcessingProperties;
        this.tags = builder.tags;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final SourceProcessingProperties sourceProcessingProperties() {
        return this.sourceProcessingProperties;
    }

    public final TargetProcessingProperties targetProcessingProperties() {
        return this.targetProcessingProperties;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceProcessingProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetProcessingProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIntegrationResourcePropertyRequest)) {
            return false;
        }
        CreateIntegrationResourcePropertyRequest other = (CreateIntegrationResourcePropertyRequest)((Object)obj);
        return Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.sourceProcessingProperties(), other.sourceProcessingProperties()) && Objects.equals(this.targetProcessingProperties(), other.targetProcessingProperties()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateIntegrationResourcePropertyRequest").add("ResourceArn", (Object)this.resourceArn()).add("SourceProcessingProperties", (Object)this.sourceProcessingProperties()).add("TargetProcessingProperties", (Object)this.targetProcessingProperties()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "SourceProcessingProperties": {
                return Optional.ofNullable(clazz.cast(this.sourceProcessingProperties()));
            }
            case "TargetProcessingProperties": {
                return Optional.ofNullable(clazz.cast(this.targetProcessingProperties()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ResourceArn", RESOURCE_ARN_FIELD);
        map.put("SourceProcessingProperties", SOURCE_PROCESSING_PROPERTIES_FIELD);
        map.put("TargetProcessingProperties", TARGET_PROCESSING_PROPERTIES_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateIntegrationResourcePropertyRequest, T> g) {
        return obj -> g.apply((CreateIntegrationResourcePropertyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String resourceArn;
        private SourceProcessingProperties sourceProcessingProperties;
        private TargetProcessingProperties targetProcessingProperties;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIntegrationResourcePropertyRequest model) {
            super(model);
            this.resourceArn(model.resourceArn);
            this.sourceProcessingProperties(model.sourceProcessingProperties);
            this.targetProcessingProperties(model.targetProcessingProperties);
            this.tags(model.tags);
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final SourceProcessingProperties.Builder getSourceProcessingProperties() {
            return this.sourceProcessingProperties != null ? this.sourceProcessingProperties.toBuilder() : null;
        }

        public final void setSourceProcessingProperties(SourceProcessingProperties.BuilderImpl sourceProcessingProperties) {
            this.sourceProcessingProperties = sourceProcessingProperties != null ? sourceProcessingProperties.build() : null;
        }

        @Override
        public final Builder sourceProcessingProperties(SourceProcessingProperties sourceProcessingProperties) {
            this.sourceProcessingProperties = sourceProcessingProperties;
            return this;
        }

        public final TargetProcessingProperties.Builder getTargetProcessingProperties() {
            return this.targetProcessingProperties != null ? this.targetProcessingProperties.toBuilder() : null;
        }

        public final void setTargetProcessingProperties(TargetProcessingProperties.BuilderImpl targetProcessingProperties) {
            this.targetProcessingProperties = targetProcessingProperties != null ? targetProcessingProperties.build() : null;
        }

        @Override
        public final Builder targetProcessingProperties(TargetProcessingProperties targetProcessingProperties) {
            this.targetProcessingProperties = targetProcessingProperties;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = IntegrationTagsListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = IntegrationTagsListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = IntegrationTagsListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateIntegrationResourcePropertyRequest build() {
            return new CreateIntegrationResourcePropertyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateIntegrationResourcePropertyRequest> {
        public Builder resourceArn(String var1);

        public Builder sourceProcessingProperties(SourceProcessingProperties var1);

        default public Builder sourceProcessingProperties(Consumer<SourceProcessingProperties.Builder> sourceProcessingProperties) {
            return this.sourceProcessingProperties((SourceProcessingProperties)((SourceProcessingProperties.Builder)SourceProcessingProperties.builder().applyMutation(sourceProcessingProperties)).build());
        }

        public Builder targetProcessingProperties(TargetProcessingProperties var1);

        default public Builder targetProcessingProperties(Consumer<TargetProcessingProperties.Builder> targetProcessingProperties) {
            return this.targetProcessingProperties((TargetProcessingProperties)((TargetProcessingProperties.Builder)TargetProcessingProperties.builder().applyMutation(targetProcessingProperties)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

