/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TargetFormat {
    JSON("json"),
    CSV("csv"),
    AVRO("avro"),
    ORC("orc"),
    PARQUET("parquet"),
    HUDI("hudi"),
    DELTA("delta"),
    ICEBERG("iceberg"),
    HYPER("hyper"),
    XML("xml"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TargetFormat> VALUE_MAP;
    private final String value;

    private TargetFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TargetFormat fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TargetFormat> knownValues() {
        EnumSet<TargetFormat> knownValues = EnumSet.allOf(TargetFormat.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TargetFormat.class, TargetFormat::toString);
    }
}

