/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.MetricBasedObservation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataQualityObservation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataQualityObservation> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(DataQualityObservation.getter(DataQualityObservation::description)).setter(DataQualityObservation.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<MetricBasedObservation> METRIC_BASED_OBSERVATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MetricBasedObservation").getter(DataQualityObservation.getter(DataQualityObservation::metricBasedObservation)).setter(DataQualityObservation.setter(Builder::metricBasedObservation)).constructor(MetricBasedObservation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricBasedObservation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, METRIC_BASED_OBSERVATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataQualityObservation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String description;
    private final MetricBasedObservation metricBasedObservation;

    private DataQualityObservation(BuilderImpl builder) {
        this.description = builder.description;
        this.metricBasedObservation = builder.metricBasedObservation;
    }

    public final String description() {
        return this.description;
    }

    public final MetricBasedObservation metricBasedObservation() {
        return this.metricBasedObservation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricBasedObservation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataQualityObservation)) {
            return false;
        }
        DataQualityObservation other = (DataQualityObservation)obj;
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.metricBasedObservation(), other.metricBasedObservation());
    }

    public final String toString() {
        return ToString.builder((String)"DataQualityObservation").add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("MetricBasedObservation", (Object)this.metricBasedObservation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "MetricBasedObservation": {
                return Optional.ofNullable(clazz.cast(this.metricBasedObservation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Description", DESCRIPTION_FIELD);
        map.put("MetricBasedObservation", METRIC_BASED_OBSERVATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataQualityObservation, T> g) {
        return obj -> g.apply((DataQualityObservation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private MetricBasedObservation metricBasedObservation;

        private BuilderImpl() {
        }

        private BuilderImpl(DataQualityObservation model) {
            this.description(model.description);
            this.metricBasedObservation(model.metricBasedObservation);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final MetricBasedObservation.Builder getMetricBasedObservation() {
            return this.metricBasedObservation != null ? this.metricBasedObservation.toBuilder() : null;
        }

        public final void setMetricBasedObservation(MetricBasedObservation.BuilderImpl metricBasedObservation) {
            this.metricBasedObservation = metricBasedObservation != null ? metricBasedObservation.build() : null;
        }

        @Override
        public final Builder metricBasedObservation(MetricBasedObservation metricBasedObservation) {
            this.metricBasedObservation = metricBasedObservation;
            return this;
        }

        public DataQualityObservation build() {
            return new DataQualityObservation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataQualityObservation> {
        public Builder description(String var1);

        public Builder metricBasedObservation(MetricBasedObservation var1);

        default public Builder metricBasedObservation(Consumer<MetricBasedObservation.Builder> metricBasedObservation) {
            return this.metricBasedObservation((MetricBasedObservation)((MetricBasedObservation.Builder)MetricBasedObservation.builder().applyMutation(metricBasedObservation)).build());
        }
    }
}

