/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.AllowedValue;
import software.amazon.awssdk.services.glue.model.AllowedValuesCopier;
import software.amazon.awssdk.services.glue.model.DataOperation;
import software.amazon.awssdk.services.glue.model.DataOperationsCopier;
import software.amazon.awssdk.services.glue.model.PropertyType;
import software.amazon.awssdk.services.glue.model.PropertyTypesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Property
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Property> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Property.getter(Property::name)).setter(Property.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(Property.getter(Property::description)).setter(Property.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Boolean> REQUIRED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Required").getter(Property.getter(Property::required)).setter(Property.setter(Builder::required)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Required").build()}).build();
    private static final SdkField<String> DEFAULT_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultValue").getter(Property.getter(Property::defaultValue)).setter(Property.setter(Builder::defaultValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultValue").build()}).build();
    private static final SdkField<List<String>> PROPERTY_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PropertyTypes").getter(Property.getter(Property::propertyTypesAsStrings)).setter(Property.setter(Builder::propertyTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PropertyTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AllowedValue>> ALLOWED_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AllowedValues").getter(Property.getter(Property::allowedValues)).setter(Property.setter(Builder::allowedValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AllowedValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> DATA_OPERATION_SCOPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DataOperationScopes").getter(Property.getter(Property::dataOperationScopesAsStrings)).setter(Property.setter(Builder::dataOperationScopesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataOperationScopes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, REQUIRED_FIELD, DEFAULT_VALUE_FIELD, PROPERTY_TYPES_FIELD, ALLOWED_VALUES_FIELD, DATA_OPERATION_SCOPES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Property.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String description;
    private final Boolean required;
    private final String defaultValue;
    private final List<String> propertyTypes;
    private final List<AllowedValue> allowedValues;
    private final List<String> dataOperationScopes;

    private Property(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.required = builder.required;
        this.defaultValue = builder.defaultValue;
        this.propertyTypes = builder.propertyTypes;
        this.allowedValues = builder.allowedValues;
        this.dataOperationScopes = builder.dataOperationScopes;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final Boolean required() {
        return this.required;
    }

    public final String defaultValue() {
        return this.defaultValue;
    }

    public final List<PropertyType> propertyTypes() {
        return PropertyTypesCopier.copyStringToEnum(this.propertyTypes);
    }

    public final boolean hasPropertyTypes() {
        return this.propertyTypes != null && !(this.propertyTypes instanceof SdkAutoConstructList);
    }

    public final List<String> propertyTypesAsStrings() {
        return this.propertyTypes;
    }

    public final boolean hasAllowedValues() {
        return this.allowedValues != null && !(this.allowedValues instanceof SdkAutoConstructList);
    }

    public final List<AllowedValue> allowedValues() {
        return this.allowedValues;
    }

    public final List<DataOperation> dataOperationScopes() {
        return DataOperationsCopier.copyStringToEnum(this.dataOperationScopes);
    }

    public final boolean hasDataOperationScopes() {
        return this.dataOperationScopes != null && !(this.dataOperationScopes instanceof SdkAutoConstructList);
    }

    public final List<String> dataOperationScopesAsStrings() {
        return this.dataOperationScopes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.required());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPropertyTypes() ? this.propertyTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedValues() ? this.allowedValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataOperationScopes() ? this.dataOperationScopesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Property)) {
            return false;
        }
        Property other = (Property)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.required(), other.required()) && Objects.equals(this.defaultValue(), other.defaultValue()) && this.hasPropertyTypes() == other.hasPropertyTypes() && Objects.equals(this.propertyTypesAsStrings(), other.propertyTypesAsStrings()) && this.hasAllowedValues() == other.hasAllowedValues() && Objects.equals(this.allowedValues(), other.allowedValues()) && this.hasDataOperationScopes() == other.hasDataOperationScopes() && Objects.equals(this.dataOperationScopesAsStrings(), other.dataOperationScopesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"Property").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Required", (Object)this.required()).add("DefaultValue", (Object)this.defaultValue()).add("PropertyTypes", this.hasPropertyTypes() ? this.propertyTypesAsStrings() : null).add("AllowedValues", this.hasAllowedValues() ? this.allowedValues() : null).add("DataOperationScopes", this.hasDataOperationScopes() ? this.dataOperationScopesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Required": {
                return Optional.ofNullable(clazz.cast(this.required()));
            }
            case "DefaultValue": {
                return Optional.ofNullable(clazz.cast(this.defaultValue()));
            }
            case "PropertyTypes": {
                return Optional.ofNullable(clazz.cast(this.propertyTypesAsStrings()));
            }
            case "AllowedValues": {
                return Optional.ofNullable(clazz.cast(this.allowedValues()));
            }
            case "DataOperationScopes": {
                return Optional.ofNullable(clazz.cast(this.dataOperationScopesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Required", REQUIRED_FIELD);
        map.put("DefaultValue", DEFAULT_VALUE_FIELD);
        map.put("PropertyTypes", PROPERTY_TYPES_FIELD);
        map.put("AllowedValues", ALLOWED_VALUES_FIELD);
        map.put("DataOperationScopes", DATA_OPERATION_SCOPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Property, T> g) {
        return obj -> g.apply((Property)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private Boolean required;
        private String defaultValue;
        private List<String> propertyTypes = DefaultSdkAutoConstructList.getInstance();
        private List<AllowedValue> allowedValues = DefaultSdkAutoConstructList.getInstance();
        private List<String> dataOperationScopes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Property model) {
            this.name(model.name);
            this.description(model.description);
            this.required(model.required);
            this.defaultValue(model.defaultValue);
            this.propertyTypesWithStrings(model.propertyTypes);
            this.allowedValues(model.allowedValues);
            this.dataOperationScopesWithStrings(model.dataOperationScopes);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getRequired() {
            return this.required;
        }

        public final void setRequired(Boolean required) {
            this.required = required;
        }

        @Override
        public final Builder required(Boolean required) {
            this.required = required;
            return this;
        }

        public final String getDefaultValue() {
            return this.defaultValue;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final Collection<String> getPropertyTypes() {
            if (this.propertyTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.propertyTypes;
        }

        public final void setPropertyTypes(Collection<String> propertyTypes) {
            this.propertyTypes = PropertyTypesCopier.copy(propertyTypes);
        }

        @Override
        public final Builder propertyTypesWithStrings(Collection<String> propertyTypes) {
            this.propertyTypes = PropertyTypesCopier.copy(propertyTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propertyTypesWithStrings(String ... propertyTypes) {
            this.propertyTypesWithStrings(Arrays.asList(propertyTypes));
            return this;
        }

        @Override
        public final Builder propertyTypes(Collection<PropertyType> propertyTypes) {
            this.propertyTypes = PropertyTypesCopier.copyEnumToString(propertyTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propertyTypes(PropertyType ... propertyTypes) {
            this.propertyTypes(Arrays.asList(propertyTypes));
            return this;
        }

        public final List<AllowedValue.Builder> getAllowedValues() {
            List<AllowedValue.Builder> result = AllowedValuesCopier.copyToBuilder(this.allowedValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAllowedValues(Collection<AllowedValue.BuilderImpl> allowedValues) {
            this.allowedValues = AllowedValuesCopier.copyFromBuilder(allowedValues);
        }

        @Override
        public final Builder allowedValues(Collection<AllowedValue> allowedValues) {
            this.allowedValues = AllowedValuesCopier.copy(allowedValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedValues(AllowedValue ... allowedValues) {
            this.allowedValues(Arrays.asList(allowedValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedValues(Consumer<AllowedValue.Builder> ... allowedValues) {
            this.allowedValues(Stream.of(allowedValues).map(c -> (AllowedValue)((AllowedValue.Builder)AllowedValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getDataOperationScopes() {
            if (this.dataOperationScopes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dataOperationScopes;
        }

        public final void setDataOperationScopes(Collection<String> dataOperationScopes) {
            this.dataOperationScopes = DataOperationsCopier.copy(dataOperationScopes);
        }

        @Override
        public final Builder dataOperationScopesWithStrings(Collection<String> dataOperationScopes) {
            this.dataOperationScopes = DataOperationsCopier.copy(dataOperationScopes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataOperationScopesWithStrings(String ... dataOperationScopes) {
            this.dataOperationScopesWithStrings(Arrays.asList(dataOperationScopes));
            return this;
        }

        @Override
        public final Builder dataOperationScopes(Collection<DataOperation> dataOperationScopes) {
            this.dataOperationScopes = DataOperationsCopier.copyEnumToString(dataOperationScopes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataOperationScopes(DataOperation ... dataOperationScopes) {
            this.dataOperationScopes(Arrays.asList(dataOperationScopes));
            return this;
        }

        public Property build() {
            return new Property(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Property> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder required(Boolean var1);

        public Builder defaultValue(String var1);

        public Builder propertyTypesWithStrings(Collection<String> var1);

        public Builder propertyTypesWithStrings(String ... var1);

        public Builder propertyTypes(Collection<PropertyType> var1);

        public Builder propertyTypes(PropertyType ... var1);

        public Builder allowedValues(Collection<AllowedValue> var1);

        public Builder allowedValues(AllowedValue ... var1);

        public Builder allowedValues(Consumer<AllowedValue.Builder> ... var1);

        public Builder dataOperationScopesWithStrings(Collection<String> var1);

        public Builder dataOperationScopesWithStrings(String ... var1);

        public Builder dataOperationScopes(Collection<DataOperation> var1);

        public Builder dataOperationScopes(DataOperation ... var1);
    }
}

