/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.glue.model.ConnectionPropertiesCopier;
import software.amazon.awssdk.services.glue.model.ConnectionPropertyKey;
import software.amazon.awssdk.services.glue.model.ConnectionType;
import software.amazon.awssdk.services.glue.model.MatchCriteriaCopier;
import software.amazon.awssdk.services.glue.model.PhysicalConnectionRequirements;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Connection
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Connection> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Connection.getter(Connection::name)).setter(Connection.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Connection.getter(Connection::description)).setter(Connection.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> CONNECTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Connection.getter(Connection::connectionTypeAsString)).setter(Connection.setter(Builder::connectionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionType").build()}).build();
    private static final SdkField<List<String>> MATCH_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Connection.getter(Connection::matchCriteria)).setter(Connection.setter(Builder::matchCriteria)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchCriteria").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> CONNECTION_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(Connection.getter(Connection::connectionPropertiesAsStrings)).setter(Connection.setter(Builder::connectionPropertiesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionProperties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<PhysicalConnectionRequirements> PHYSICAL_CONNECTION_REQUIREMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Connection.getter(Connection::physicalConnectionRequirements)).setter(Connection.setter(Builder::physicalConnectionRequirements)).constructor(PhysicalConnectionRequirements::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhysicalConnectionRequirements").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Connection.getter(Connection::creationTime)).setter(Connection.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Connection.getter(Connection::lastUpdatedTime)).setter(Connection.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()}).build();
    private static final SdkField<String> LAST_UPDATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Connection.getter(Connection::lastUpdatedBy)).setter(Connection.setter(Builder::lastUpdatedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedBy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, CONNECTION_TYPE_FIELD, MATCH_CRITERIA_FIELD, CONNECTION_PROPERTIES_FIELD, PHYSICAL_CONNECTION_REQUIREMENTS_FIELD, CREATION_TIME_FIELD, LAST_UPDATED_TIME_FIELD, LAST_UPDATED_BY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String description;
    private final String connectionType;
    private final List<String> matchCriteria;
    private final Map<String, String> connectionProperties;
    private final PhysicalConnectionRequirements physicalConnectionRequirements;
    private final Instant creationTime;
    private final Instant lastUpdatedTime;
    private final String lastUpdatedBy;

    private Connection(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.connectionType = builder.connectionType;
        this.matchCriteria = builder.matchCriteria;
        this.connectionProperties = builder.connectionProperties;
        this.physicalConnectionRequirements = builder.physicalConnectionRequirements;
        this.creationTime = builder.creationTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.lastUpdatedBy = builder.lastUpdatedBy;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public ConnectionType connectionType() {
        return ConnectionType.fromValue(this.connectionType);
    }

    public String connectionTypeAsString() {
        return this.connectionType;
    }

    public List<String> matchCriteria() {
        return this.matchCriteria;
    }

    public Map<ConnectionPropertyKey, String> connectionProperties() {
        return TypeConverter.convert(this.connectionProperties, ConnectionPropertyKey::fromValue, Function.identity(), (k, v) -> !Objects.equals(k, (Object)ConnectionPropertyKey.UNKNOWN_TO_SDK_VERSION));
    }

    public Map<String, String> connectionPropertiesAsStrings() {
        return this.connectionProperties;
    }

    public PhysicalConnectionRequirements physicalConnectionRequirements() {
        return this.physicalConnectionRequirements;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public String lastUpdatedBy() {
        return this.lastUpdatedBy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.matchCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionPropertiesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.physicalConnectionRequirements());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedBy());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Connection)) {
            return false;
        }
        Connection other = (Connection)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.connectionTypeAsString(), other.connectionTypeAsString()) && Objects.equals(this.matchCriteria(), other.matchCriteria()) && Objects.equals(this.connectionPropertiesAsStrings(), other.connectionPropertiesAsStrings()) && Objects.equals(this.physicalConnectionRequirements(), other.physicalConnectionRequirements()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.lastUpdatedBy(), other.lastUpdatedBy());
    }

    public String toString() {
        return ToString.builder((String)"Connection").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("ConnectionType", (Object)this.connectionTypeAsString()).add("MatchCriteria", this.matchCriteria()).add("ConnectionProperties", this.connectionPropertiesAsStrings()).add("PhysicalConnectionRequirements", (Object)this.physicalConnectionRequirements()).add("CreationTime", (Object)this.creationTime()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("LastUpdatedBy", (Object)this.lastUpdatedBy()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ConnectionType": {
                return Optional.ofNullable(clazz.cast(this.connectionTypeAsString()));
            }
            case "MatchCriteria": {
                return Optional.ofNullable(clazz.cast(this.matchCriteria()));
            }
            case "ConnectionProperties": {
                return Optional.ofNullable(clazz.cast(this.connectionPropertiesAsStrings()));
            }
            case "PhysicalConnectionRequirements": {
                return Optional.ofNullable(clazz.cast(this.physicalConnectionRequirements()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "LastUpdatedBy": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedBy()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Connection, T> g) {
        return obj -> g.apply((Connection)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String connectionType;
        private List<String> matchCriteria = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> connectionProperties = DefaultSdkAutoConstructMap.getInstance();
        private PhysicalConnectionRequirements physicalConnectionRequirements;
        private Instant creationTime;
        private Instant lastUpdatedTime;
        private String lastUpdatedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(Connection model) {
            this.name(model.name);
            this.description(model.description);
            this.connectionType(model.connectionType);
            this.matchCriteria(model.matchCriteria);
            this.connectionPropertiesWithStrings(model.connectionProperties);
            this.physicalConnectionRequirements(model.physicalConnectionRequirements);
            this.creationTime(model.creationTime);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.lastUpdatedBy(model.lastUpdatedBy);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getConnectionTypeAsString() {
            return this.connectionType;
        }

        @Override
        public final Builder connectionType(String connectionType) {
            this.connectionType = connectionType;
            return this;
        }

        @Override
        public final Builder connectionType(ConnectionType connectionType) {
            this.connectionType(connectionType.toString());
            return this;
        }

        public final void setConnectionType(String connectionType) {
            this.connectionType = connectionType;
        }

        public final Collection<String> getMatchCriteria() {
            return this.matchCriteria;
        }

        @Override
        public final Builder matchCriteria(Collection<String> matchCriteria) {
            this.matchCriteria = MatchCriteriaCopier.copy(matchCriteria);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchCriteria(String ... matchCriteria) {
            this.matchCriteria(Arrays.asList(matchCriteria));
            return this;
        }

        public final void setMatchCriteria(Collection<String> matchCriteria) {
            this.matchCriteria = MatchCriteriaCopier.copy(matchCriteria);
        }

        public final Map<String, String> getConnectionPropertiesAsStrings() {
            return this.connectionProperties;
        }

        @Override
        public final Builder connectionPropertiesWithStrings(Map<String, String> connectionProperties) {
            this.connectionProperties = ConnectionPropertiesCopier.copy(connectionProperties);
            return this;
        }

        @Override
        public final Builder connectionProperties(Map<ConnectionPropertyKey, String> connectionProperties) {
            this.connectionProperties = ConnectionPropertiesCopier.copyEnumToString(connectionProperties);
            return this;
        }

        public final void setConnectionPropertiesWithStrings(Map<String, String> connectionProperties) {
            this.connectionProperties = ConnectionPropertiesCopier.copy(connectionProperties);
        }

        public final PhysicalConnectionRequirements.Builder getPhysicalConnectionRequirements() {
            return this.physicalConnectionRequirements != null ? this.physicalConnectionRequirements.toBuilder() : null;
        }

        @Override
        public final Builder physicalConnectionRequirements(PhysicalConnectionRequirements physicalConnectionRequirements) {
            this.physicalConnectionRequirements = physicalConnectionRequirements;
            return this;
        }

        public final void setPhysicalConnectionRequirements(PhysicalConnectionRequirements.BuilderImpl physicalConnectionRequirements) {
            this.physicalConnectionRequirements = physicalConnectionRequirements != null ? physicalConnectionRequirements.build() : null;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        public final String getLastUpdatedBy() {
            return this.lastUpdatedBy;
        }

        @Override
        public final Builder lastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
            return this;
        }

        public final void setLastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
        }

        public Connection build() {
            return new Connection(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Connection> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder connectionType(String var1);

        public Builder connectionType(ConnectionType var1);

        public Builder matchCriteria(Collection<String> var1);

        public Builder matchCriteria(String ... var1);

        public Builder connectionPropertiesWithStrings(Map<String, String> var1);

        public Builder connectionProperties(Map<ConnectionPropertyKey, String> var1);

        public Builder physicalConnectionRequirements(PhysicalConnectionRequirements var1);

        default public Builder physicalConnectionRequirements(Consumer<PhysicalConnectionRequirements.Builder> physicalConnectionRequirements) {
            return this.physicalConnectionRequirements((PhysicalConnectionRequirements)((PhysicalConnectionRequirements.Builder)PhysicalConnectionRequirements.builder().applyMutation(physicalConnectionRequirements)).build());
        }

        public Builder creationTime(Instant var1);

        public Builder lastUpdatedTime(Instant var1);

        public Builder lastUpdatedBy(String var1);
    }
}

