/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.Table;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TableVersion
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TableVersion> {
    private static final SdkField<Table> TABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(TableVersion.getter(TableVersion::table)).setter(TableVersion.setter(Builder::table)).constructor(Table::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Table").build()}).build();
    private static final SdkField<String> VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TableVersion.getter(TableVersion::versionId)).setter(TableVersion.setter(Builder::versionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_FIELD, VERSION_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final Table table;
    private final String versionId;

    private TableVersion(BuilderImpl builder) {
        this.table = builder.table;
        this.versionId = builder.versionId;
    }

    public Table table() {
        return this.table;
    }

    public String versionId() {
        return this.versionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.table());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableVersion)) {
            return false;
        }
        TableVersion other = (TableVersion)obj;
        return Objects.equals(this.table(), other.table()) && Objects.equals(this.versionId(), other.versionId());
    }

    public String toString() {
        return ToString.builder((String)"TableVersion").add("Table", (Object)this.table()).add("VersionId", (Object)this.versionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Table": {
                return Optional.ofNullable(clazz.cast(this.table()));
            }
            case "VersionId": {
                return Optional.ofNullable(clazz.cast(this.versionId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TableVersion, T> g) {
        return obj -> g.apply((TableVersion)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Table table;
        private String versionId;

        private BuilderImpl() {
        }

        private BuilderImpl(TableVersion model) {
            this.table(model.table);
            this.versionId(model.versionId);
        }

        public final Table.Builder getTable() {
            return this.table != null ? this.table.toBuilder() : null;
        }

        @Override
        public final Builder table(Table table) {
            this.table = table;
            return this;
        }

        public final void setTable(Table.BuilderImpl table) {
            this.table = table != null ? table.build() : null;
        }

        public final String getVersionId() {
            return this.versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        public TableVersion build() {
            return new TableVersion(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TableVersion> {
        public Builder table(Table var1);

        default public Builder table(Consumer<Table.Builder> table) {
            return this.table((Table)((Table.Builder)Table.builder().applyMutation(table)).build());
        }

        public Builder versionId(String var1);
    }
}

