/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueAsyncClient;
import software.amazon.awssdk.services.glue.internal.UserAgentUtils;
import software.amazon.awssdk.services.glue.model.ListDataQualityRulesetEvaluationRunsRequest;
import software.amazon.awssdk.services.glue.model.ListDataQualityRulesetEvaluationRunsResponse;

public class ListDataQualityRulesetEvaluationRunsPublisher
implements SdkPublisher<ListDataQualityRulesetEvaluationRunsResponse> {
    private final GlueAsyncClient client;
    private final ListDataQualityRulesetEvaluationRunsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDataQualityRulesetEvaluationRunsPublisher(GlueAsyncClient client, ListDataQualityRulesetEvaluationRunsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDataQualityRulesetEvaluationRunsPublisher(GlueAsyncClient client, ListDataQualityRulesetEvaluationRunsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDataQualityRulesetEvaluationRunsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDataQualityRulesetEvaluationRunsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListDataQualityRulesetEvaluationRunsResponseFetcher
    implements AsyncPageFetcher<ListDataQualityRulesetEvaluationRunsResponse> {
        private ListDataQualityRulesetEvaluationRunsResponseFetcher() {
        }

        public boolean hasNextPage(ListDataQualityRulesetEvaluationRunsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDataQualityRulesetEvaluationRunsResponse> nextPage(ListDataQualityRulesetEvaluationRunsResponse previousPage) {
            if (previousPage == null) {
                return ListDataQualityRulesetEvaluationRunsPublisher.this.client.listDataQualityRulesetEvaluationRuns(ListDataQualityRulesetEvaluationRunsPublisher.this.firstRequest);
            }
            return ListDataQualityRulesetEvaluationRunsPublisher.this.client.listDataQualityRulesetEvaluationRuns((ListDataQualityRulesetEvaluationRunsRequest)((Object)ListDataQualityRulesetEvaluationRunsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

