/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.glue.model.CatalogPropertiesOutput;
import software.amazon.awssdk.services.glue.model.FederatedCatalog;
import software.amazon.awssdk.services.glue.model.ParametersMapCopier;
import software.amazon.awssdk.services.glue.model.PrincipalPermissions;
import software.amazon.awssdk.services.glue.model.PrincipalPermissionsListCopier;
import software.amazon.awssdk.services.glue.model.TargetRedshiftCatalog;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Catalog
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Catalog> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CatalogId").getter(Catalog.getter(Catalog::catalogId)).setter(Catalog.setter(Builder::catalogId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Catalog.getter(Catalog::name)).setter(Catalog.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(Catalog.getter(Catalog::resourceArn)).setter(Catalog.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(Catalog.getter(Catalog::description)).setter(Catalog.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Map<String, String>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Parameters").getter(Catalog.getter(Catalog::parameters)).setter(Catalog.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateTime").getter(Catalog.getter(Catalog::createTime)).setter(Catalog.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build()}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdateTime").getter(Catalog.getter(Catalog::updateTime)).setter(Catalog.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateTime").build()}).build();
    private static final SdkField<TargetRedshiftCatalog> TARGET_REDSHIFT_CATALOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TargetRedshiftCatalog").getter(Catalog.getter(Catalog::targetRedshiftCatalog)).setter(Catalog.setter(Builder::targetRedshiftCatalog)).constructor(TargetRedshiftCatalog::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetRedshiftCatalog").build()}).build();
    private static final SdkField<FederatedCatalog> FEDERATED_CATALOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FederatedCatalog").getter(Catalog.getter(Catalog::federatedCatalog)).setter(Catalog.setter(Builder::federatedCatalog)).constructor(FederatedCatalog::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FederatedCatalog").build()}).build();
    private static final SdkField<CatalogPropertiesOutput> CATALOG_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CatalogProperties").getter(Catalog.getter(Catalog::catalogProperties)).setter(Catalog.setter(Builder::catalogProperties)).constructor(CatalogPropertiesOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogProperties").build()}).build();
    private static final SdkField<List<PrincipalPermissions>> CREATE_TABLE_DEFAULT_PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CreateTableDefaultPermissions").getter(Catalog.getter(Catalog::createTableDefaultPermissions)).setter(Catalog.setter(Builder::createTableDefaultPermissions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTableDefaultPermissions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PrincipalPermissions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<PrincipalPermissions>> CREATE_DATABASE_DEFAULT_PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CreateDatabaseDefaultPermissions").getter(Catalog.getter(Catalog::createDatabaseDefaultPermissions)).setter(Catalog.setter(Builder::createDatabaseDefaultPermissions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDatabaseDefaultPermissions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PrincipalPermissions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD, NAME_FIELD, RESOURCE_ARN_FIELD, DESCRIPTION_FIELD, PARAMETERS_FIELD, CREATE_TIME_FIELD, UPDATE_TIME_FIELD, TARGET_REDSHIFT_CATALOG_FIELD, FEDERATED_CATALOG_FIELD, CATALOG_PROPERTIES_FIELD, CREATE_TABLE_DEFAULT_PERMISSIONS_FIELD, CREATE_DATABASE_DEFAULT_PERMISSIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Catalog.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String catalogId;
    private final String name;
    private final String resourceArn;
    private final String description;
    private final Map<String, String> parameters;
    private final Instant createTime;
    private final Instant updateTime;
    private final TargetRedshiftCatalog targetRedshiftCatalog;
    private final FederatedCatalog federatedCatalog;
    private final CatalogPropertiesOutput catalogProperties;
    private final List<PrincipalPermissions> createTableDefaultPermissions;
    private final List<PrincipalPermissions> createDatabaseDefaultPermissions;

    private Catalog(BuilderImpl builder) {
        this.catalogId = builder.catalogId;
        this.name = builder.name;
        this.resourceArn = builder.resourceArn;
        this.description = builder.description;
        this.parameters = builder.parameters;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.targetRedshiftCatalog = builder.targetRedshiftCatalog;
        this.federatedCatalog = builder.federatedCatalog;
        this.catalogProperties = builder.catalogProperties;
        this.createTableDefaultPermissions = builder.createTableDefaultPermissions;
        this.createDatabaseDefaultPermissions = builder.createDatabaseDefaultPermissions;
    }

    public final String catalogId() {
        return this.catalogId;
    }

    public final String name() {
        return this.name;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> parameters() {
        return this.parameters;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final Instant updateTime() {
        return this.updateTime;
    }

    public final TargetRedshiftCatalog targetRedshiftCatalog() {
        return this.targetRedshiftCatalog;
    }

    public final FederatedCatalog federatedCatalog() {
        return this.federatedCatalog;
    }

    public final CatalogPropertiesOutput catalogProperties() {
        return this.catalogProperties;
    }

    public final boolean hasCreateTableDefaultPermissions() {
        return this.createTableDefaultPermissions != null && !(this.createTableDefaultPermissions instanceof SdkAutoConstructList);
    }

    public final List<PrincipalPermissions> createTableDefaultPermissions() {
        return this.createTableDefaultPermissions;
    }

    public final boolean hasCreateDatabaseDefaultPermissions() {
        return this.createDatabaseDefaultPermissions != null && !(this.createDatabaseDefaultPermissions instanceof SdkAutoConstructList);
    }

    public final List<PrincipalPermissions> createDatabaseDefaultPermissions() {
        return this.createDatabaseDefaultPermissions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetRedshiftCatalog());
        hashCode = 31 * hashCode + Objects.hashCode(this.federatedCatalog());
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCreateTableDefaultPermissions() ? this.createTableDefaultPermissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCreateDatabaseDefaultPermissions() ? this.createDatabaseDefaultPermissions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Catalog)) {
            return false;
        }
        Catalog other = (Catalog)obj;
        return Objects.equals(this.catalogId(), other.catalogId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.description(), other.description()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.updateTime(), other.updateTime()) && Objects.equals(this.targetRedshiftCatalog(), other.targetRedshiftCatalog()) && Objects.equals(this.federatedCatalog(), other.federatedCatalog()) && Objects.equals(this.catalogProperties(), other.catalogProperties()) && this.hasCreateTableDefaultPermissions() == other.hasCreateTableDefaultPermissions() && Objects.equals(this.createTableDefaultPermissions(), other.createTableDefaultPermissions()) && this.hasCreateDatabaseDefaultPermissions() == other.hasCreateDatabaseDefaultPermissions() && Objects.equals(this.createDatabaseDefaultPermissions(), other.createDatabaseDefaultPermissions());
    }

    public final String toString() {
        return ToString.builder((String)"Catalog").add("CatalogId", (Object)this.catalogId()).add("Name", (Object)this.name()).add("ResourceArn", (Object)this.resourceArn()).add("Description", (Object)this.description()).add("Parameters", this.hasParameters() ? this.parameters() : null).add("CreateTime", (Object)this.createTime()).add("UpdateTime", (Object)this.updateTime()).add("TargetRedshiftCatalog", (Object)this.targetRedshiftCatalog()).add("FederatedCatalog", (Object)this.federatedCatalog()).add("CatalogProperties", (Object)this.catalogProperties()).add("CreateTableDefaultPermissions", this.hasCreateTableDefaultPermissions() ? this.createTableDefaultPermissions() : null).add("CreateDatabaseDefaultPermissions", this.hasCreateDatabaseDefaultPermissions() ? this.createDatabaseDefaultPermissions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CatalogId": {
                return Optional.ofNullable(clazz.cast(this.catalogId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "CreateTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "UpdateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
            case "TargetRedshiftCatalog": {
                return Optional.ofNullable(clazz.cast(this.targetRedshiftCatalog()));
            }
            case "FederatedCatalog": {
                return Optional.ofNullable(clazz.cast(this.federatedCatalog()));
            }
            case "CatalogProperties": {
                return Optional.ofNullable(clazz.cast(this.catalogProperties()));
            }
            case "CreateTableDefaultPermissions": {
                return Optional.ofNullable(clazz.cast(this.createTableDefaultPermissions()));
            }
            case "CreateDatabaseDefaultPermissions": {
                return Optional.ofNullable(clazz.cast(this.createDatabaseDefaultPermissions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CatalogId", CATALOG_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("ResourceArn", RESOURCE_ARN_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Parameters", PARAMETERS_FIELD);
        map.put("CreateTime", CREATE_TIME_FIELD);
        map.put("UpdateTime", UPDATE_TIME_FIELD);
        map.put("TargetRedshiftCatalog", TARGET_REDSHIFT_CATALOG_FIELD);
        map.put("FederatedCatalog", FEDERATED_CATALOG_FIELD);
        map.put("CatalogProperties", CATALOG_PROPERTIES_FIELD);
        map.put("CreateTableDefaultPermissions", CREATE_TABLE_DEFAULT_PERMISSIONS_FIELD);
        map.put("CreateDatabaseDefaultPermissions", CREATE_DATABASE_DEFAULT_PERMISSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Catalog, T> g) {
        return obj -> g.apply((Catalog)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String catalogId;
        private String name;
        private String resourceArn;
        private String description;
        private Map<String, String> parameters = DefaultSdkAutoConstructMap.getInstance();
        private Instant createTime;
        private Instant updateTime;
        private TargetRedshiftCatalog targetRedshiftCatalog;
        private FederatedCatalog federatedCatalog;
        private CatalogPropertiesOutput catalogProperties;
        private List<PrincipalPermissions> createTableDefaultPermissions = DefaultSdkAutoConstructList.getInstance();
        private List<PrincipalPermissions> createDatabaseDefaultPermissions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Catalog model) {
            this.catalogId(model.catalogId);
            this.name(model.name);
            this.resourceArn(model.resourceArn);
            this.description(model.description);
            this.parameters(model.parameters);
            this.createTime(model.createTime);
            this.updateTime(model.updateTime);
            this.targetRedshiftCatalog(model.targetRedshiftCatalog);
            this.federatedCatalog(model.federatedCatalog);
            this.catalogProperties(model.catalogProperties);
            this.createTableDefaultPermissions(model.createTableDefaultPermissions);
            this.createDatabaseDefaultPermissions(model.createDatabaseDefaultPermissions);
        }

        public final String getCatalogId() {
            return this.catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, String> getParameters() {
            if (this.parameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.parameters;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
            return this;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final TargetRedshiftCatalog.Builder getTargetRedshiftCatalog() {
            return this.targetRedshiftCatalog != null ? this.targetRedshiftCatalog.toBuilder() : null;
        }

        public final void setTargetRedshiftCatalog(TargetRedshiftCatalog.BuilderImpl targetRedshiftCatalog) {
            this.targetRedshiftCatalog = targetRedshiftCatalog != null ? targetRedshiftCatalog.build() : null;
        }

        @Override
        public final Builder targetRedshiftCatalog(TargetRedshiftCatalog targetRedshiftCatalog) {
            this.targetRedshiftCatalog = targetRedshiftCatalog;
            return this;
        }

        public final FederatedCatalog.Builder getFederatedCatalog() {
            return this.federatedCatalog != null ? this.federatedCatalog.toBuilder() : null;
        }

        public final void setFederatedCatalog(FederatedCatalog.BuilderImpl federatedCatalog) {
            this.federatedCatalog = federatedCatalog != null ? federatedCatalog.build() : null;
        }

        @Override
        public final Builder federatedCatalog(FederatedCatalog federatedCatalog) {
            this.federatedCatalog = federatedCatalog;
            return this;
        }

        public final CatalogPropertiesOutput.Builder getCatalogProperties() {
            return this.catalogProperties != null ? this.catalogProperties.toBuilder() : null;
        }

        public final void setCatalogProperties(CatalogPropertiesOutput.BuilderImpl catalogProperties) {
            this.catalogProperties = catalogProperties != null ? catalogProperties.build() : null;
        }

        @Override
        public final Builder catalogProperties(CatalogPropertiesOutput catalogProperties) {
            this.catalogProperties = catalogProperties;
            return this;
        }

        public final List<PrincipalPermissions.Builder> getCreateTableDefaultPermissions() {
            List<PrincipalPermissions.Builder> result = PrincipalPermissionsListCopier.copyToBuilder(this.createTableDefaultPermissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCreateTableDefaultPermissions(Collection<PrincipalPermissions.BuilderImpl> createTableDefaultPermissions) {
            this.createTableDefaultPermissions = PrincipalPermissionsListCopier.copyFromBuilder(createTableDefaultPermissions);
        }

        @Override
        public final Builder createTableDefaultPermissions(Collection<PrincipalPermissions> createTableDefaultPermissions) {
            this.createTableDefaultPermissions = PrincipalPermissionsListCopier.copy(createTableDefaultPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder createTableDefaultPermissions(PrincipalPermissions ... createTableDefaultPermissions) {
            this.createTableDefaultPermissions(Arrays.asList(createTableDefaultPermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder createTableDefaultPermissions(Consumer<PrincipalPermissions.Builder> ... createTableDefaultPermissions) {
            this.createTableDefaultPermissions(Stream.of(createTableDefaultPermissions).map(c -> (PrincipalPermissions)((PrincipalPermissions.Builder)PrincipalPermissions.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<PrincipalPermissions.Builder> getCreateDatabaseDefaultPermissions() {
            List<PrincipalPermissions.Builder> result = PrincipalPermissionsListCopier.copyToBuilder(this.createDatabaseDefaultPermissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCreateDatabaseDefaultPermissions(Collection<PrincipalPermissions.BuilderImpl> createDatabaseDefaultPermissions) {
            this.createDatabaseDefaultPermissions = PrincipalPermissionsListCopier.copyFromBuilder(createDatabaseDefaultPermissions);
        }

        @Override
        public final Builder createDatabaseDefaultPermissions(Collection<PrincipalPermissions> createDatabaseDefaultPermissions) {
            this.createDatabaseDefaultPermissions = PrincipalPermissionsListCopier.copy(createDatabaseDefaultPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder createDatabaseDefaultPermissions(PrincipalPermissions ... createDatabaseDefaultPermissions) {
            this.createDatabaseDefaultPermissions(Arrays.asList(createDatabaseDefaultPermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder createDatabaseDefaultPermissions(Consumer<PrincipalPermissions.Builder> ... createDatabaseDefaultPermissions) {
            this.createDatabaseDefaultPermissions(Stream.of(createDatabaseDefaultPermissions).map(c -> (PrincipalPermissions)((PrincipalPermissions.Builder)PrincipalPermissions.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Catalog build() {
            return new Catalog(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Catalog> {
        public Builder catalogId(String var1);

        public Builder name(String var1);

        public Builder resourceArn(String var1);

        public Builder description(String var1);

        public Builder parameters(Map<String, String> var1);

        public Builder createTime(Instant var1);

        public Builder updateTime(Instant var1);

        public Builder targetRedshiftCatalog(TargetRedshiftCatalog var1);

        default public Builder targetRedshiftCatalog(Consumer<TargetRedshiftCatalog.Builder> targetRedshiftCatalog) {
            return this.targetRedshiftCatalog((TargetRedshiftCatalog)((TargetRedshiftCatalog.Builder)TargetRedshiftCatalog.builder().applyMutation(targetRedshiftCatalog)).build());
        }

        public Builder federatedCatalog(FederatedCatalog var1);

        default public Builder federatedCatalog(Consumer<FederatedCatalog.Builder> federatedCatalog) {
            return this.federatedCatalog((FederatedCatalog)((FederatedCatalog.Builder)FederatedCatalog.builder().applyMutation(federatedCatalog)).build());
        }

        public Builder catalogProperties(CatalogPropertiesOutput var1);

        default public Builder catalogProperties(Consumer<CatalogPropertiesOutput.Builder> catalogProperties) {
            return this.catalogProperties((CatalogPropertiesOutput)((CatalogPropertiesOutput.Builder)CatalogPropertiesOutput.builder().applyMutation(catalogProperties)).build());
        }

        public Builder createTableDefaultPermissions(Collection<PrincipalPermissions> var1);

        public Builder createTableDefaultPermissions(PrincipalPermissions ... var1);

        public Builder createTableDefaultPermissions(Consumer<PrincipalPermissions.Builder> ... var1);

        public Builder createDatabaseDefaultPermissions(Collection<PrincipalPermissions> var1);

        public Builder createDatabaseDefaultPermissions(PrincipalPermissions ... var1);

        public Builder createDatabaseDefaultPermissions(Consumer<PrincipalPermissions.Builder> ... var1);
    }
}

