/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueAsyncClient;
import software.amazon.awssdk.services.glue.internal.UserAgentUtils;
import software.amazon.awssdk.services.glue.model.ListBlueprintsRequest;
import software.amazon.awssdk.services.glue.model.ListBlueprintsResponse;

public class ListBlueprintsPublisher
implements SdkPublisher<ListBlueprintsResponse> {
    private final GlueAsyncClient client;
    private final ListBlueprintsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListBlueprintsPublisher(GlueAsyncClient client, ListBlueprintsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListBlueprintsPublisher(GlueAsyncClient client, ListBlueprintsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListBlueprintsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListBlueprintsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> blueprints() {
        Function<ListBlueprintsResponse, Iterator> getIterator = response -> {
            if (response != null && response.blueprints() != null) {
                return response.blueprints().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListBlueprintsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListBlueprintsResponseFetcher
    implements AsyncPageFetcher<ListBlueprintsResponse> {
        private ListBlueprintsResponseFetcher() {
        }

        public boolean hasNextPage(ListBlueprintsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListBlueprintsResponse> nextPage(ListBlueprintsResponse previousPage) {
            if (previousPage == null) {
                return ListBlueprintsPublisher.this.client.listBlueprints(ListBlueprintsPublisher.this.firstRequest);
            }
            return ListBlueprintsPublisher.this.client.listBlueprints((ListBlueprintsRequest)((Object)ListBlueprintsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

