/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.ColumnStatisticsTaskRunIdListCopier;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListColumnStatisticsTaskRunsResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, ListColumnStatisticsTaskRunsResponse> {
    private static final SdkField<List<String>> COLUMN_STATISTICS_TASK_RUN_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ColumnStatisticsTaskRunIds").getter(ListColumnStatisticsTaskRunsResponse.getter(ListColumnStatisticsTaskRunsResponse::columnStatisticsTaskRunIds)).setter(ListColumnStatisticsTaskRunsResponse.setter(Builder::columnStatisticsTaskRunIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnStatisticsTaskRunIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListColumnStatisticsTaskRunsResponse.getter(ListColumnStatisticsTaskRunsResponse::nextToken)).setter(ListColumnStatisticsTaskRunsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_STATISTICS_TASK_RUN_IDS_FIELD, NEXT_TOKEN_FIELD));
    private final List<String> columnStatisticsTaskRunIds;
    private final String nextToken;

    private ListColumnStatisticsTaskRunsResponse(BuilderImpl builder) {
        super(builder);
        this.columnStatisticsTaskRunIds = builder.columnStatisticsTaskRunIds;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasColumnStatisticsTaskRunIds() {
        return this.columnStatisticsTaskRunIds != null && !(this.columnStatisticsTaskRunIds instanceof SdkAutoConstructList);
    }

    public final List<String> columnStatisticsTaskRunIds() {
        return this.columnStatisticsTaskRunIds;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasColumnStatisticsTaskRunIds() ? this.columnStatisticsTaskRunIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListColumnStatisticsTaskRunsResponse)) {
            return false;
        }
        ListColumnStatisticsTaskRunsResponse other = (ListColumnStatisticsTaskRunsResponse)((Object)obj);
        return this.hasColumnStatisticsTaskRunIds() == other.hasColumnStatisticsTaskRunIds() && Objects.equals(this.columnStatisticsTaskRunIds(), other.columnStatisticsTaskRunIds()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListColumnStatisticsTaskRunsResponse").add("ColumnStatisticsTaskRunIds", this.hasColumnStatisticsTaskRunIds() ? this.columnStatisticsTaskRunIds() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ColumnStatisticsTaskRunIds": {
                return Optional.ofNullable(clazz.cast(this.columnStatisticsTaskRunIds()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListColumnStatisticsTaskRunsResponse, T> g) {
        return obj -> g.apply((ListColumnStatisticsTaskRunsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private List<String> columnStatisticsTaskRunIds = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListColumnStatisticsTaskRunsResponse model) {
            super(model);
            this.columnStatisticsTaskRunIds(model.columnStatisticsTaskRunIds);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getColumnStatisticsTaskRunIds() {
            if (this.columnStatisticsTaskRunIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.columnStatisticsTaskRunIds;
        }

        public final void setColumnStatisticsTaskRunIds(Collection<String> columnStatisticsTaskRunIds) {
            this.columnStatisticsTaskRunIds = ColumnStatisticsTaskRunIdListCopier.copy(columnStatisticsTaskRunIds);
        }

        @Override
        public final Builder columnStatisticsTaskRunIds(Collection<String> columnStatisticsTaskRunIds) {
            this.columnStatisticsTaskRunIds = ColumnStatisticsTaskRunIdListCopier.copy(columnStatisticsTaskRunIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnStatisticsTaskRunIds(String ... columnStatisticsTaskRunIds) {
            this.columnStatisticsTaskRunIds(Arrays.asList(columnStatisticsTaskRunIds));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListColumnStatisticsTaskRunsResponse build() {
            return new ListColumnStatisticsTaskRunsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListColumnStatisticsTaskRunsResponse> {
        public Builder columnStatisticsTaskRunIds(Collection<String> var1);

        public Builder columnStatisticsTaskRunIds(String ... var1);

        public Builder nextToken(String var1);
    }
}

