/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueAsyncClient;
import software.amazon.awssdk.services.glue.internal.UserAgentUtils;
import software.amazon.awssdk.services.glue.model.ListWorkflowsRequest;
import software.amazon.awssdk.services.glue.model.ListWorkflowsResponse;

public class ListWorkflowsPublisher
implements SdkPublisher<ListWorkflowsResponse> {
    private final GlueAsyncClient client;
    private final ListWorkflowsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListWorkflowsPublisher(GlueAsyncClient client, ListWorkflowsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListWorkflowsPublisher(GlueAsyncClient client, ListWorkflowsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListWorkflowsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListWorkflowsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> workflows() {
        Function<ListWorkflowsResponse, Iterator> getIterator = response -> {
            if (response != null && response.workflows() != null) {
                return response.workflows().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListWorkflowsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListWorkflowsResponseFetcher
    implements AsyncPageFetcher<ListWorkflowsResponse> {
        private ListWorkflowsResponseFetcher() {
        }

        public boolean hasNextPage(ListWorkflowsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListWorkflowsResponse> nextPage(ListWorkflowsResponse previousPage) {
            if (previousPage == null) {
                return ListWorkflowsPublisher.this.client.listWorkflows(ListWorkflowsPublisher.this.firstRequest);
            }
            return ListWorkflowsPublisher.this.client.listWorkflows((ListWorkflowsRequest)((Object)ListWorkflowsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

