/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueAsyncClient;
import software.amazon.awssdk.services.glue.internal.UserAgentUtils;
import software.amazon.awssdk.services.glue.model.GetMlTaskRunsRequest;
import software.amazon.awssdk.services.glue.model.GetMlTaskRunsResponse;

public class GetMLTaskRunsPublisher
implements SdkPublisher<GetMlTaskRunsResponse> {
    private final GlueAsyncClient client;
    private final GetMlTaskRunsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetMLTaskRunsPublisher(GlueAsyncClient client, GetMlTaskRunsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetMLTaskRunsPublisher(GlueAsyncClient client, GetMlTaskRunsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetMlTaskRunsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetMlTaskRunsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetMlTaskRunsResponseFetcher
    implements AsyncPageFetcher<GetMlTaskRunsResponse> {
        private GetMlTaskRunsResponseFetcher() {
        }

        public boolean hasNextPage(GetMlTaskRunsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetMlTaskRunsResponse> nextPage(GetMlTaskRunsResponse previousPage) {
            if (previousPage == null) {
                return GetMLTaskRunsPublisher.this.client.getMLTaskRuns(GetMLTaskRunsPublisher.this.firstRequest);
            }
            return GetMLTaskRunsPublisher.this.client.getMLTaskRuns((GetMlTaskRunsRequest)((Object)GetMLTaskRunsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

