/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.internal.UserAgentUtils;
import software.amazon.awssdk.services.glue.model.GetClassifiersRequest;
import software.amazon.awssdk.services.glue.model.GetClassifiersResponse;

public class GetClassifiersIterable
implements SdkIterable<GetClassifiersResponse> {
    private final GlueClient client;
    private final GetClassifiersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetClassifiersIterable(GlueClient client, GetClassifiersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetClassifiersResponseFetcher();
    }

    public Iterator<GetClassifiersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetClassifiersResponseFetcher
    implements SyncPageFetcher<GetClassifiersResponse> {
        private GetClassifiersResponseFetcher() {
        }

        public boolean hasNextPage(GetClassifiersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetClassifiersResponse nextPage(GetClassifiersResponse previousPage) {
            if (previousPage == null) {
                return GetClassifiersIterable.this.client.getClassifiers(GetClassifiersIterable.this.firstRequest);
            }
            return GetClassifiersIterable.this.client.getClassifiers((GetClassifiersRequest)((Object)GetClassifiersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

