/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.services.glue.model.SchemaDiffType;
import software.amazon.awssdk.services.glue.model.SchemaId;
import software.amazon.awssdk.services.glue.model.SchemaVersionNumber;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSchemaVersionsDiffRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, GetSchemaVersionsDiffRequest> {
    private static final SdkField<SchemaId> SCHEMA_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SchemaId").getter(GetSchemaVersionsDiffRequest.getter(GetSchemaVersionsDiffRequest::schemaId)).setter(GetSchemaVersionsDiffRequest.setter(Builder::schemaId)).constructor(SchemaId::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaId").build()}).build();
    private static final SdkField<SchemaVersionNumber> FIRST_SCHEMA_VERSION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FirstSchemaVersionNumber").getter(GetSchemaVersionsDiffRequest.getter(GetSchemaVersionsDiffRequest::firstSchemaVersionNumber)).setter(GetSchemaVersionsDiffRequest.setter(Builder::firstSchemaVersionNumber)).constructor(SchemaVersionNumber::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirstSchemaVersionNumber").build()}).build();
    private static final SdkField<SchemaVersionNumber> SECOND_SCHEMA_VERSION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SecondSchemaVersionNumber").getter(GetSchemaVersionsDiffRequest.getter(GetSchemaVersionsDiffRequest::secondSchemaVersionNumber)).setter(GetSchemaVersionsDiffRequest.setter(Builder::secondSchemaVersionNumber)).constructor(SchemaVersionNumber::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondSchemaVersionNumber").build()}).build();
    private static final SdkField<String> SCHEMA_DIFF_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SchemaDiffType").getter(GetSchemaVersionsDiffRequest.getter(GetSchemaVersionsDiffRequest::schemaDiffTypeAsString)).setter(GetSchemaVersionsDiffRequest.setter(Builder::schemaDiffType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaDiffType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_ID_FIELD, FIRST_SCHEMA_VERSION_NUMBER_FIELD, SECOND_SCHEMA_VERSION_NUMBER_FIELD, SCHEMA_DIFF_TYPE_FIELD));
    private final SchemaId schemaId;
    private final SchemaVersionNumber firstSchemaVersionNumber;
    private final SchemaVersionNumber secondSchemaVersionNumber;
    private final String schemaDiffType;

    private GetSchemaVersionsDiffRequest(BuilderImpl builder) {
        super(builder);
        this.schemaId = builder.schemaId;
        this.firstSchemaVersionNumber = builder.firstSchemaVersionNumber;
        this.secondSchemaVersionNumber = builder.secondSchemaVersionNumber;
        this.schemaDiffType = builder.schemaDiffType;
    }

    public final SchemaId schemaId() {
        return this.schemaId;
    }

    public final SchemaVersionNumber firstSchemaVersionNumber() {
        return this.firstSchemaVersionNumber;
    }

    public final SchemaVersionNumber secondSchemaVersionNumber() {
        return this.secondSchemaVersionNumber;
    }

    public final SchemaDiffType schemaDiffType() {
        return SchemaDiffType.fromValue(this.schemaDiffType);
    }

    public final String schemaDiffTypeAsString() {
        return this.schemaDiffType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaId());
        hashCode = 31 * hashCode + Objects.hashCode(this.firstSchemaVersionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.secondSchemaVersionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaDiffTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSchemaVersionsDiffRequest)) {
            return false;
        }
        GetSchemaVersionsDiffRequest other = (GetSchemaVersionsDiffRequest)((Object)obj);
        return Objects.equals(this.schemaId(), other.schemaId()) && Objects.equals(this.firstSchemaVersionNumber(), other.firstSchemaVersionNumber()) && Objects.equals(this.secondSchemaVersionNumber(), other.secondSchemaVersionNumber()) && Objects.equals(this.schemaDiffTypeAsString(), other.schemaDiffTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetSchemaVersionsDiffRequest").add("SchemaId", (Object)this.schemaId()).add("FirstSchemaVersionNumber", (Object)this.firstSchemaVersionNumber()).add("SecondSchemaVersionNumber", (Object)this.secondSchemaVersionNumber()).add("SchemaDiffType", (Object)this.schemaDiffTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SchemaId": {
                return Optional.ofNullable(clazz.cast(this.schemaId()));
            }
            case "FirstSchemaVersionNumber": {
                return Optional.ofNullable(clazz.cast(this.firstSchemaVersionNumber()));
            }
            case "SecondSchemaVersionNumber": {
                return Optional.ofNullable(clazz.cast(this.secondSchemaVersionNumber()));
            }
            case "SchemaDiffType": {
                return Optional.ofNullable(clazz.cast(this.schemaDiffTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSchemaVersionsDiffRequest, T> g) {
        return obj -> g.apply((GetSchemaVersionsDiffRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private SchemaId schemaId;
        private SchemaVersionNumber firstSchemaVersionNumber;
        private SchemaVersionNumber secondSchemaVersionNumber;
        private String schemaDiffType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSchemaVersionsDiffRequest model) {
            super(model);
            this.schemaId(model.schemaId);
            this.firstSchemaVersionNumber(model.firstSchemaVersionNumber);
            this.secondSchemaVersionNumber(model.secondSchemaVersionNumber);
            this.schemaDiffType(model.schemaDiffType);
        }

        public final SchemaId.Builder getSchemaId() {
            return this.schemaId != null ? this.schemaId.toBuilder() : null;
        }

        public final void setSchemaId(SchemaId.BuilderImpl schemaId) {
            this.schemaId = schemaId != null ? schemaId.build() : null;
        }

        @Override
        public final Builder schemaId(SchemaId schemaId) {
            this.schemaId = schemaId;
            return this;
        }

        public final SchemaVersionNumber.Builder getFirstSchemaVersionNumber() {
            return this.firstSchemaVersionNumber != null ? this.firstSchemaVersionNumber.toBuilder() : null;
        }

        public final void setFirstSchemaVersionNumber(SchemaVersionNumber.BuilderImpl firstSchemaVersionNumber) {
            this.firstSchemaVersionNumber = firstSchemaVersionNumber != null ? firstSchemaVersionNumber.build() : null;
        }

        @Override
        public final Builder firstSchemaVersionNumber(SchemaVersionNumber firstSchemaVersionNumber) {
            this.firstSchemaVersionNumber = firstSchemaVersionNumber;
            return this;
        }

        public final SchemaVersionNumber.Builder getSecondSchemaVersionNumber() {
            return this.secondSchemaVersionNumber != null ? this.secondSchemaVersionNumber.toBuilder() : null;
        }

        public final void setSecondSchemaVersionNumber(SchemaVersionNumber.BuilderImpl secondSchemaVersionNumber) {
            this.secondSchemaVersionNumber = secondSchemaVersionNumber != null ? secondSchemaVersionNumber.build() : null;
        }

        @Override
        public final Builder secondSchemaVersionNumber(SchemaVersionNumber secondSchemaVersionNumber) {
            this.secondSchemaVersionNumber = secondSchemaVersionNumber;
            return this;
        }

        public final String getSchemaDiffType() {
            return this.schemaDiffType;
        }

        public final void setSchemaDiffType(String schemaDiffType) {
            this.schemaDiffType = schemaDiffType;
        }

        @Override
        public final Builder schemaDiffType(String schemaDiffType) {
            this.schemaDiffType = schemaDiffType;
            return this;
        }

        @Override
        public final Builder schemaDiffType(SchemaDiffType schemaDiffType) {
            this.schemaDiffType(schemaDiffType == null ? null : schemaDiffType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetSchemaVersionsDiffRequest build() {
            return new GetSchemaVersionsDiffRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSchemaVersionsDiffRequest> {
        public Builder schemaId(SchemaId var1);

        default public Builder schemaId(Consumer<SchemaId.Builder> schemaId) {
            return this.schemaId((SchemaId)((SchemaId.Builder)SchemaId.builder().applyMutation(schemaId)).build());
        }

        public Builder firstSchemaVersionNumber(SchemaVersionNumber var1);

        default public Builder firstSchemaVersionNumber(Consumer<SchemaVersionNumber.Builder> firstSchemaVersionNumber) {
            return this.firstSchemaVersionNumber((SchemaVersionNumber)((SchemaVersionNumber.Builder)SchemaVersionNumber.builder().applyMutation(firstSchemaVersionNumber)).build());
        }

        public Builder secondSchemaVersionNumber(SchemaVersionNumber var1);

        default public Builder secondSchemaVersionNumber(Consumer<SchemaVersionNumber.Builder> secondSchemaVersionNumber) {
            return this.secondSchemaVersionNumber((SchemaVersionNumber)((SchemaVersionNumber.Builder)SchemaVersionNumber.builder().applyMutation(secondSchemaVersionNumber)).build());
        }

        public Builder schemaDiffType(String var1);

        public Builder schemaDiffType(SchemaDiffType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

