/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueAsyncClient;
import software.amazon.awssdk.services.glue.internal.UserAgentUtils;
import software.amazon.awssdk.services.glue.model.GetUserDefinedFunctionsRequest;
import software.amazon.awssdk.services.glue.model.GetUserDefinedFunctionsResponse;

public class GetUserDefinedFunctionsPublisher
implements SdkPublisher<GetUserDefinedFunctionsResponse> {
    private final GlueAsyncClient client;
    private final GetUserDefinedFunctionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetUserDefinedFunctionsPublisher(GlueAsyncClient client, GetUserDefinedFunctionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetUserDefinedFunctionsPublisher(GlueAsyncClient client, GetUserDefinedFunctionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetUserDefinedFunctionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetUserDefinedFunctionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetUserDefinedFunctionsResponseFetcher
    implements AsyncPageFetcher<GetUserDefinedFunctionsResponse> {
        private GetUserDefinedFunctionsResponseFetcher() {
        }

        public boolean hasNextPage(GetUserDefinedFunctionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetUserDefinedFunctionsResponse> nextPage(GetUserDefinedFunctionsResponse previousPage) {
            if (previousPage == null) {
                return GetUserDefinedFunctionsPublisher.this.client.getUserDefinedFunctions(GetUserDefinedFunctionsPublisher.this.firstRequest);
            }
            return GetUserDefinedFunctionsPublisher.this.client.getUserDefinedFunctions((GetUserDefinedFunctionsRequest)((Object)GetUserDefinedFunctionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

