/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.internal.UserAgentUtils;
import software.amazon.awssdk.services.glue.model.GetJobsRequest;
import software.amazon.awssdk.services.glue.model.GetJobsResponse;

public class GetJobsIterable
implements SdkIterable<GetJobsResponse> {
    private final GlueClient client;
    private final GetJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetJobsIterable(GlueClient client, GetJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetJobsResponseFetcher();
    }

    public Iterator<GetJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetJobsResponseFetcher
    implements SyncPageFetcher<GetJobsResponse> {
        private GetJobsResponseFetcher() {
        }

        public boolean hasNextPage(GetJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetJobsResponse nextPage(GetJobsResponse previousPage) {
            if (previousPage == null) {
                return GetJobsIterable.this.client.getJobs(GetJobsIterable.this.firstRequest);
            }
            return GetJobsIterable.this.client.getJobs((GetJobsRequest)((Object)GetJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

