/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DQTransformOutput {
    PRIMARY_INPUT("PrimaryInput"),
    EVALUATION_RESULTS("EvaluationResults"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DQTransformOutput> VALUE_MAP;
    private final String value;

    private DQTransformOutput(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DQTransformOutput fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DQTransformOutput> knownValues() {
        EnumSet<DQTransformOutput> knownValues = EnumSet.allOf(DQTransformOutput.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DQTransformOutput.class, DQTransformOutput::toString);
    }
}

