/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.model.GetUnfilteredPartitionsMetadataRequest;
import software.amazon.awssdk.services.glue.model.GetUnfilteredPartitionsMetadataResponse;

public class GetUnfilteredPartitionsMetadataIterable
implements SdkIterable<GetUnfilteredPartitionsMetadataResponse> {
    private final GlueClient client;
    private final GetUnfilteredPartitionsMetadataRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetUnfilteredPartitionsMetadataIterable(GlueClient client, GetUnfilteredPartitionsMetadataRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetUnfilteredPartitionsMetadataResponseFetcher();
    }

    public Iterator<GetUnfilteredPartitionsMetadataResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetUnfilteredPartitionsMetadataResponseFetcher
    implements SyncPageFetcher<GetUnfilteredPartitionsMetadataResponse> {
        private GetUnfilteredPartitionsMetadataResponseFetcher() {
        }

        public boolean hasNextPage(GetUnfilteredPartitionsMetadataResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetUnfilteredPartitionsMetadataResponse nextPage(GetUnfilteredPartitionsMetadataResponse previousPage) {
            if (previousPage == null) {
                return GetUnfilteredPartitionsMetadataIterable.this.client.getUnfilteredPartitionsMetadata(GetUnfilteredPartitionsMetadataIterable.this.firstRequest);
            }
            return GetUnfilteredPartitionsMetadataIterable.this.client.getUnfilteredPartitionsMetadata((GetUnfilteredPartitionsMetadataRequest)((Object)GetUnfilteredPartitionsMetadataIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

