/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueAsyncClient;
import software.amazon.awssdk.services.glue.model.GetCrawlersRequest;
import software.amazon.awssdk.services.glue.model.GetCrawlersResponse;

public class GetCrawlersPublisher
implements SdkPublisher<GetCrawlersResponse> {
    private final GlueAsyncClient client;
    private final GetCrawlersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetCrawlersPublisher(GlueAsyncClient client, GetCrawlersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetCrawlersPublisher(GlueAsyncClient client, GetCrawlersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetCrawlersResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetCrawlersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final GetCrawlersPublisher resume(GetCrawlersResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetCrawlersPublisher(this.client, (GetCrawlersRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetCrawlersPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super GetCrawlersResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class GetCrawlersResponseFetcher
    implements AsyncPageFetcher<GetCrawlersResponse> {
        private GetCrawlersResponseFetcher() {
        }

        public boolean hasNextPage(GetCrawlersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetCrawlersResponse> nextPage(GetCrawlersResponse previousPage) {
            if (previousPage == null) {
                return GetCrawlersPublisher.this.client.getCrawlers(GetCrawlersPublisher.this.firstRequest);
            }
            return GetCrawlersPublisher.this.client.getCrawlers((GetCrawlersRequest)((Object)GetCrawlersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

