/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.ExistCondition;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutResourcePolicyRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, PutResourcePolicyRequest> {
    private static final SdkField<String> POLICY_IN_JSON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutResourcePolicyRequest.getter(PutResourcePolicyRequest::policyInJson)).setter(PutResourcePolicyRequest.setter(Builder::policyInJson)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyInJson").build()}).build();
    private static final SdkField<String> POLICY_HASH_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutResourcePolicyRequest.getter(PutResourcePolicyRequest::policyHashCondition)).setter(PutResourcePolicyRequest.setter(Builder::policyHashCondition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyHashCondition").build()}).build();
    private static final SdkField<String> POLICY_EXISTS_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutResourcePolicyRequest.getter(PutResourcePolicyRequest::policyExistsConditionAsString)).setter(PutResourcePolicyRequest.setter(Builder::policyExistsCondition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyExistsCondition").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_IN_JSON_FIELD, POLICY_HASH_CONDITION_FIELD, POLICY_EXISTS_CONDITION_FIELD));
    private final String policyInJson;
    private final String policyHashCondition;
    private final String policyExistsCondition;

    private PutResourcePolicyRequest(BuilderImpl builder) {
        super(builder);
        this.policyInJson = builder.policyInJson;
        this.policyHashCondition = builder.policyHashCondition;
        this.policyExistsCondition = builder.policyExistsCondition;
    }

    public String policyInJson() {
        return this.policyInJson;
    }

    public String policyHashCondition() {
        return this.policyHashCondition;
    }

    public ExistCondition policyExistsCondition() {
        return ExistCondition.fromValue(this.policyExistsCondition);
    }

    public String policyExistsConditionAsString() {
        return this.policyExistsCondition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyInJson());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyHashCondition());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyExistsConditionAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutResourcePolicyRequest)) {
            return false;
        }
        PutResourcePolicyRequest other = (PutResourcePolicyRequest)((Object)obj);
        return Objects.equals(this.policyInJson(), other.policyInJson()) && Objects.equals(this.policyHashCondition(), other.policyHashCondition()) && Objects.equals(this.policyExistsConditionAsString(), other.policyExistsConditionAsString());
    }

    public String toString() {
        return ToString.builder((String)"PutResourcePolicyRequest").add("PolicyInJson", (Object)this.policyInJson()).add("PolicyHashCondition", (Object)this.policyHashCondition()).add("PolicyExistsCondition", (Object)this.policyExistsConditionAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyInJson": {
                return Optional.ofNullable(clazz.cast(this.policyInJson()));
            }
            case "PolicyHashCondition": {
                return Optional.ofNullable(clazz.cast(this.policyHashCondition()));
            }
            case "PolicyExistsCondition": {
                return Optional.ofNullable(clazz.cast(this.policyExistsConditionAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutResourcePolicyRequest, T> g) {
        return obj -> g.apply((PutResourcePolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String policyInJson;
        private String policyHashCondition;
        private String policyExistsCondition;

        private BuilderImpl() {
        }

        private BuilderImpl(PutResourcePolicyRequest model) {
            super(model);
            this.policyInJson(model.policyInJson);
            this.policyHashCondition(model.policyHashCondition);
            this.policyExistsCondition(model.policyExistsCondition);
        }

        public final String getPolicyInJson() {
            return this.policyInJson;
        }

        @Override
        public final Builder policyInJson(String policyInJson) {
            this.policyInJson = policyInJson;
            return this;
        }

        public final void setPolicyInJson(String policyInJson) {
            this.policyInJson = policyInJson;
        }

        public final String getPolicyHashCondition() {
            return this.policyHashCondition;
        }

        @Override
        public final Builder policyHashCondition(String policyHashCondition) {
            this.policyHashCondition = policyHashCondition;
            return this;
        }

        public final void setPolicyHashCondition(String policyHashCondition) {
            this.policyHashCondition = policyHashCondition;
        }

        public final String getPolicyExistsCondition() {
            return this.policyExistsCondition;
        }

        @Override
        public final Builder policyExistsCondition(String policyExistsCondition) {
            this.policyExistsCondition = policyExistsCondition;
            return this;
        }

        @Override
        public final Builder policyExistsCondition(ExistCondition policyExistsCondition) {
            this.policyExistsCondition(policyExistsCondition.toString());
            return this;
        }

        public final void setPolicyExistsCondition(String policyExistsCondition) {
            this.policyExistsCondition = policyExistsCondition;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutResourcePolicyRequest build() {
            return new PutResourcePolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutResourcePolicyRequest> {
        public Builder policyInJson(String var1);

        public Builder policyHashCondition(String var1);

        public Builder policyExistsCondition(String var1);

        public Builder policyExistsCondition(ExistCondition var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

